/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.Point;
import android.opengl.Matrix;
import android.view.View;

public class RendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    public static float[] getLayoutMatrix(boolean bl, float f2, float f3) {
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (f3 > f2) {
            f5 = f2 / f3;
        } else {
            f4 = f3 / f2;
        }
        if (bl) {
            f4 *= -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f4, (float)f5, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static android.graphics.Matrix convertMatrixToAndroidGraphicsMatrix(float[] fArray) {
        float[] fArray2 = new float[9];
        float[] fArray3 = fArray2;
        fArray3[0] = fArray[0];
        fArray3[1] = fArray[4];
        fArray3[2] = fArray[12];
        fArray3[3] = fArray[1];
        fArray3[4] = fArray[5];
        fArray3[5] = fArray[13];
        fArray3[6] = fArray[3];
        fArray3[7] = fArray[7];
        fArray2[8] = fArray[15];
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        matrix.setValues(fArray3);
        return matrix;
    }

    public static float[] convertMatrixFromAndroidGraphicsMatrix(android.graphics.Matrix object) {
        float[] fArray;
        android.graphics.Matrix matrix = object;
        float[] fArray2 = new float[9];
        object = fArray2;
        matrix.getValues(fArray2);
        float[] fArray3 = new float[16];
        float[] fArray4 = fArray = fArray3;
        fArray[0] = (float)object[0];
        fArray[1] = (float)object[3];
        fArray[2] = 0.0f;
        fArray[3] = (float)object[6];
        fArray[4] = (float)object[1];
        fArray[5] = (float)object[4];
        fArray[6] = 0.0f;
        fArray4[7] = (float)object[7];
        fArray4[8] = 0.0f;
        fArray4[9] = 0.0f;
        fArray4[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = (float)object[2];
        fArray[13] = (float)object[5];
        fArray[14] = 0.0f;
        fArray3[15] = (float)object[8];
        return fArray3;
    }

    public static Point getDisplaySize(ScalingType scalingType, float f2, int n, int n2) {
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), f2, n, n2);
    }

    private static void adjustOrigin(float[] fArray) {
        float[] fArray2 = fArray;
        fArray2[12] = fArray[12] - (fArray[0] + fArray[4]) * 0.5f;
        fArray2[13] = fArray[13] - (fArray[1] + fArray[5]) * 0.5f;
        fArray2[12] = fArray[12] + 0.5f;
        fArray2[13] = fArray[13] + 0.5f;
    }

    private static float convertScalingTypeToVisibleFraction(ScalingType scalingType) {
        int n = 1.$SwitchMap$org$otwebrtc$RendererCommon$ScalingType[scalingType.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    return BALANCED_VISIBLE_FRACTION;
                }
                throw new IllegalArgumentException();
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static Point getDisplaySize(float f2, float f3, int n, int n2) {
        if (f2 != 0.0f && f3 != 0.0f) {
            int n3 = n;
            n = Math.min(n3, Math.round((float)n2 / f2 * f3));
            int n4 = Math.min(n2, Math.round((float)n3 / f2 / f3));
            return new Point(n, n4);
        }
        return new Point(n, n2);
    }

    public static final class ScalingType
    extends Enum<ScalingType> {
        public static final /* enum */ ScalingType SCALE_ASPECT_FIT;
        public static final /* enum */ ScalingType SCALE_ASPECT_FILL;
        public static final /* enum */ ScalingType SCALE_ASPECT_BALANCED;
        private static final /* synthetic */ ScalingType[] $VALUES;

        public static ScalingType[] values() {
            return (ScalingType[])$VALUES.clone();
        }

        public static ScalingType valueOf(String string) {
            return Enum.valueOf(ScalingType.class, string);
        }

        static {
            ScalingType scalingType;
            SCALE_ASPECT_FIT = new ScalingType();
            SCALE_ASPECT_FILL = new ScalingType();
            ScalingType scalingType2 = scalingType;
            SCALE_ASPECT_BALANCED = new ScalingType();
            $VALUES = new ScalingType[]{SCALE_ASPECT_FIT, SCALE_ASPECT_FILL, scalingType2};
        }
    }

    public static class VideoLayoutMeasure {
        private float visibleFractionMatchOrientation = RendererCommon.access$000(ScalingType.SCALE_ASPECT_BALANCED);
        private float visibleFractionMismatchOrientation = RendererCommon.access$000(ScalingType.SCALE_ASPECT_BALANCED);

        public void setScalingType(ScalingType scalingType) {
            ScalingType scalingType2 = scalingType;
            this.setScalingType(scalingType2, scalingType2);
        }

        public void setScalingType(ScalingType scalingType, ScalingType scalingType2) {
            this.visibleFractionMatchOrientation = RendererCommon.convertScalingTypeToVisibleFraction(scalingType);
            this.visibleFractionMismatchOrientation = RendererCommon.convertScalingTypeToVisibleFraction(scalingType2);
        }

        public void setVisibleFraction(float f2, float f3) {
            VideoLayoutMeasure videoLayoutMeasure = this;
            videoLayoutMeasure.visibleFractionMatchOrientation = f2;
            videoLayoutMeasure.visibleFractionMismatchOrientation = f3;
        }

        public Point measure(int n, int n2, int n3, int n4) {
            int n5 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n);
            int n6 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n2);
            if (n3 != 0 && n4 != 0 && n5 != 0 && n6 != 0) {
                float f2;
                float f3 = (float)n3 / (float)n4;
                float f4 = (float)n5 / (float)n6;
                boolean bl = f2 > 1.0f;
                boolean bl2 = f4 > 1.0f;
                VideoLayoutMeasure videoLayoutMeasure = RendererCommon.getDisplaySize(bl == bl2 ? videoLayoutMeasure.visibleFractionMatchOrientation : videoLayoutMeasure.visibleFractionMismatchOrientation, f3, n5, n6);
                if (View.MeasureSpec.getMode((int)n) == 0x40000000) {
                    ((Point)videoLayoutMeasure).x = n5;
                }
                if (View.MeasureSpec.getMode((int)n2) == 0x40000000) {
                    ((Point)videoLayoutMeasure).y = n6;
                }
                return videoLayoutMeasure;
            }
            return new Point(n5, n6);
        }
    }

    public static interface GlDrawer {
        public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void release();
    }

    public static interface RendererEvents {
        public void onFirstFrameRendered();

        public void onFrameResolutionChanged(int var1, int var2, int var3);
    }
}

