/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.content.Context;
import android.os.Process;
import android.support.annotation.Nullable;
import java.util.List;
import org.otwebrtc.AudioDecoderFactoryFactory;
import org.otwebrtc.AudioEncoderFactoryFactory;
import org.otwebrtc.AudioProcessingFactory;
import org.otwebrtc.AudioSource;
import org.otwebrtc.AudioTrack;
import org.otwebrtc.BuiltinAudioDecoderFactoryFactory;
import org.otwebrtc.BuiltinAudioEncoderFactoryFactory;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.ContextUtils;
import org.otwebrtc.FecControllerFactoryFactoryInterface;
import org.otwebrtc.JNILogging;
import org.otwebrtc.Loggable;
import org.otwebrtc.Logging;
import org.otwebrtc.MediaConstraints;
import org.otwebrtc.MediaStream;
import org.otwebrtc.MediaTransportFactoryFactory;
import org.otwebrtc.NativeLibrary;
import org.otwebrtc.NativeLibraryLoader;
import org.otwebrtc.NetEqFactoryFactory;
import org.otwebrtc.NetworkControllerFactoryFactory;
import org.otwebrtc.NetworkStatePredictorFactoryFactory;
import org.otwebrtc.PeerConnection;
import org.otwebrtc.PeerConnectionDependencies;
import org.otwebrtc.SSLCertificateVerifier;
import org.otwebrtc.VideoDecoderFactory;
import org.otwebrtc.VideoEncoderFactory;
import org.otwebrtc.VideoSource;
import org.otwebrtc.VideoTrack;
import org.otwebrtc.audio.AudioDeviceModule;
import org.otwebrtc.audio.JavaAudioDeviceModule;

public class PeerConnectionFactory {
    public static final String TRIAL_ENABLED = "Enabled";
    @Deprecated
    public static final String VIDEO_FRAME_EMIT_TRIAL = "VideoFrameEmit";
    private static final String TAG = "PeerConnectionFactory";
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    private static volatile boolean internalTracerInitialized;
    @Nullable
    private static ThreadInfo staticNetworkThread;
    @Nullable
    private static ThreadInfo staticWorkerThread;
    @Nullable
    private static ThreadInfo staticSignalingThread;
    private long nativeFactory;
    @Nullable
    private volatile ThreadInfo networkThread;
    @Nullable
    private volatile ThreadInfo workerThread;
    @Nullable
    private volatile ThreadInfo signalingThread;

    public static Builder builder() {
        return new Builder();
    }

    public static void initialize(InitializationOptions initializationOptions) {
        Loggable loggable;
        InitializationOptions initializationOptions2 = initializationOptions;
        ContextUtils.initialize(initializationOptions2.applicationContext);
        NativeLibrary.initialize(initializationOptions2.nativeLibraryLoader, initializationOptions.nativeLibraryName);
        PeerConnectionFactory.nativeInitializeAndroidGlobals();
        PeerConnectionFactory.nativeInitializeFieldTrials(initializationOptions2.fieldTrials);
        if (initializationOptions2.enableInternalTracer && !internalTracerInitialized) {
            PeerConnectionFactory.initializeInternalTracer();
        }
        if ((loggable = initializationOptions.loggable) != null) {
            Logging.injectLoggable(loggable, initializationOptions.loggableSeverity);
            PeerConnectionFactory.nativeInjectLoggable(new JNILogging(initializationOptions.loggable), initializationOptions.loggableSeverity.ordinal());
        } else {
            Logging.d(TAG, "PeerConnectionFactory was initialized without an injected Loggable. Any existing Loggable will be deleted.");
            Logging.deleteInjectedLoggable();
            PeerConnectionFactory.nativeDeleteLoggable();
        }
    }

    private static void checkInitializeHasBeenCalled() {
        if (NativeLibrary.isLoaded() && ContextUtils.getApplicationContext() != null) {
            return;
        }
        throw new IllegalStateException("PeerConnectionFactory.initialize was not called before creating a PeerConnectionFactory.");
    }

    private static void initializeInternalTracer() {
        internalTracerInitialized = true;
        PeerConnectionFactory.nativeInitializeInternalTracer();
    }

    public static void shutdownInternalTracer() {
        internalTracerInitialized = false;
        PeerConnectionFactory.nativeShutdownInternalTracer();
    }

    @Deprecated
    public static void initializeFieldTrials(String string) {
        PeerConnectionFactory.nativeInitializeFieldTrials(string);
    }

    public static String fieldTrialsFindFullName(String string) {
        return NativeLibrary.isLoaded() ? PeerConnectionFactory.nativeFindFieldTrialsFullName(string) : "";
    }

    public static boolean startInternalTracingCapture(String string) {
        return PeerConnectionFactory.nativeStartInternalTracingCapture(string);
    }

    public static void stopInternalTracingCapture() {
        PeerConnectionFactory.nativeStopInternalTracingCapture();
    }

    @CalledByNative
    PeerConnectionFactory(long l) {
        PeerConnectionFactory.checkInitializeHasBeenCalled();
        if (l != 0L) {
            this.nativeFactory = l;
            return;
        }
        throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
    }

    private void checkPeerConnectionFactoryExists() {
        if (this.nativeFactory != 0L) {
            return;
        }
        throw new IllegalStateException("PeerConnectionFactory has been disposed.");
    }

    private static void printStackTrace(@Nullable ThreadInfo threadInfo, boolean bl) {
        if (threadInfo == null) {
            return;
        }
        ThreadInfo threadInfo2 = threadInfo;
        String string = threadInfo2.thread.getName();
        StackTraceElement[] stackTraceElementArray = threadInfo2.thread.getStackTrace();
        if (stackTraceElementArray.length > 0) {
            Logging.w(TAG, string + " stacktrace:");
            int n = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                Logging.w(TAG, stackTraceElementArray[i2].toString());
            }
        }
        if (bl) {
            Logging.w(TAG, "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
            Logging.w(TAG, "pid: " + Process.myPid() + ", tid: " + threadInfo.tid + ", name: " + string + "  >>> WebRTC <<<");
            PeerConnectionFactory.nativePrintStackTrace(threadInfo.tid);
        }
    }

    @Deprecated
    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(staticNetworkThread, false);
        PeerConnectionFactory.printStackTrace(staticWorkerThread, false);
        PeerConnectionFactory.printStackTrace(staticSignalingThread, false);
    }

    @CalledByNative
    private void onNetworkThreadReady() {
        staticNetworkThread = this.networkThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onNetworkThreadReady");
    }

    @CalledByNative
    private void onWorkerThreadReady() {
        staticWorkerThread = this.workerThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    @CalledByNative
    private void onSignalingThreadReady() {
        staticSignalingThread = this.signalingThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    private static native void nativeInitializeAndroidGlobals();

    private static native void nativeInitializeFieldTrials(String var0);

    private static native String nativeFindFieldTrialsFullName(String var0);

    private static native void nativeInitializeInternalTracer();

    private static native void nativeShutdownInternalTracer();

    private static native boolean nativeStartInternalTracingCapture(String var0);

    private static native void nativeStopInternalTracingCapture();

    private static native PeerConnectionFactory nativeCreatePeerConnectionFactory(Context var0, Options var1, long var2, long var4, long var6, VideoEncoderFactory var8, VideoDecoderFactory var9, long var10, long var12, long var14, long var16, long var18, long var20);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4, SSLCertificateVerifier var6);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreateVideoSource(long var0, boolean var2, boolean var3);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    private static native void nativeFreeFactory(long var0);

    private static native long nativeGetNativePeerConnectionFactory(long var0);

    private static native void nativeInjectLoggable(JNILogging var0, int var1);

    private static native void nativeDeleteLoggable();

    private static native void nativePrintStackTrace(int var0);

    private static native void nativePrintStackTracesOfRegisteredThreads();

    @Nullable
    PeerConnection createPeerConnectionInternal(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer, SSLCertificateVerifier sSLCertificateVerifier) {
        this.checkPeerConnectionFactoryExists();
        long l = PeerConnection.createNativePeerConnectionObserver(observer);
        if (l == 0L) {
            return null;
        }
        long l2 = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rTCConfiguration, mediaConstraints, l, sSLCertificateVerifier);
        if (l2 == 0L) {
            return null;
        }
        return new PeerConnection(l2);
    }

    @Deprecated
    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        return this.createPeerConnectionInternal(rTCConfiguration, mediaConstraints, observer, null);
    }

    @Deprecated
    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        return this.createPeerConnection(new PeerConnection.RTCConfiguration(list), mediaConstraints, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, PeerConnection.Observer observer) {
        return this.createPeerConnection(new PeerConnection.RTCConfiguration(list), observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, PeerConnection.Observer observer) {
        return this.createPeerConnection(rTCConfiguration, null, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration object, PeerConnectionDependencies peerConnectionDependencies) {
        PeerConnectionFactory peerConnectionFactory = observer;
        PeerConnection.RTCConfiguration rTCConfiguration = object;
        PeerConnectionDependencies peerConnectionDependencies2 = peerConnectionDependencies;
        PeerConnection.Observer observer = peerConnectionDependencies2.getObserver();
        object = peerConnectionDependencies2.getSSLCertificateVerifier();
        return peerConnectionFactory.createPeerConnectionInternal(rTCConfiguration, null, observer, (SSLCertificateVerifier)object);
    }

    public MediaStream createLocalMediaStream(String string) {
        this.checkPeerConnectionFactoryExists();
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, string));
    }

    public VideoSource createVideoSource(boolean bl, boolean bl2) {
        this.checkPeerConnectionFactoryExists();
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, bl, bl2));
    }

    public VideoSource createVideoSource(boolean bl) {
        return this.createVideoSource(bl, true);
    }

    public VideoTrack createVideoTrack(String string, VideoSource videoSource) {
        this.checkPeerConnectionFactoryExists();
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, string, videoSource.getNativeVideoTrackSource()));
    }

    public AudioSource createAudioSource(MediaConstraints mediaConstraints) {
        this.checkPeerConnectionFactoryExists();
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, mediaConstraints));
    }

    public AudioTrack createAudioTrack(String string, AudioSource audioSource) {
        this.checkPeerConnectionFactoryExists();
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, string, audioSource.getNativeAudioSource()));
    }

    public boolean startAecDump(int n, int n2) {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeStartAecDump(peerConnectionFactory.nativeFactory, n, n2);
    }

    public void stopAecDump() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeStopAecDump(peerConnectionFactory.nativeFactory);
    }

    public void dispose() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeFreeFactory(peerConnectionFactory.nativeFactory);
        peerConnectionFactory.networkThread = null;
        peerConnectionFactory.workerThread = null;
        peerConnectionFactory.signalingThread = null;
        peerConnectionFactory.nativeFactory = 0L;
    }

    public long getNativePeerConnectionFactory() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeGetNativePeerConnectionFactory(peerConnectionFactory.nativeFactory);
    }

    public long getNativeOwnedFactoryAndThreads() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        return peerConnectionFactory.nativeFactory;
    }

    public void printInternalStackTraces(boolean bl) {
        PeerConnectionFactory peerConnectionFactory = this;
        PeerConnectionFactory.printStackTrace(peerConnectionFactory.signalingThread, bl);
        PeerConnectionFactory.printStackTrace(peerConnectionFactory.workerThread, bl);
        PeerConnectionFactory.printStackTrace(peerConnectionFactory.networkThread, bl);
        if (bl) {
            PeerConnectionFactory.nativePrintStackTracesOfRegisteredThreads();
        }
    }

    public static class Builder {
        @Nullable
        private Options options;
        @Nullable
        private AudioDeviceModule audioDeviceModule;
        private AudioEncoderFactoryFactory audioEncoderFactoryFactory;
        private AudioDecoderFactoryFactory audioDecoderFactoryFactory;
        @Nullable
        private VideoEncoderFactory videoEncoderFactory;
        @Nullable
        private VideoDecoderFactory videoDecoderFactory;
        @Nullable
        private AudioProcessingFactory audioProcessingFactory;
        @Nullable
        private FecControllerFactoryFactoryInterface fecControllerFactoryFactory;
        @Nullable
        private NetworkControllerFactoryFactory networkControllerFactoryFactory;
        @Nullable
        private NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory;
        @Nullable
        private MediaTransportFactoryFactory mediaTransportFactoryFactory;
        @Nullable
        private NetEqFactoryFactory neteqFactoryFactory;

        private Builder() {
            BuiltinAudioDecoderFactoryFactory builtinAudioDecoderFactoryFactory;
            BuiltinAudioEncoderFactoryFactory builtinAudioEncoderFactoryFactory;
            Object object = builtinAudioEncoderFactoryFactory;
            builtinAudioEncoderFactoryFactory = new BuiltinAudioEncoderFactoryFactory();
            v1.audioEncoderFactoryFactory = object;
            object = builtinAudioDecoderFactoryFactory;
            builtinAudioDecoderFactoryFactory = new BuiltinAudioDecoderFactoryFactory();
            v1.audioDecoderFactoryFactory = object;
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setAudioDeviceModule(AudioDeviceModule audioDeviceModule) {
            this.audioDeviceModule = audioDeviceModule;
            return this;
        }

        public Builder setAudioEncoderFactoryFactory(AudioEncoderFactoryFactory audioEncoderFactoryFactory) {
            if (audioEncoderFactoryFactory != null) {
                this.audioEncoderFactoryFactory = audioEncoderFactoryFactory;
                return this;
            }
            throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioEncoderFactoryFactory.");
        }

        public Builder setAudioDecoderFactoryFactory(AudioDecoderFactoryFactory audioDecoderFactoryFactory) {
            if (audioDecoderFactoryFactory != null) {
                this.audioDecoderFactoryFactory = audioDecoderFactoryFactory;
                return this;
            }
            throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioDecoderFactoryFactory.");
        }

        public Builder setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
            this.videoEncoderFactory = videoEncoderFactory;
            return this;
        }

        public Builder setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
            this.videoDecoderFactory = videoDecoderFactory;
            return this;
        }

        public Builder setAudioProcessingFactory(AudioProcessingFactory audioProcessingFactory) {
            if (audioProcessingFactory != null) {
                this.audioProcessingFactory = audioProcessingFactory;
                return this;
            }
            throw new NullPointerException("PeerConnectionFactory builder does not accept a null AudioProcessingFactory.");
        }

        public Builder setFecControllerFactoryFactoryInterface(FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface) {
            this.fecControllerFactoryFactory = fecControllerFactoryFactoryInterface;
            return this;
        }

        public Builder setNetworkControllerFactoryFactory(NetworkControllerFactoryFactory networkControllerFactoryFactory) {
            this.networkControllerFactoryFactory = networkControllerFactoryFactory;
            return this;
        }

        public Builder setNetworkStatePredictorFactoryFactory(NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory) {
            this.networkStatePredictorFactoryFactory = networkStatePredictorFactoryFactory;
            return this;
        }

        public Builder setMediaTransportFactoryFactory(MediaTransportFactoryFactory mediaTransportFactoryFactory) {
            this.mediaTransportFactoryFactory = mediaTransportFactoryFactory;
            return this;
        }

        public Builder setNetEqFactoryFactory(NetEqFactoryFactory netEqFactoryFactory) {
            this.neteqFactoryFactory = netEqFactoryFactory;
            return this;
        }

        public PeerConnectionFactory createPeerConnectionFactory() {
            PeerConnectionFactory.checkInitializeHasBeenCalled();
            if (((Builder)((Object)netEqFactoryFactory)).audioDeviceModule == null) {
                ((Builder)((Object)netEqFactoryFactory)).audioDeviceModule = JavaAudioDeviceModule.builder(ContextUtils.getApplicationContext()).createAudioDeviceModule();
            }
            Builder builder = netEqFactoryFactory;
            Context context = ContextUtils.getApplicationContext();
            Options options = builder.options;
            long l = builder.audioDeviceModule.getNativeAudioDeviceModulePointer();
            long l2 = builder.audioEncoderFactoryFactory.createNativeAudioEncoderFactory();
            long l3 = builder.audioDecoderFactoryFactory.createNativeAudioDecoderFactory();
            VideoEncoderFactory videoEncoderFactory = builder.videoEncoderFactory;
            VideoDecoderFactory videoDecoderFactory = builder.videoDecoderFactory;
            AudioProcessingFactory audioProcessingFactory = builder.audioProcessingFactory;
            long l4 = audioProcessingFactory == null ? 0L : audioProcessingFactory.createNative();
            FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface = ((Builder)((Object)netEqFactoryFactory)).fecControllerFactoryFactory;
            long l5 = fecControllerFactoryFactoryInterface == null ? 0L : fecControllerFactoryFactoryInterface.createNative();
            NetworkControllerFactoryFactory networkControllerFactoryFactory = ((Builder)((Object)netEqFactoryFactory)).networkControllerFactoryFactory;
            long l6 = networkControllerFactoryFactory == null ? 0L : networkControllerFactoryFactory.createNativeNetworkControllerFactory();
            NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory = ((Builder)((Object)netEqFactoryFactory)).networkStatePredictorFactoryFactory;
            long l7 = networkStatePredictorFactoryFactory == null ? 0L : networkStatePredictorFactoryFactory.createNativeNetworkStatePredictorFactory();
            MediaTransportFactoryFactory mediaTransportFactoryFactory = ((Builder)((Object)netEqFactoryFactory)).mediaTransportFactoryFactory;
            long l8 = mediaTransportFactoryFactory == null ? 0L : mediaTransportFactoryFactory.createNativeMediaTransportFactory();
            NetEqFactoryFactory netEqFactoryFactory = ((Builder)((Object)netEqFactoryFactory)).neteqFactoryFactory;
            long l9 = netEqFactoryFactory == null ? 0L : netEqFactoryFactory.createNativeNetEqFactory();
            return PeerConnectionFactory.nativeCreatePeerConnectionFactory(context, options, l, l2, l3, videoEncoderFactory, videoDecoderFactory, l4, l5, l6, l7, l8, l9);
        }
    }

    public static class Options {
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_WIFI = 2;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        static final int ADAPTER_TYPE_ANY = 32;
        public int networkIgnoreMask;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;

        @CalledByNative(value="Options")
        int getNetworkIgnoreMask() {
            return this.networkIgnoreMask;
        }

        @CalledByNative(value="Options")
        boolean getDisableEncryption() {
            return this.disableEncryption;
        }

        @CalledByNative(value="Options")
        boolean getDisableNetworkMonitor() {
            return this.disableNetworkMonitor;
        }
    }

    public static class InitializationOptions {
        final Context applicationContext;
        final String fieldTrials;
        final boolean enableInternalTracer;
        final NativeLibraryLoader nativeLibraryLoader;
        final String nativeLibraryName;
        @Nullable
        Loggable loggable;
        @Nullable
        Logging.Severity loggableSeverity;

        private InitializationOptions(Context context, String string, boolean bl, NativeLibraryLoader nativeLibraryLoader, String string2, @Nullable Loggable loggable, @Nullable Logging.Severity severity) {
            this.applicationContext = context;
            this.fieldTrials = string;
            this.enableInternalTracer = bl;
            this.nativeLibraryLoader = nativeLibraryLoader;
            this.nativeLibraryName = string2;
            this.loggable = loggable;
            this.loggableSeverity = severity;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            private final Context applicationContext;
            private String fieldTrials = "";
            private boolean enableInternalTracer;
            private NativeLibraryLoader nativeLibraryLoader;
            private String nativeLibraryName;
            @Nullable
            private Loggable loggable;
            @Nullable
            private Logging.Severity loggableSeverity;

            Builder(Context context) {
                NativeLibrary.DefaultLoader defaultLoader;
                NativeLibrary.DefaultLoader defaultLoader2 = defaultLoader;
                defaultLoader = new NativeLibrary.DefaultLoader();
                v1.nativeLibraryLoader = defaultLoader2;
                v1.nativeLibraryName = "jingle_peerconnection_so";
                v1.applicationContext = context;
            }

            public Builder setFieldTrials(String string) {
                this.fieldTrials = string;
                return this;
            }

            public Builder setEnableInternalTracer(boolean bl) {
                this.enableInternalTracer = bl;
                return this;
            }

            public Builder setNativeLibraryLoader(NativeLibraryLoader nativeLibraryLoader) {
                this.nativeLibraryLoader = nativeLibraryLoader;
                return this;
            }

            public Builder setNativeLibraryName(String string) {
                this.nativeLibraryName = string;
                return this;
            }

            public Builder setInjectableLogger(Loggable loggable, Logging.Severity severity) {
                this.loggable = loggable;
                this.loggableSeverity = severity;
                return this;
            }

            public InitializationOptions createInitializationOptions() {
                Builder builder = builder2;
                Builder builder2 = builder.applicationContext;
                String string = builder.fieldTrials;
                boolean bl = builder.enableInternalTracer;
                NativeLibraryLoader nativeLibraryLoader = builder.nativeLibraryLoader;
                String string2 = builder.nativeLibraryName;
                Loggable loggable = builder.loggable;
                Logging.Severity severity = builder.loggableSeverity;
                return new InitializationOptions((Context)builder2, string, bl, nativeLibraryLoader, string2, loggable, severity);
            }
        }
    }

    private static class ThreadInfo {
        final Thread thread;
        final int tid;

        public static ThreadInfo getCurrent() {
            return new ThreadInfo(Thread.currentThread(), Process.myTid());
        }

        private ThreadInfo(Thread thread, int n) {
            this.thread = thread;
            this.tid = n;
        }
    }
}

