/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import android.support.annotation.Nullable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.Logging;
import org.otwebrtc.PeerConnectionFactory;

public class NetworkMonitorAutoDetect
extends BroadcastReceiver {
    static final long INVALID_NET_ID = -1L;
    private static final String TAG = "NetworkMonitorAutoDetect";
    private final Observer observer;
    private final IntentFilter intentFilter;
    private final Context context;
    @Nullable
    private final ConnectivityManager.NetworkCallback mobileNetworkCallback;
    @Nullable
    private final ConnectivityManager.NetworkCallback allNetworkCallback;
    private ConnectivityManagerDelegate connectivityManagerDelegate;
    private WifiManagerDelegate wifiManagerDelegate;
    private WifiDirectManagerDelegate wifiDirectManagerDelegate;
    private boolean isRegistered;
    private ConnectionType connectionType;
    private String wifiSSID;

    @SuppressLint(value={"NewApi"})
    public NetworkMonitorAutoDetect(Observer object, Context context) {
        NetworkMonitorAutoDetect networkMonitorAutoDetect = this;
        this.observer = object;
        networkMonitorAutoDetect.context = context;
        networkMonitorAutoDetect.connectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        networkMonitorAutoDetect.wifiManagerDelegate = new WifiManagerDelegate(context);
        Object object2 = networkMonitorAutoDetect.connectivityManagerDelegate.getNetworkState();
        networkMonitorAutoDetect.connectionType = NetworkMonitorAutoDetect.getConnectionType(object2);
        networkMonitorAutoDetect.wifiSSID = networkMonitorAutoDetect.getWifiSSID((NetworkState)object2);
        networkMonitorAutoDetect.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (PeerConnectionFactory.fieldTrialsFindFullName("IncludeWifiDirect").equals("Enabled")) {
            WifiDirectManagerDelegate wifiDirectManagerDelegate;
            object2 = wifiDirectManagerDelegate;
            wifiDirectManagerDelegate = new WifiDirectManagerDelegate((Observer)object, context);
            this.wifiDirectManagerDelegate = object2;
        }
        NetworkMonitorAutoDetect networkMonitorAutoDetect2 = this;
        networkMonitorAutoDetect2.registerReceiver();
        if (networkMonitorAutoDetect2.connectivityManagerDelegate.supportNetworkCallback()) {
            SimpleNetworkCallback simpleNetworkCallback;
            ConnectivityManager.NetworkCallback networkCallback;
            object = networkCallback;
            networkCallback = new ConnectivityManager.NetworkCallback();
            try {
                this.connectivityManagerDelegate.requestMobileNetwork((ConnectivityManager.NetworkCallback)object);
            }
            catch (SecurityException securityException) {
                Logging.w(TAG, "Unable to obtain permission to request a cellular network.");
                object = null;
            }
            this.mobileNetworkCallback = object;
            object = simpleNetworkCallback;
            this.allNetworkCallback = new SimpleNetworkCallback();
            this.connectivityManagerDelegate.registerNetworkCallback((ConnectivityManager.NetworkCallback)object);
        } else {
            NetworkMonitorAutoDetect networkMonitorAutoDetect3 = this;
            networkMonitorAutoDetect3.mobileNetworkCallback = null;
            networkMonitorAutoDetect3.allNetworkCallback = null;
        }
    }

    private void registerReceiver() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        NetworkMonitorAutoDetect networkMonitorAutoDetect = this;
        this.context.registerReceiver((BroadcastReceiver)networkMonitorAutoDetect, networkMonitorAutoDetect.intentFilter);
    }

    private void unregisterReceiver() {
        if (!this.isRegistered) {
            return;
        }
        this.isRegistered = false;
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    private static ConnectionType getConnectionType(boolean bl, int n, int n2) {
        if (!bl) {
            return ConnectionType.CONNECTION_NONE;
        }
        if (n != 0) {
            if (n != 1) {
                if (n != 6) {
                    if (n != 7) {
                        if (n != 9) {
                            if (n != 17) {
                                return ConnectionType.CONNECTION_UNKNOWN;
                            }
                            return ConnectionType.CONNECTION_VPN;
                        }
                        return ConnectionType.CONNECTION_ETHERNET;
                    }
                    return ConnectionType.CONNECTION_BLUETOOTH;
                }
                return ConnectionType.CONNECTION_4G;
            }
            return ConnectionType.CONNECTION_WIFI;
        }
        switch (n2) {
            default: {
                return ConnectionType.CONNECTION_UNKNOWN_CELLULAR;
            }
            case 20: {
                return ConnectionType.CONNECTION_5G;
            }
            case 13: 
            case 18: {
                return ConnectionType.CONNECTION_4G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return ConnectionType.CONNECTION_3G;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
        }
        return ConnectionType.CONNECTION_2G;
    }

    public static ConnectionType getConnectionType(NetworkState networkState) {
        NetworkState networkState2 = networkState;
        int n = networkState2.getNetworkType();
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), n, networkState2.getNetworkSubType());
    }

    private static ConnectionType getUnderlyingConnectionTypeForVpn(NetworkState networkState) {
        if (networkState.getNetworkType() != 17) {
            return ConnectionType.CONNECTION_NONE;
        }
        NetworkState networkState2 = networkState;
        int n = networkState2.getUnderlyingNetworkTypeForVpn();
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), n, networkState2.getUnderlyingNetworkSubtypeForVpn());
    }

    private String getWifiSSID(NetworkState networkState) {
        if (NetworkMonitorAutoDetect.getConnectionType(networkState) != ConnectionType.CONNECTION_WIFI) {
            return "";
        }
        return this.wifiManagerDelegate.getWifiSSID();
    }

    private void connectionTypeChanged(NetworkState object) {
        ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
        NetworkMonitorAutoDetect networkMonitorAutoDetect = this;
        object = networkMonitorAutoDetect.getWifiSSID((NetworkState)object);
        if (connectionType == networkMonitorAutoDetect.connectionType && ((String)object).equals(this.wifiSSID)) {
            return;
        }
        this.connectionType = connectionType;
        this.wifiSSID = object;
        Logging.d(TAG, "Network connectivity changed, type is: " + (Object)((Object)this.connectionType));
        this.observer.onConnectionTypeChanged(connectionType);
    }

    @SuppressLint(value={"NewApi"})
    private static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT >= 23) {
            return network.getNetworkHandle();
        }
        return Integer.parseInt(network.toString());
    }

    public boolean supportNetworkCallback() {
        return this.connectivityManagerDelegate.supportNetworkCallback();
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate connectivityManagerDelegate) {
        this.connectivityManagerDelegate = connectivityManagerDelegate;
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate wifiManagerDelegate) {
        this.wifiManagerDelegate = wifiManagerDelegate;
    }

    boolean isReceiverRegisteredForTesting() {
        return this.isRegistered;
    }

    @Nullable
    List<NetworkInformation> getActiveNetworkList() {
        ArrayList<NetworkInformation> arrayList;
        Object object = ((NetworkMonitorAutoDetect)((Object)arrayList2)).connectivityManagerDelegate.getActiveNetworkList();
        if (object == null) {
            return null;
        }
        NetworkMonitorAutoDetect networkMonitorAutoDetect = arrayList2;
        ArrayList<NetworkInformation> arrayList2 = arrayList;
        arrayList = new ArrayList<NetworkInformation>((Collection<NetworkInformation>)object);
        object = networkMonitorAutoDetect.wifiDirectManagerDelegate;
        if (object != null) {
            arrayList2.addAll(((WifiDirectManagerDelegate)((Object)object)).getActiveNetworkList());
        }
        return arrayList2;
    }

    public void destroy() {
        Object object = this.allNetworkCallback;
        if (object != null) {
            this.connectivityManagerDelegate.releaseCallback((ConnectivityManager.NetworkCallback)object);
        }
        if ((object = this.mobileNetworkCallback) != null) {
            this.connectivityManagerDelegate.releaseCallback((ConnectivityManager.NetworkCallback)object);
        }
        if ((object = this.wifiDirectManagerDelegate) != null) {
            ((WifiDirectManagerDelegate)((Object)object)).release();
        }
        this.unregisterReceiver();
    }

    public NetworkState getCurrentNetworkState() {
        return this.connectivityManagerDelegate.getNetworkState();
    }

    public long getDefaultNetId() {
        return this.connectivityManagerDelegate.getDefaultNetId();
    }

    public void onReceive(Context object, Intent intent) {
        object = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.connectionTypeChanged((NetworkState)object);
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(ConnectionType var1);

        public void onNetworkConnect(NetworkInformation var1);

        public void onNetworkDisconnect(long var1);
    }

    static class WifiDirectManagerDelegate
    extends BroadcastReceiver {
        private static final int WIFI_P2P_NETWORK_HANDLE = 0;
        private final Context context;
        private final Observer observer;
        @Nullable
        private NetworkInformation wifiP2pNetworkInfo;

        WifiDirectManagerDelegate(Observer observer, Context context) {
            IntentFilter intentFilter;
            wifiDirectManagerDelegate.context = context;
            wifiDirectManagerDelegate.observer = observer;
            observer = intentFilter;
            new IntentFilter().addAction("android.net.wifi.p2p.STATE_CHANGED");
            observer.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
            context.registerReceiver((BroadcastReceiver)wifiDirectManagerDelegate, (IntentFilter)observer);
            if (Build.VERSION.SDK_INT > 28) {
                WifiP2pManager wifiP2pManager = (WifiP2pManager)context.getSystemService("wifip2p");
                Context context2 = context;
                WifiDirectManagerDelegate wifiDirectManagerDelegate = wifiP2pManager.initialize(context2, context2.getMainLooper(), null);
                wifiP2pManager.requestGroupInfo((WifiP2pManager.Channel)wifiDirectManagerDelegate, wifiP2pGroup -> this.onWifiP2pGroupChange(wifiP2pGroup));
            }
        }

        private void onWifiP2pGroupChange(@Nullable WifiP2pGroup wifiP2pGroup) {
            if (wifiP2pGroup != null && wifiP2pGroup.getInterface() != null) {
                NetworkInformation networkInformation;
                ArrayList<InetAddress> arrayList;
                try {
                    arrayList = Collections.list(NetworkInterface.getByName(wifiP2pGroup.getInterface()).getInetAddresses());
                }
                catch (SocketException socketException) {
                    Logging.e(NetworkMonitorAutoDetect.TAG, "Unable to get WifiP2p network interface", socketException);
                    return;
                }
                IPAddress[] iPAddressArray = new IPAddress[arrayList.size()];
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    IPAddress iPAddress;
                    IPAddress iPAddress2 = iPAddress;
                    iPAddress = new IPAddress(((InetAddress)arrayList.get(i2)).getAddress());
                    iPAddressArray[i2] = iPAddress2;
                }
                WifiDirectManagerDelegate wifiDirectManagerDelegate = object;
                Object object = networkInformation;
                wifiDirectManagerDelegate.wifiP2pNetworkInfo = new NetworkInformation(wifiP2pGroup.getInterface(), ConnectionType.CONNECTION_WIFI, ConnectionType.CONNECTION_NONE, 0L, iPAddressArray);
                wifiDirectManagerDelegate.observer.onNetworkConnect((NetworkInformation)object);
                return;
            }
        }

        private void onWifiP2pStateChange(int n) {
            if (n == 1) {
                this.wifiP2pNetworkInfo = null;
                this.observer.onNetworkDisconnect(0L);
            }
        }

        @SuppressLint(value={"InlinedApi"})
        public void onReceive(Context context, Intent intent) {
            if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(intent.getAction())) {
                this.onWifiP2pGroupChange((WifiP2pGroup)intent.getParcelableExtra("p2pGroupInfo"));
            } else if ("android.net.wifi.p2p.STATE_CHANGED".equals(intent.getAction())) {
                this.onWifiP2pStateChange(intent.getIntExtra("wifi_p2p_state", 0));
            }
        }

        public void release() {
            this.context.unregisterReceiver((BroadcastReceiver)this);
        }

        public List<NetworkInformation> getActiveNetworkList() {
            Object object = object.wifiP2pNetworkInfo;
            if (object != null) {
                return Collections.singletonList(object);
            }
            return Collections.emptyList();
        }
    }

    static class WifiManagerDelegate {
        @Nullable
        private final Context context;

        WifiManagerDelegate(Context context) {
            this.context = context;
        }

        WifiManagerDelegate() {
            this.context = null;
        }

        String getWifiSSID() {
            IntentFilter intentFilter;
            Object object = intentFilter;
            intentFilter = new IntentFilter("android.net.wifi.STATE_CHANGE");
            if ((object = ((WifiManagerDelegate)object).context.registerReceiver(null, (IntentFilter)object)) != null && (object = (WifiInfo)object.getParcelableExtra("wifiInfo")) != null && (object = object.getSSID()) != null) {
                return object;
            }
            return "";
        }
    }

    static class ConnectivityManagerDelegate {
        @Nullable
        private final ConnectivityManager connectivityManager;

        ConnectivityManagerDelegate(Context context) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.connectivityManager = null;
        }

        private NetworkState getNetworkState(@Nullable NetworkInfo networkInfo) {
            if (networkInfo != null && networkInfo.isConnected()) {
                NetworkInfo networkInfo2 = networkInfo;
                int n = networkInfo2.getType();
                int n2 = networkInfo2.getSubtype();
                return new NetworkState(true, n, n2, -1, -1);
            }
            return new NetworkState(false, -1, -1, -1, -1);
        }

        @SuppressLint(value={"NewApi"})
        @Nullable
        private NetworkInformation networkToInfo(@Nullable Network iPAddressArray) {
            ConnectivityManager connectivityManager;
            if (iPAddressArray != null && (connectivityManager = ((ConnectivityManagerDelegate)((Object)string)).connectivityManager) != null) {
                if ((connectivityManager = connectivityManager.getLinkProperties((Network)iPAddressArray)) == null) {
                    Logging.w(NetworkMonitorAutoDetect.TAG, "Detected unknown network: " + iPAddressArray.toString());
                    return null;
                }
                if (connectivityManager.getInterfaceName() == null) {
                    Logging.w(NetworkMonitorAutoDetect.TAG, "Null interface name for network " + iPAddressArray.toString());
                    return null;
                }
                Object object = ((ConnectivityManagerDelegate)((Object)string)).getNetworkState((Network)iPAddressArray);
                ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
                if (connectionType == ConnectionType.CONNECTION_NONE) {
                    Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + iPAddressArray.toString() + " is disconnected");
                    return null;
                }
                if (connectionType == ConnectionType.CONNECTION_UNKNOWN || connectionType == ConnectionType.CONNECTION_UNKNOWN_CELLULAR) {
                    Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + iPAddressArray.toString() + " connection type is " + (Object)((Object)connectionType) + " because it has type " + ((NetworkState)object).getNetworkType() + " and subtype " + ((NetworkState)object).getNetworkSubType());
                }
                object = NetworkMonitorAutoDetect.getUnderlyingConnectionTypeForVpn((NetworkState)object);
                ConnectivityManagerDelegate connectivityManagerDelegate = string;
                String string = connectivityManager.getInterfaceName();
                long l = NetworkMonitorAutoDetect.networkToNetId((Network)iPAddressArray);
                iPAddressArray = connectivityManagerDelegate.getIPAddresses((LinkProperties)connectivityManager);
                return new NetworkInformation(string, connectionType, (ConnectionType)((Object)object), l, iPAddressArray);
            }
            return null;
        }

        NetworkState getNetworkState() {
            ConnectivityManager connectivityManager = this.connectivityManager;
            if (connectivityManager == null) {
                return new NetworkState(false, -1, -1, -1, -1);
            }
            return this.getNetworkState(connectivityManager.getActiveNetworkInfo());
        }

        @SuppressLint(value={"NewApi"})
        NetworkState getNetworkState(@Nullable Network network) {
            ConnectivityManager connectivityManager;
            if (network != null && (connectivityManager = this.connectivityManager) != null) {
                if ((connectivityManager = connectivityManager.getNetworkInfo(network)) == null) {
                    Logging.w(NetworkMonitorAutoDetect.TAG, "Couldn't retrieve information from network " + network.toString());
                    return new NetworkState(false, -1, -1, -1, -1);
                }
                if (connectivityManager.getType() != 17) {
                    if ((network = this.connectivityManager.getNetworkCapabilities(network)) != null && network.hasTransport(4)) {
                        ConnectivityManager connectivityManager2 = connectivityManager;
                        boolean bl = connectivityManager2.isConnected();
                        int n = connectivityManager2.getType();
                        int n2 = connectivityManager2.getSubtype();
                        return new NetworkState(bl, 17, -1, n, n2);
                    }
                    return this.getNetworkState((NetworkInfo)connectivityManager);
                }
                if (connectivityManager.getType() == 17) {
                    if (Build.VERSION.SDK_INT >= 23 && network.equals((Object)this.connectivityManager.getActiveNetwork()) && (this = this.connectivityManager.getActiveNetworkInfo()) != null && this.getType() != 17) {
                        ConnectivityManagerDelegate connectivityManagerDelegate = this;
                        boolean bl = connectivityManager.isConnected();
                        int n = connectivityManagerDelegate.getType();
                        int n3 = connectivityManagerDelegate.getSubtype();
                        return new NetworkState(bl, 17, -1, n, n3);
                    }
                    return new NetworkState(connectivityManager.isConnected(), 17, -1, -1, -1);
                }
                return this.getNetworkState((NetworkInfo)connectivityManager);
            }
            return new NetworkState(false, -1, -1, -1, -1);
        }

        @SuppressLint(value={"NewApi"})
        Network[] getAllNetworks() {
            ConnectivityManagerDelegate connectivityManagerDelegate = connectivityManagerDelegate.connectivityManager;
            if (connectivityManagerDelegate == null) {
                return new Network[0];
            }
            return connectivityManagerDelegate.getAllNetworks();
        }

        @Nullable
        List<NetworkInformation> getActiveNetworkList() {
            ArrayList<NetworkInformation> arrayList;
            if (!this.supportNetworkCallback()) {
                return null;
            }
            ArrayList<NetworkInformation> arrayList2 = arrayList;
            arrayList = new ArrayList<NetworkInformation>();
            Network[] networkArray = this.getAllNetworks();
            int n = networkArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                NetworkInformation networkInformation = this.networkToInfo(networkArray[i2]);
                if (networkInformation == null) continue;
                arrayList2.add(networkInformation);
            }
            return arrayList2;
        }

        @SuppressLint(value={"NewApi"})
        long getDefaultNetId() {
            if (!this.supportNetworkCallback()) {
                return -1L;
            }
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return -1L;
            }
            Network[] networkArray = this.getAllNetworks();
            long l = -1L;
            for (Network network : networkArray) {
                NetworkInfo networkInfo2;
                if (!this.hasInternetCapability(network) || (networkInfo2 = this.connectivityManager.getNetworkInfo(network)) == null || networkInfo2.getType() != networkInfo.getType()) continue;
                if (l == -1L) {
                    l = NetworkMonitorAutoDetect.networkToNetId(network);
                    continue;
                }
                throw new RuntimeException("Multiple connected networks of same type are not supported.");
            }
            return l;
        }

        @SuppressLint(value={"NewApi"})
        boolean hasInternetCapability(Network network) {
            ConnectivityManagerDelegate connectivityManagerDelegate = connectivityManagerDelegate.connectivityManager;
            if (connectivityManagerDelegate == null) {
                return false;
            }
            return (connectivityManagerDelegate = connectivityManagerDelegate.getNetworkCapabilities(network)) != null && connectivityManagerDelegate.hasCapability(12);
        }

        @SuppressLint(value={"NewApi"})
        public void registerNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addCapability(12).build(), networkCallback);
        }

        @SuppressLint(value={"NewApi"})
        public void requestMobileNetwork(ConnectivityManager.NetworkCallback networkCallback) {
            NetworkRequest.Builder builder;
            ConnectivityManagerDelegate connectivityManagerDelegate = connectivityManagerDelegate2;
            ConnectivityManagerDelegate connectivityManagerDelegate2 = builder;
            new NetworkRequest.Builder().addCapability(12).addTransportType(0);
            connectivityManagerDelegate.connectivityManager.requestNetwork(connectivityManagerDelegate2.build(), networkCallback);
        }

        @SuppressLint(value={"NewApi"})
        IPAddress[] getIPAddresses(LinkProperties linkProperties) {
            LinkProperties linkProperties2 = linkProperties;
            IPAddress[] iPAddressArray = new IPAddress[linkProperties2.getLinkAddresses().size()];
            int n = 0;
            for (LinkAddress linkAddress : linkProperties2.getLinkAddresses()) {
                IPAddress iPAddress;
                IPAddress iPAddress2 = iPAddress;
                iPAddress = new IPAddress(linkAddress.getAddress().getAddress());
                iPAddressArray[n] = iPAddress2;
                ++n;
            }
            return iPAddressArray;
        }

        @SuppressLint(value={"NewApi"})
        public void releaseCallback(ConnectivityManager.NetworkCallback networkCallback) {
            if (this.supportNetworkCallback()) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Unregister network callback");
                this.connectivityManager.unregisterNetworkCallback(networkCallback);
            }
        }

        public boolean supportNetworkCallback() {
            return Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null;
        }
    }

    @SuppressLint(value={"NewApi"})
    private class SimpleNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private SimpleNetworkCallback() {
        }

        private void onNetworkChanged(Network object) {
            object = NetworkMonitorAutoDetect.this.connectivityManagerDelegate.networkToInfo(object);
            if (object != null) {
                NetworkMonitorAutoDetect.this.observer.onNetworkConnect((NetworkInformation)object);
            }
        }

        public void onAvailable(Network network) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network becomes available: " + network.toString());
            this.onNetworkChanged(network);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "capabilities changed: " + networkCapabilities.toString());
            this.onNetworkChanged(network);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "link properties changed: " + linkProperties.toString());
            this.onNetworkChanged(network);
        }

        public void onLosing(Network network, int n) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + network.toString() + " is about to lose in " + n + "ms");
        }

        public void onLost(Network network) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + network.toString() + " is disconnected");
            NetworkMonitorAutoDetect.this.observer.onNetworkDisconnect(NetworkMonitorAutoDetect.networkToNetId(network));
        }
    }

    static class NetworkState {
        private final boolean connected;
        private final int type;
        private final int subtype;
        private final int underlyingNetworkTypeForVpn;
        private final int underlyingNetworkSubtypeForVpn;

        public NetworkState(boolean bl, int n, int n2, int n3, int n4) {
            this.connected = bl;
            this.type = n;
            this.subtype = n2;
            this.underlyingNetworkTypeForVpn = n3;
            this.underlyingNetworkSubtypeForVpn = n4;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public int getNetworkType() {
            return this.type;
        }

        public int getNetworkSubType() {
            return this.subtype;
        }

        public int getUnderlyingNetworkTypeForVpn() {
            return this.underlyingNetworkTypeForVpn;
        }

        public int getUnderlyingNetworkSubtypeForVpn() {
            return this.underlyingNetworkSubtypeForVpn;
        }
    }

    public static class NetworkInformation {
        public final String name;
        public final ConnectionType type;
        public final ConnectionType underlyingTypeForVpn;
        public final long handle;
        public final IPAddress[] ipAddresses;

        public NetworkInformation(String string, ConnectionType connectionType, ConnectionType connectionType2, long l, IPAddress[] iPAddressArray) {
            this.name = string;
            this.type = connectionType;
            this.underlyingTypeForVpn = connectionType2;
            this.handle = l;
            this.ipAddresses = iPAddressArray;
        }

        @CalledByNative(value="NetworkInformation")
        private IPAddress[] getIpAddresses() {
            return this.ipAddresses;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getConnectionType() {
            return this.type;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getUnderlyingConnectionTypeForVpn() {
            return this.underlyingTypeForVpn;
        }

        @CalledByNative(value="NetworkInformation")
        private long getHandle() {
            return this.handle;
        }

        @CalledByNative(value="NetworkInformation")
        private String getName() {
            return this.name;
        }
    }

    public static class IPAddress {
        public final byte[] address;

        public IPAddress(byte[] byArray) {
            this.address = byArray;
        }

        @CalledByNative(value="IPAddress")
        private byte[] getAddress() {
            return this.address;
        }
    }

    public static final class ConnectionType
    extends Enum<ConnectionType> {
        public static final /* enum */ ConnectionType CONNECTION_UNKNOWN;
        public static final /* enum */ ConnectionType CONNECTION_ETHERNET;
        public static final /* enum */ ConnectionType CONNECTION_WIFI;
        public static final /* enum */ ConnectionType CONNECTION_5G;
        public static final /* enum */ ConnectionType CONNECTION_4G;
        public static final /* enum */ ConnectionType CONNECTION_3G;
        public static final /* enum */ ConnectionType CONNECTION_2G;
        public static final /* enum */ ConnectionType CONNECTION_UNKNOWN_CELLULAR;
        public static final /* enum */ ConnectionType CONNECTION_BLUETOOTH;
        public static final /* enum */ ConnectionType CONNECTION_VPN;
        public static final /* enum */ ConnectionType CONNECTION_NONE;
        private static final /* synthetic */ ConnectionType[] $VALUES;

        public static ConnectionType[] values() {
            return (ConnectionType[])$VALUES.clone();
        }

        public static ConnectionType valueOf(String string) {
            return Enum.valueOf(ConnectionType.class, string);
        }

        static {
            ConnectionType connectionType;
            CONNECTION_UNKNOWN = new ConnectionType();
            CONNECTION_ETHERNET = new ConnectionType();
            CONNECTION_WIFI = new ConnectionType();
            CONNECTION_5G = new ConnectionType();
            CONNECTION_4G = new ConnectionType();
            CONNECTION_3G = new ConnectionType();
            CONNECTION_2G = new ConnectionType();
            CONNECTION_UNKNOWN_CELLULAR = new ConnectionType();
            CONNECTION_BLUETOOTH = new ConnectionType();
            CONNECTION_VPN = new ConnectionType();
            ConnectionType connectionType2 = connectionType;
            CONNECTION_NONE = new ConnectionType();
            $VALUES = new ConnectionType[]{CONNECTION_UNKNOWN, CONNECTION_ETHERNET, CONNECTION_WIFI, CONNECTION_5G, CONNECTION_4G, CONNECTION_3G, CONNECTION_2G, CONNECTION_UNKNOWN_CELLULAR, CONNECTION_BLUETOOTH, CONNECTION_VPN, connectionType2};
        }
    }
}

