/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import org.otwebrtc.Logging;
import org.otwebrtc.NativeLibraryLoader;

class NativeLibrary {
    private static String TAG = "NativeLibrary";
    private static Object lock = new Object();
    private static boolean libraryLoaded;

    NativeLibrary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void initialize(NativeLibraryLoader nativeLibraryLoader, String string) {
        Object object = lock;
        synchronized (object) {
            if (libraryLoaded) {
                Logging.d(TAG, "Native library has already been loaded.");
                return;
            }
            Logging.d(TAG, "Loading native library: " + string);
            libraryLoaded = nativeLibraryLoader.load(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLoaded() {
        Object object = lock;
        synchronized (object) {
            return libraryLoaded;
        }
    }

    static class DefaultLoader
    implements NativeLibraryLoader {
        DefaultLoader() {
        }

        @Override
        public boolean load(String string) {
            Logging.d(TAG, "Loading library: " + string);
            try {
                System.loadLibrary(string);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logging.e(TAG, "Failed to load native library: " + string, unsatisfiedLinkError);
                return false;
            }
        }
    }
}

