/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.otwebrtc.JavaI420Buffer;
import org.otwebrtc.RefCountDelegate;
import org.otwebrtc.RefCounted;
import org.otwebrtc.VideoFrame;

public class NV12Buffer
implements VideoFrame.Buffer {
    private final int width;
    private final int height;
    private final int stride;
    private final int sliceHeight;
    private final ByteBuffer buffer;
    private final RefCountDelegate refCountDelegate;

    public NV12Buffer(int n, int n2, int n3, int n4, ByteBuffer byteBuffer, @Nullable Runnable runnable) {
        RefCountDelegate refCountDelegate;
        refCounted.width = n;
        refCounted.height = n2;
        refCounted.stride = n3;
        refCounted.sliceHeight = n4;
        refCounted.buffer = byteBuffer;
        RefCounted refCounted = refCountDelegate;
        refCountDelegate = new RefCountDelegate(runnable);
        v1.refCountDelegate = refCounted;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, ByteBuffer var6, int var7, int var8, int var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14, ByteBuffer var15, int var16);

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        NV12Buffer nV12Buffer = this;
        int n = nV12Buffer.width;
        int n2 = nV12Buffer.height;
        return (VideoFrame.I420Buffer)nV12Buffer.cropAndScale(0, 0, n, n2, n, n2);
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n, int n2, int n3, int n4, int n5, int n6) {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n5, n6);
        NV12Buffer nV12Buffer = byteBuffer;
        ByteBuffer byteBuffer = nV12Buffer.buffer;
        n = nV12Buffer.width;
        int n7 = nV12Buffer.height;
        int n8 = nV12Buffer.stride;
        int n9 = nV12Buffer.sliceHeight;
        ByteBuffer byteBuffer2 = javaI420Buffer.getDataY();
        int n10 = javaI420Buffer.getStrideY();
        ByteBuffer byteBuffer3 = javaI420Buffer.getDataU();
        int n11 = javaI420Buffer.getStrideU();
        ByteBuffer byteBuffer4 = javaI420Buffer.getDataV();
        int n12 = javaI420Buffer.getStrideV();
        NV12Buffer.nativeCropAndScale(n, n2, n3, n4, n5, n6, byteBuffer, n, n7, n8, n9, byteBuffer2, n10, byteBuffer3, n11, byteBuffer4, n12);
        return javaI420Buffer;
    }
}

