/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import java.util.ArrayList;
import java.util.List;
import org.otwebrtc.AudioTrack;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.JniCommon;
import org.otwebrtc.Logging;
import org.otwebrtc.MediaStreamTrack;
import org.otwebrtc.VideoTrack;

public class MediaStream {
    private static final String TAG = "MediaStream";
    public final List<AudioTrack> audioTracks;
    public final List<VideoTrack> videoTracks;
    public final List<VideoTrack> preservedVideoTracks;
    private long nativeStream;

    @CalledByNative
    public MediaStream(long l) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        Object object = arrayList3;
        arrayList3 = new ArrayList();
        v1.audioTracks = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        v1.videoTracks = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.preservedVideoTracks = object;
        v1.nativeStream = l;
    }

    private void checkMediaStreamExists() {
        if (this.nativeStream != 0L) {
            return;
        }
        throw new IllegalStateException("MediaStream has been disposed.");
    }

    private static void removeMediaStreamTrack(List<? extends MediaStreamTrack> object, long l) {
        object = object.iterator();
        while (object.hasNext()) {
            MediaStreamTrack mediaStreamTrack = (MediaStreamTrack)object.next();
            if (mediaStreamTrack.getNativeMediaStreamTrack() != l) continue;
            mediaStreamTrack.dispose();
            object.remove();
            return;
        }
        Logging.e(TAG, "Couldn't not find track");
    }

    private static native boolean nativeAddAudioTrackToNativeStream(long var0, long var2);

    private static native boolean nativeAddVideoTrackToNativeStream(long var0, long var2);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    private static native String nativeGetId(long var0);

    public boolean addTrack(AudioTrack audioTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        if (MediaStream.nativeAddAudioTrackToNativeStream(mediaStream.nativeStream, audioTrack.getNativeAudioTrack())) {
            this.audioTracks.add(audioTrack);
            return true;
        }
        return false;
    }

    public boolean addTrack(VideoTrack videoTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(mediaStream.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.videoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean addPreservedTrack(VideoTrack videoTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(mediaStream.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.preservedVideoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean removeTrack(AudioTrack audioTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        mediaStream.audioTracks.remove(audioTrack);
        return MediaStream.nativeRemoveAudioTrack(mediaStream.nativeStream, audioTrack.getNativeAudioTrack());
    }

    public boolean removeTrack(VideoTrack videoTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        mediaStream.videoTracks.remove(videoTrack);
        mediaStream.preservedVideoTracks.remove(videoTrack);
        return MediaStream.nativeRemoveVideoTrack(mediaStream.nativeStream, videoTrack.getNativeVideoTrack());
    }

    @CalledByNative
    public void dispose() {
        this.checkMediaStreamExists();
        while (!this.audioTracks.isEmpty()) {
            AudioTrack audioTrack = this.audioTracks.get(0);
            this.removeTrack(audioTrack);
            audioTrack.dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            VideoTrack videoTrack = this.videoTracks.get(0);
            this.removeTrack(videoTrack);
            videoTrack.dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            MediaStream mediaStream = this;
            mediaStream.removeTrack(mediaStream.preservedVideoTracks.get(0));
        }
        JniCommon.nativeReleaseRef(this.nativeStream);
        this.nativeStream = 0L;
    }

    public String getId() {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        return MediaStream.nativeGetId(mediaStream.nativeStream);
    }

    public String toString() {
        return "[" + this.getId() + ":A=" + this.audioTracks.size() + ":V=" + this.videoTracks.size() + "]";
    }

    @CalledByNative
    void addNativeAudioTrack(long l) {
        this.audioTracks.add(new AudioTrack(l));
    }

    @CalledByNative
    void addNativeVideoTrack(long l) {
        this.videoTracks.add(new VideoTrack(l));
    }

    @CalledByNative
    void removeAudioTrack(long l) {
        MediaStream.removeMediaStreamTrack(this.audioTracks, l);
    }

    @CalledByNative
    void removeVideoTrack(long l) {
        MediaStream.removeMediaStreamTrack(this.videoTracks, l);
    }

    long getNativeMediaStream() {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        return mediaStream.nativeStream;
    }
}

