/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.BitrateAdjuster;
import org.otwebrtc.EglBase;
import org.otwebrtc.EglBase14;
import org.otwebrtc.EncodedImage;
import org.otwebrtc.GlRectDrawer;
import org.otwebrtc.Logging;
import org.otwebrtc.MediaCodecWrapper;
import org.otwebrtc.MediaCodecWrapperFactory;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoCodecMimeType;
import org.otwebrtc.VideoCodecStatus;
import org.otwebrtc.VideoEncoder;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoFrameDrawer;
import org.otwebrtc.YuvHelper;

@TargetApi(value=19)
class HardwareVideoEncoder
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final int VIDEO_ControlRateConstant = 2;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_AVC_LEVEL_3 = 256;
    private static final int MAX_VIDEO_FRAMERATE = 30;
    private static final int MAX_ENCODER_Q_SIZE = 2;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecMimeType codecType;
    private final Integer surfaceColorFormat;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final Map<String, String> params;
    private final int keyFrameIntervalSec;
    private final long forcedKeyFrameNs;
    private final BitrateAdjuster bitrateAdjuster;
    private final EglBase14.Context sharedContext;
    private final GlRectDrawer textureDrawer;
    private final VideoFrameDrawer videoFrameDrawer;
    private final BlockingDeque<EncodedImage.Builder> outputBuilders;
    private final ThreadUtils.ThreadChecker encodeThreadChecker;
    private final ThreadUtils.ThreadChecker outputThreadChecker;
    private final BusyCount outputBuffersBusyCount;
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    @Nullable
    private MediaCodecWrapper codec;
    @Nullable
    private ByteBuffer[] outputBuffers;
    @Nullable
    private Thread outputThread;
    @Nullable
    private EglBase14 textureEglBase;
    @Nullable
    private Surface textureInputSurface;
    private int width;
    private int height;
    private boolean useSurfaceMode;
    private long lastKeyFrameNs;
    @Nullable
    private ByteBuffer configBuffer;
    private int adjustedBitrate;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String string, VideoCodecMimeType videoCodecMimeType, Integer n, Integer n2, Map<String, String> map, int n3, int n4, BitrateAdjuster bitrateAdjuster, EglBase14.Context context) {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        this.textureDrawer = new GlRectDrawer();
        this.videoFrameDrawer = new VideoFrameDrawer();
        this.outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
        this.encodeThreadChecker = new ThreadUtils.ThreadChecker();
        this.outputThreadChecker = new ThreadUtils.ThreadChecker();
        this.outputBuffersBusyCount = new BusyCount();
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = string;
        this.codecType = videoCodecMimeType;
        this.surfaceColorFormat = n;
        this.yuvColorFormat = n2;
        this.yuvFormat = YuvFormat.valueOf(n2);
        this.params = map;
        hardwareVideoEncoder.keyFrameIntervalSec = n3;
        hardwareVideoEncoder.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(n4);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = context;
        this.encodeThreadChecker.detachThread();
    }

    /*
     * Unable to fully structure code
     */
    private VideoCodecStatus initEncodeInternal() {
        block21: {
            block18: {
                block20: {
                    block19: {
                        v0 = this;
                        v0.encodeThreadChecker.checkIsOnValidThread();
                        v0.lastKeyFrameNs = -1L;
                        v0.codec = v0.mediaCodecWrapperFactory.createByCodecName(this.codecName);
                        var1_1 = v0.useSurfaceMode != false ? this.surfaceColorFormat : this.yuvColorFormat;
                        try {
                            v1 = this;
                            v2 = v1;
                            v3 = v1.codecType.mimeType();
                            v4 = this;
                            v5 = v4;
                            var2_4 = v4.width;
                        }
                        catch (IllegalStateException var1_3) {
                            Logging.e("HardwareVideoEncoder", "initEncodeInternal failed", var1_3);
                            this.release();
                            return VideoCodecStatus.FALLBACK_SOFTWARE;
                        }
                        v6 = var2_5 = MediaFormat.createVideoFormat((String)v3, (int)var2_4, (int)v5.height);
                        var3_6 = "bitrate";
                        v6.setInteger(var3_6, this.adjustedBitrate);
                        v6.setInteger("bitrate-mode", 2);
                        v6.setInteger("color-format", var1_1);
                        v6.setInteger("frame-rate", this.bitrateAdjuster.getCodecConfigFramerate());
                        var1_2 = "i-frame-interval";
                        var2_5.setInteger(var1_2, this.keyFrameIntervalSec);
                        if (v2.codecType != VideoCodecMimeType.H264) break block18;
                        var1_2 = this.params.get("profile-level-id");
                        if (var1_2 == null) {
                            var1_2 = "42e01f";
                        }
                        var3_7 = -1;
                        var4_8 = var1_2.hashCode();
                        if (var4_8 == 1537948542) break block19;
                        if (var4_8 != 1595523974) break block20;
                        if (!var1_2.equals("640c1f")) ** GOTO lbl49
                        var3_7 = 0;
                    }
                    if (!var1_2.equals("42e01f")) break block20;
                    var3_7 = 1;
                }
                if (var3_7 == 0) ** GOTO lbl55
                if (var3_7 == 1) break block18;
                Logging.w("HardwareVideoEncoder", "Unknown profile level id: " + var1_2);
                break block18;
lbl55:
                // 1 sources

                v7 = var2_5;
                v7.setInteger("profile", 8);
                v7.setInteger("level", 256);
            }
            v8 = this;
            Logging.d("HardwareVideoEncoder", "Format: " + var2_5);
            v8.codec.configure(var2_5, null, null, 1);
            if (!v8.useSurfaceMode) ** GOTO lbl75
            v9 = this;
            v10 = v9;
            v11 = v9;
            v12 = v9;
            v9.textureEglBase = EglBase.createEgl14(v9.sharedContext, EglBase.CONFIG_RECORDABLE);
            var1_2 = v9.codec.createInputSurface();
            v12.textureInputSurface = var1_2;
            v10.textureEglBase.createSurface((Surface)var1_2);
            v11.textureEglBase.makeCurrent();
lbl75:
            // 2 sources

            v13 = this;
            v13.codec.start();
            v13.outputBuffers = v13.codec.getOutputBuffers();
            v13.running = true;
            v13.outputThreadChecker.detachThread();
            this.outputThread = v13.createOutputThread();
            this.outputThread.start();
            return VideoCodecStatus.OK;
            catch (IllegalArgumentException v14) {
                break block21;
            }
            catch (IOException v15) {}
        }
        Logging.e("HardwareVideoEncoder", "Cannot create media encoder " + this.codecName);
        return VideoCodecStatus.FALLBACK_SOFTWARE;
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame) {
        VideoFrame videoFrame2;
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        try {
            GLES20.glClear((int)16384);
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeTexture failed", runtimeException);
            return VideoCodecStatus.ERROR;
        }
        VideoFrame videoFrame3 = videoFrame2;
        VideoFrame videoFrame4 = videoFrame;
        VideoFrame videoFrame5 = videoFrame4;
        VideoFrame.Buffer buffer = videoFrame4.getBuffer();
        int n = 0;
        long l = videoFrame5.getTimestampNs();
        videoFrame2 = new VideoFrame(buffer, n, l);
        hardwareVideoEncoder.videoFrameDrawer.drawFrame(videoFrame3, this.textureDrawer, null);
        hardwareVideoEncoder.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame videoFrame, VideoFrame.Buffer buffer, int n) {
        HardwareVideoEncoder hardwareVideoEncoder;
        int n2;
        long l;
        block6: {
            this.encodeThreadChecker.checkIsOnValidThread();
            l = (videoFrame.getTimestampNs() + 500L) / 1000L;
            try {
                n2 = this.codec.dequeueInputBuffer(0L);
                if (n2 != -1) break block6;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
                return VideoCodecStatus.ERROR;
            }
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            HardwareVideoEncoder hardwareVideoEncoder2 = this;
            hardwareVideoEncoder = hardwareVideoEncoder2;
            hardwareVideoEncoder2.fillInputBuffer(hardwareVideoEncoder2.codec.getInputBuffers()[n2], buffer);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        try {
            hardwareVideoEncoder.codec.queueInputBuffer(n2, 0, n, l, 0);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
    }

    private VideoCodecStatus resetCodec(int n, int n2, boolean bl) {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = hardwareVideoEncoder.release();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        this.width = n;
        this.height = n2;
        this.useSurfaceMode = bl;
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long l) {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        long l2 = hardwareVideoEncoder.forcedKeyFrameNs;
        return l2 > 0L && l > this.lastKeyFrameNs + l2;
    }

    private void requestKeyFrame(long l) {
        Bundle bundle;
        HardwareVideoEncoder hardwareVideoEncoder = hardwareVideoEncoder3;
        HardwareVideoEncoder hardwareVideoEncoder2 = hardwareVideoEncoder3;
        hardwareVideoEncoder2.encodeThreadChecker.checkIsOnValidThread();
        HardwareVideoEncoder hardwareVideoEncoder3 = bundle;
        try {
            new Bundle().putInt("request-sync", 0);
            hardwareVideoEncoder2.codec.setParameters((Bundle)hardwareVideoEncoder3);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "requestKeyFrame failed", illegalStateException);
            return;
        }
        hardwareVideoEncoder.lastKeyFrameNs = l;
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    private void releaseCodecOnOutputThread() {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        hardwareVideoEncoder.outputBuffersBusyCount.waitForZero();
        try {
            hardwareVideoEncoder.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder release failed", exception);
            this.shutdownException = exception;
        }
        this.configBuffer = null;
        Logging.d(TAG, "Release on output thread done");
    }

    private VideoCodecStatus updateBitrate() {
        HardwareVideoEncoder hardwareVideoEncoder;
        Bundle bundle;
        HardwareVideoEncoder hardwareVideoEncoder2 = string;
        hardwareVideoEncoder2.outputThreadChecker.checkIsOnValidThread();
        hardwareVideoEncoder2.adjustedBitrate = hardwareVideoEncoder2.bitrateAdjuster.getAdjustedBitrateBps();
        Bundle bundle2 = bundle;
        try {
            hardwareVideoEncoder = string;
            bundle2();
            String string = "video-bitrate";
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "updateBitrate failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        bundle.putInt(string, hardwareVideoEncoder.adjustedBitrate);
        hardwareVideoEncoder2.codec.setParameters(bundle2);
        return VideoCodecStatus.OK;
    }

    private boolean canUseSurface() {
        return this.sharedContext != null && this.surfaceColorFormat != null;
    }

    private /* synthetic */ void a(int n) {
        try {
            this.codec.releaseOutputBuffer(n, false);
        }
        catch (Exception exception) {
            Logging.e(TAG, "releaseOutputBuffer failed", exception);
        }
        this.outputBuffersBusyCount.decrement();
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        int n;
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = callback;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.useSurfaceMode = this.canUseSurface();
        int n2 = settings.startBitrate;
        if (n2 != 0 && (n = settings.maxFramerate) != 0) {
            this.bitrateAdjuster.setTargets(n2 * 1000, n);
        }
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.adjustedBitrate = hardwareVideoEncoder.bitrateAdjuster.getAdjustedBitrateBps();
        Logging.d(TAG, "initEncode: " + this.width + " x " + this.height + ". @ " + settings.startBitrate + "kbps. Fps: " + settings.maxFramerate + " Use surface mode: " + this.useSurfaceMode);
        return hardwareVideoEncoder.initEncodeInternal();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public VideoCodecStatus release() {
        v0 = this;
        v0.encodeThreadChecker.checkIsOnValidThread();
        if (v0.outputThread == null) {
            while (true) {
                var1_1 /* !! */  = VideoCodecStatus.OK;
                break;
            }
        } else {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e("HardwareVideoEncoder", "Media encoder release timeout");
                var1_1 /* !! */  = VideoCodecStatus.TIMEOUT;
            } else {
                if (this.shutdownException == null) ** continue;
                var1_1 /* !! */  = this.shutdownException;
                Logging.e("HardwareVideoEncoder", "Media encoder release exception", (Throwable)var1_1 /* !! */ );
                var1_1 /* !! */  = VideoCodecStatus.ERROR;
            }
        }
        v1 = this;
        v1.textureDrawer.release();
        v1.videoFrameDrawer.release();
        var2_2 = v1.textureEglBase;
        if (var2_2 != null) {
            var2_2.release();
            this.textureEglBase = null;
        }
        if ((var2_2 = this.textureInputSurface) != null) {
            var2_2.release();
            this.textureInputSurface = null;
        }
        v2 = this;
        v2.outputBuilders.clear();
        v2.codec = null;
        v2.outputBuffers = null;
        v2.outputThread = null;
        v2.encodeThreadChecker.detachThread();
        return var1_1 /* !! */ ;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame object, VideoEncoder.EncodeInfo encodeInfo) {
        VideoCodecStatus videoCodecStatus;
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        if (hardwareVideoEncoder.codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        VideoFrame videoFrame = object;
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        boolean bl = buffer instanceof VideoFrame.TextureBuffer;
        int n = videoFrame.getBuffer().getWidth();
        int n2 = videoFrame.getBuffer().getHeight();
        bl = this.canUseSurface() && bl;
        if ((n != this.width || n2 != this.height || bl != this.useSurfaceMode) && (videoCodecStatus = this.resetCodec(n, n2, bl)) != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        if (this.outputBuilders.size() > 2) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            return VideoCodecStatus.NO_OUTPUT;
        }
        int n3 = 0;
        Object object2 = encodeInfo.frameTypes;
        n = encodeInfo.frameTypes.length;
        for (n2 = 0; n2 < n; ++n2) {
            if (object2[n2] != EncodedImage.FrameType.VideoFrameKey) continue;
            n3 = 1;
        }
        if (n3 != 0 || this.shouldForceKeyFrame(object.getTimestampNs())) {
            this.requestKeyFrame(object.getTimestampNs());
        }
        HardwareVideoEncoder hardwareVideoEncoder2 = this;
        n3 = buffer.getHeight() * buffer.getWidth() * 3 / 2;
        object2 = EncodedImage.builder().setCaptureTimeNs(object.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(object.getBuffer().getWidth()).setEncodedHeight(object.getBuffer().getHeight()).setRotation(object.getRotation());
        hardwareVideoEncoder2.outputBuilders.offer((EncodedImage.Builder)object2);
        object = hardwareVideoEncoder2.useSurfaceMode ? this.encodeTextureBuffer((VideoFrame)object) : this.encodeByteBuffer((VideoFrame)object, buffer, n3);
        if (object != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
        }
        return object;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int n) {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (n > 30) {
            n = 30;
        }
        this.bitrateAdjuster.setTargets(bitrateAllocation.getSum(), n);
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        HardwareVideoEncoder hardwareVideoEncoder = object;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        if (hardwareVideoEncoder.automaticResizeOn) {
            Object object = object.codecType;
            if (object == VideoCodecMimeType.VP8) {
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (object == VideoCodecMimeType.H264) {
                return new VideoEncoder.ScalingSettings(24, 37);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public String getImplementationName() {
        return "HWEncoder";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void deliverEncodedImage() {
        block32: {
            block33: {
                block30: {
                    block29: {
                        block28: {
                            v0 = this;
                            v0.outputThreadChecker.checkIsOnValidThread();
                            var1_2 = v1;
                            v1 = new MediaCodec.BufferInfo();
                            var2_3 = v0.codec.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_2, 100000L);
                            if (var2_3 >= 0) ** GOTO lbl14
                            if (var2_3 != -3) ** GOTO lbl13
                            v2 = this;
                            v2.outputBuffersBusyCount.waitForZero();
                            v2.outputBuffers = v2.codec.getOutputBuffers();
lbl13:
                            // 2 sources

                            return;
lbl14:
                            // 1 sources

                            v3 = var1_2;
                            var3_4 /* !! */  = this.outputBuffers[var2_3];
                            v4 = var1_2;
                            var3_4 /* !! */ .position(var1_2.offset);
                            v5 = v4.offset + var1_2.size;
                            var3_4 /* !! */ .limit(v5);
                            if ((v3.flags & 2) == 0) break block28;
                            Logging.d("HardwareVideoEncoder", "Config frame generated. Offset: " + var1_2.offset + ". Size: " + var1_2.size);
                            var1_2 = ByteBuffer.allocateDirect(var1_2.size);
                            this.configBuffer = var1_2;
                            var1_2.put(var3_4 /* !! */ );
                            break block32;
                        }
                        v6 = this;
                        v6.bitrateAdjuster.reportEncodedFrame(var1_2.size);
                        if (v6.adjustedBitrate == this.bitrateAdjuster.getAdjustedBitrateBps()) break block29;
                        this.updateBitrate();
                    }
                    var4_5 = (var1_2.flags & 1) != 0;
                    if (!var4_5) break block30;
                    Logging.d("HardwareVideoEncoder", "Sync frame generated");
                }
                if (var4_5) {
                    if (this.codecType != VideoCodecMimeType.H264) ** break block31
                    Logging.d("HardwareVideoEncoder", "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + var1_2.offset + ", size " + var1_2.size);
                    v7 = var1_2.size + this.configBuffer.capacity();
                    var1_2 = ByteBuffer.allocateDirect(v7);
                    v8 /* !! */  = var3_4 /* !! */ ;
                    v9 = var1_2;
                    v10 = this;
                    v11 = v10;
                    v10.configBuffer.rewind();
                    v9.put(v11.configBuffer);
                    var1_2.put(v8 /* !! */ );
                    var1_2.rewind();
                } else {
                    var1_2 = var3_4 /* !! */ .slice();
                }
                if (!var4_5) break block33;
                v12 = EncodedImage.FrameType.VideoFrameKey;
lbl81:
                // 2 sources

                while (true) {
                    var3_4 /* !! */  = v12;
                    ** GOTO lbl88
                    break;
                }
            }
            v12 = EncodedImage.FrameType.VideoFrameDelta;
            ** continue;
lbl88:
            // 1 sources

            v13 = this;
            v13.outputBuffersBusyCount.increment();
            v14 = v13.outputBuilders.poll().setBuffer((ByteBuffer)var1_2, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(int ), ()V)((HardwareVideoEncoder)this, (int)var2_3)).setFrameType((EncodedImage.FrameType)var3_4 /* !! */ ).createEncodedImage();
            try {
                this.callback.onEncodedFrame(v14, new VideoEncoder.CodecSpecificInfo());
                v14.release();
            }
            catch (IllegalStateException var0_1) {
                Logging.e("HardwareVideoEncoder", "deliverOutput failed", var0_1);
            }
        }
    }

    protected void fillInputBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
        this.yuvFormat.fillBuffer(byteBuffer, buffer);
    }

    private static abstract class YuvFormat
    extends Enum<YuvFormat> {
        public static final /* enum */ YuvFormat I420;
        public static final /* enum */ YuvFormat NV12;
        private static final /* synthetic */ YuvFormat[] $VALUES;

        public static YuvFormat[] values() {
            return (YuvFormat[])$VALUES.clone();
        }

        public static YuvFormat valueOf(String string) {
            return Enum.valueOf(YuvFormat.class, string);
        }

        static YuvFormat valueOf(int n) {
            if (n != 19) {
                if (n != 21 && n != 2141391872 && n != 2141391876) {
                    throw new IllegalArgumentException("Unsupported colorFormat: " + n);
                }
                return NV12;
            }
            return I420;
        }

        static {
            YuvFormat yuvFormat;
            I420 = new YuvFormat(){

                @Override
                void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer object) {
                    Object object2 = this = object.toI420();
                    int n = object2.getStrideY();
                    object = object2.getDataU();
                    int n2 = object2.getStrideU();
                    ByteBuffer byteBuffer2 = object2.getDataV();
                    int n3 = object2.getStrideV();
                    int n4 = object2.getWidth();
                    int n5 = object2.getHeight();
                    YuvHelper.I420Copy(this.getDataY(), n, (ByteBuffer)object, n2, byteBuffer2, n3, byteBuffer, n4, n5);
                    this.release();
                }
            };
            YuvFormat yuvFormat2 = yuvFormat;
            NV12 = new YuvFormat(){

                @Override
                void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer object) {
                    Object object2 = this = object.toI420();
                    int n = object2.getStrideY();
                    object = object2.getDataU();
                    int n2 = object2.getStrideU();
                    ByteBuffer byteBuffer2 = object2.getDataV();
                    int n3 = object2.getStrideV();
                    int n4 = object2.getWidth();
                    int n5 = object2.getHeight();
                    YuvHelper.I420ToNV12(this.getDataY(), n, (ByteBuffer)object, n2, byteBuffer2, n3, byteBuffer, n4, n5);
                    this.release();
                }
            };
            $VALUES = new YuvFormat[]{I420, yuvFormat2};
        }

        abstract void fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2);
    }

    private static class BusyCount {
        private final Object countLock;
        private int count;

        private BusyCount() {
            Object object;
            Object object2 = object;
            object = new Object();
            v1.countLock = object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increment() {
            Object object = this.countLock;
            synchronized (object) {
                int n = this.count;
                this.count = n + 1;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void decrement() {
            BusyCount busyCount = this;
            Object object = busyCount.countLock;
            synchronized (object) {
                int n = busyCount.count - 1;
                {
                    this.count = n;
                    if (n == 0) {
                        this.countLock.notifyAll();
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitForZero() {
            boolean bl = false;
            Object object = this.countLock;
            synchronized (object) {
                while (this.count > 0) {
                    try {
                        this.countLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Logging.e(HardwareVideoEncoder.TAG, "Interrupted while waiting on busy count", interruptedException);
                        bl = true;
                    }
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : object
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
        }
    }
}

