/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.Surface;
import org.otwebrtc.EglBase;
import org.otwebrtc.EglBase14;
import org.otwebrtc.Logging;

@TargetApi(value=18)
class EglBase14Impl
implements EglBase14 {
    private static final String TAG = "EglBase14Impl";
    private static final int EGLExt_SDK_VERSION = 18;
    private static final int CURRENT_SDK_VERSION = Build.VERSION.SDK_INT;
    private EGLContext eglContext;
    @Nullable
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface;

    public static boolean isEGL14Supported() {
        String string = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("SDK version: ").append(CURRENT_SDK_VERSION).append(". isEGL14Supported: ");
        boolean bl = CURRENT_SDK_VERSION >= 18;
        Logging.d(string, stringBuilder.append(bl).toString());
        return CURRENT_SDK_VERSION >= 18;
    }

    public EglBase14Impl(EGLContext eGLContext, int[] nArray) {
        EGLContext eGLContext2 = eGLContext;
        EglBase14Impl eglBase14Impl = this;
        this.eglSurface = EGL14.EGL_NO_SURFACE;
        eGLContext = EglBase14Impl.getEglDisplay();
        this.eglDisplay = eGLContext;
        this.eglConfig = EglBase14Impl.getEglConfig((EGLDisplay)eGLContext, nArray);
        int n = EglBase.getOpenGlesVersionFromConfig(nArray);
        Logging.d(TAG, "Using OpenGL ES version " + n);
        eGLContext = eglBase14Impl.eglDisplay;
        this.eglContext = EglBase14Impl.createEglContext(eGLContext2, (EGLDisplay)eGLContext, eglBase14Impl.eglConfig, n);
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a Surface or SurfaceTexture");
        }
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface == EGL14.EGL_NO_SURFACE) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = 12344;
            this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)object, (int[])nArray2, (int)0);
            if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY && this.eglContext != EGL14.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    private static EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
        if (eGLDisplay != EGL14.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (EGL14.eglInitialize((EGLDisplay)eGLDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                return eGLDisplay;
            }
            throw new RuntimeException("Unable to initialize EGL14: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        throw new RuntimeException("Unable to get EGL14 display: 0x" + Integer.toHexString(EGL14.eglGetError()));
    }

    private static EGLConfig getEglConfig(EGLDisplay eGLConfig, int[] nArray) {
        if (EGL14.eglChooseConfig((EGLDisplay)eGLConfig, (int[])nArray, (int)0, (EGLConfig[])(eGLConfig = new EGLConfig[1]), (int)0, (int)1, (int[])(nArray = new int[1]), (int)0)) {
            if (nArray[0] > 0) {
                if ((eGLConfig = eGLConfig[0]) != null) {
                    return eGLConfig;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EGLContext createEglContext(@Nullable EGLContext object, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n) {
        if (object != null && object == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 12440;
        nArray[1] = n;
        nArray[2] = 12344;
        if (object == null) {
            object = EGL14.EGL_NO_CONTEXT;
        }
        Object object2 = object;
        object = EglBase.lock;
        synchronized (object) {
            eGLDisplay = EGL14.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)object2, (int[])nArray2, (int)0);
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : object
            if (eGLDisplay == EGL14.EGL_NO_CONTEXT) throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(EGL14.eglGetError()));
            return eGLDisplay;
        }
    }

    @Override
    public void createSurface(Surface surface) {
        this.createSurfaceInternal(surface);
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n, int n2) {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface == EGL14.EGL_NO_SURFACE) {
            int[] nArray = new int[5];
            int[] nArray2 = nArray;
            nArray[0] = 12375;
            nArray[1] = n;
            nArray[2] = 12374;
            nArray[3] = n2;
            nArray[4] = 12344;
            this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])nArray2, (int)0);
            if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException("Failed to create pixel buffer surface with size " + n + "x" + n2 + ": 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL14.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        EGLSurface eGLSurface = this.eglSurface;
        if (eGLSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)eGLSurface);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void release() {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        eglBase14Impl.releaseSurface();
        eglBase14Impl.detachCurrent();
        Object object = EglBase.lock;
        // MONITORENTER : object
        EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        EGL14.eglReleaseThread();
        EGL14.eglTerminate((EGLDisplay)eglBase14Impl.eglDisplay);
        eglBase14Impl.eglContext = EGL14.EGL_NO_CONTEXT;
        eglBase14Impl.eglDisplay = EGL14.EGL_NO_DISPLAY;
        eglBase14Impl.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void makeCurrent() {
        EglBase14Impl eglBase14Impl = eglBase14Impl5;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface == EGL14.EGL_NO_SURFACE) throw new RuntimeException("No EGLSurface - can't make current");
        Object object = EglBase.lock;
        synchronized (object) {
            EGLDisplay eGLDisplay = eglBase14Impl5.eglDisplay;
            EglBase14Impl eglBase14Impl2 = eglBase14Impl5;
            EglBase14Impl eglBase14Impl3 = eglBase14Impl2;
            EglBase14Impl eglBase14Impl4 = eglBase14Impl2;
            EglBase14Impl eglBase14Impl5 = eglBase14Impl2.eglSurface;
            EGLSurface eGLSurface = eglBase14Impl4.eglSurface;
            EGLContext eGLContext = eglBase14Impl3.eglContext;
            if (!EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay, (EGLSurface)eglBase14Impl5, (EGLSurface)eGLSurface, (EGLContext)eGLContext)) throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void detachCurrent() {
        EglBase14Impl eglBase14Impl = object;
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)eglBase14Impl.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface != EGL14.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            synchronized (object) {
                EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers(long l) {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface != EGL14.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            EglBase14Impl eglBase14Impl2 = this;
            synchronized (object) {
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)eglBase14Impl2.eglDisplay, (EGLSurface)this.eglSurface, (long)l);
                EGL14.eglSwapBuffers((EGLDisplay)eglBase14Impl2.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    public static class Context
    implements EglBase14.Context {
        private final EGLContext egl14Context;

        public Context(EGLContext eGLContext) {
            this.egl14Context = eGLContext;
        }

        @Override
        public EGLContext getRawContext() {
            return this.egl14Context;
        }

        @Override
        @TargetApi(value=21)
        public long getNativeEglContext() {
            return CURRENT_SDK_VERSION >= 21 ? this.egl14Context.getNativeHandle() : (long)this.egl14Context.getHandle();
        }
    }
}

