/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Range;
import android.view.Surface;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.Camera2Enumerator;
import org.otwebrtc.CameraEnumerationAndroid;
import org.otwebrtc.CameraSession;
import org.otwebrtc.Histogram;
import org.otwebrtc.Logging;
import org.otwebrtc.Size;
import org.otwebrtc.SurfaceTextureHelper;
import org.otwebrtc.TextureBufferImpl;
import org.otwebrtc.VideoFrame;

@TargetApi(value=21)
class Camera2Session
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private static final Histogram camera2StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera2StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera2ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera2.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.CreateSessionCallback callback;
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final CameraManager cameraManager;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final String cameraId;
    private final int width;
    private final int height;
    private final int framerate;
    private CameraCharacteristics cameraCharacteristics;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private int fpsUnitFactor;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    @Nullable
    private CameraDevice cameraDevice;
    @Nullable
    private Surface surface;
    @Nullable
    private CameraCaptureSession captureSession;
    private SessionState state = SessionState.RUNNING;
    private boolean firstFrameReported;
    private final long constructionTimeNs;

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string, int n, int n2, int n3) {
        new Camera2Session(createSessionCallback, events, context, cameraManager, surfaceTextureHelper, string, n, n2, n3);
    }

    private Camera2Session(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string, int n, int n2, int n3) {
        Logging.d(TAG, "Create new camera2 session on camera " + string);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = createSessionCallback;
        this.events = events;
        this.applicationContext = context;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = string;
        this.width = n;
        this.height = n2;
        this.framerate = n3;
        this.start();
    }

    private void start() {
        CameraCharacteristics cameraCharacteristics;
        Camera2Session camera2Session = this;
        camera2Session.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        try {
            cameraCharacteristics = camera2Session.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("getCameraCharacteristics(): " + cameraAccessException.getMessage());
            return;
        }
        this.cameraCharacteristics = cameraCharacteristics;
        camera2Session.cameraOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        boolean bl = (Integer)camera2Session.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        Camera2Session camera2Session2 = this;
        camera2Session2.isCameraFrontFacing = bl;
        camera2Session2.findCaptureFormat();
        camera2Session2.openCamera();
    }

    private void findCaptureFormat() {
        int n;
        Camera2Session camera2Session = this;
        camera2Session.checkIsOnCameraThread();
        Range[] rangeArray = (Range[])camera2Session.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = n = Camera2Enumerator.getFpsUnitFactor(rangeArray);
        Object object = Camera2Enumerator.convertFramerates(rangeArray, n);
        List<Size> list = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available preview sizes: " + list);
        Logging.d(TAG, "Available fps ranges: " + object);
        if (!object.isEmpty() && !list.isEmpty()) {
            Camera2Session camera2Session2 = this;
            object = CameraEnumerationAndroid.getClosestSupportedFramerateRange(object, this.framerate);
            int n2 = camera2Session2.width;
            Size size = CameraEnumerationAndroid.getClosestSupportedSize(list, n2, camera2Session2.height);
            CameraEnumerationAndroid.reportCameraResolution(camera2ResolutionHistogram, size);
            Size size2 = size;
            int n3 = size2.width;
            this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(n3, size2.height, (CameraEnumerationAndroid.CaptureFormat.FramerateRange)object);
            Logging.d(TAG, "Using capture format: " + this.captureFormat);
            return;
        }
        this.reportError("No supported capture formats.");
    }

    private void openCamera() {
        CameraStateCallback cameraStateCallback;
        String string;
        Camera2Session camera2Session;
        CameraManager cameraManager;
        Camera2Session camera2Session2 = this;
        camera2Session2.checkIsOnCameraThread();
        Logging.d(TAG, "Opening camera " + this.cameraId);
        camera2Session2.events.onCameraOpening();
        try {
            cameraManager = camera2Session2.cameraManager;
            Camera2Session camera2Session3 = this;
            camera2Session = camera2Session3;
            string = camera2Session3.cameraId;
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("Failed to open camera: " + (Object)((Object)cameraAccessException));
            return;
        }
        CameraStateCallback cameraStateCallback2 = cameraStateCallback;
        cameraStateCallback = new CameraStateCallback();
        Handler handler = camera2Session.cameraThreadHandler;
        cameraManager.openCamera(string, (CameraDevice.StateCallback)cameraStateCallback2, handler);
    }

    private void stopInternal() {
        Camera2Session camera2Session = this;
        Logging.d(TAG, "Stop internal");
        camera2Session.checkIsOnCameraThread();
        camera2Session.surfaceTextureHelper.stopListening();
        CameraCaptureSession cameraCaptureSession = camera2Session.captureSession;
        if (cameraCaptureSession != null) {
            cameraCaptureSession.close();
            this.captureSession = null;
        }
        if ((cameraCaptureSession = this.surface) != null) {
            cameraCaptureSession.release();
            this.surface = null;
        }
        if ((cameraCaptureSession = this.cameraDevice) != null) {
            cameraCaptureSession.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
    }

    private void reportError(String string) {
        Camera2Session camera2Session = this;
        camera2Session.checkIsOnCameraThread();
        Logging.e(TAG, "Error: " + string);
        boolean bl = camera2Session.captureSession == null && this.state != SessionState.STOPPED;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (bl) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, string);
        } else {
            this.events.onCameraError(this, string);
        }
    }

    private int getFrameOrientation() {
        Camera2Session camera2Session = this;
        int n = CameraSession.getDeviceOrientation(camera2Session.applicationContext);
        if (!camera2Session.isCameraFrontFacing) {
            n = 360 - n;
        }
        return (this.cameraOrientation + n) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Wrong thread");
    }

    static /* synthetic */ SessionState access$202(Camera2Session camera2Session, SessionState sessionState) {
        camera2Session.state = sessionState;
        return sessionState;
    }

    static /* synthetic */ CameraDevice access$702(Camera2Session camera2Session, CameraDevice cameraDevice) {
        camera2Session.cameraDevice = cameraDevice;
        return cameraDevice;
    }

    static /* synthetic */ Surface access$1002(Camera2Session camera2Session, Surface surface) {
        camera2Session.surface = surface;
        return surface;
    }

    static /* synthetic */ CameraCaptureSession access$102(Camera2Session camera2Session, CameraCaptureSession cameraCaptureSession) {
        camera2Session.captureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    static /* synthetic */ boolean access$1602(Camera2Session camera2Session, boolean bl) {
        camera2Session.firstFrameReported = bl;
        return bl;
    }

    @Override
    public void stop() {
        Camera2Session camera2Session = this;
        Logging.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        camera2Session.checkIsOnCameraThread();
        if (camera2Session.state != SessionState.STOPPED) {
            long l = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            camera2StopTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l));
        }
    }

    private static class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            Logging.d(Camera2Session.TAG, "Capture failed: " + captureFailure);
        }
    }

    private class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        private void chooseStabilizationMode(CaptureRequest.Builder builder) {
            int n;
            int[] nArray = (int[])object.Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (nArray != null) {
                n = nArray.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (nArray[i2] != 1) continue;
                    CaptureRequest.Builder builder2 = builder;
                    builder2.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    builder2.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            int[] nArray2 = (int[])object.Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
            Object object = nArray2;
            int n2 = nArray2.length;
            for (n = 0; n < n2; ++n) {
                if (object[n] != true) continue;
                CaptureRequest.Builder builder3 = builder;
                builder3.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                builder3.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder builder) {
            int[] nArray = (int[])object.Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            Object object = nArray;
            int n = nArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (object[i2] != 3) continue;
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            cameraCaptureSession.close();
            Camera2Session.this.reportError("Failed to configure capture session.");
        }

        public void onConfigured(CameraCaptureSession object) {
            CameraCaptureCallback cameraCaptureCallback;
            CaptureSessionCallback captureSessionCallback = this;
            CameraCaptureSession cameraCaptureSession = object;
            CaptureSessionCallback captureSessionCallback2 = this;
            captureSessionCallback2.Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.access$102(captureSessionCallback2.Camera2Session.this, object);
            try {
                object = captureSessionCallback2.Camera2Session.this.cameraDevice.createCaptureRequest(3);
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to start capture request. " + (Object)((Object)cameraAccessException));
                return;
            }
            CaptureSessionCallback captureSessionCallback3 = this;
            CameraCaptureSession cameraCaptureSession2 = object;
            cameraCaptureSession2.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
            cameraCaptureSession2.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            cameraCaptureSession2.set(CaptureRequest.CONTROL_AE_LOCK, (Object)Boolean.FALSE);
            this.chooseStabilizationMode((CaptureRequest.Builder)cameraCaptureSession2);
            captureSessionCallback3.chooseFocusMode((CaptureRequest.Builder)object);
            object.addTarget(captureSessionCallback3.Camera2Session.this.surface);
            CaptureRequest captureRequest = object.build();
            CaptureSessionCallback captureSessionCallback4 = this;
            object = cameraCaptureCallback;
            cameraCaptureCallback = new CameraCaptureCallback();
            cameraCaptureSession.setRepeatingRequest(captureRequest, (CameraCaptureSession.CaptureCallback)object, captureSessionCallback4.Camera2Session.this.cameraThreadHandler);
            captureSessionCallback.Camera2Session.this.surfaceTextureHelper.startListening(refCounted -> {
                VideoFrame videoFrame;
                CaptureSessionCallback captureSessionCallback = this;
                captureSessionCallback.Camera2Session.this.checkIsOnCameraThread();
                if (captureSessionCallback.Camera2Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                    return;
                }
                if (!Camera2Session.this.firstFrameReported) {
                    Camera2Session.access$1602(Camera2Session.this, true);
                    camera2StartTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera2Session.this.constructionTimeNs));
                }
                VideoFrame videoFrame2 = videoFrame;
                VideoFrame videoFrame3 = refCounted;
                refCounted = CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)refCounted.getBuffer(), Camera2Session.this.isCameraFrontFacing, -Camera2Session.this.cameraOrientation);
                int n = Camera2Session.this.getFrameOrientation();
                long l = videoFrame3.getTimestampNs();
                videoFrame2((VideoFrame.Buffer)((Object)refCounted), n, l);
                Camera2Session.this.events.onFrameCaptured(Camera2Session.this, videoFrame2);
                videoFrame.release();
            });
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            captureSessionCallback.Camera2Session.this.callback.onDone(Camera2Session.this);
        }
    }

    private class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        private String getErrorDescription(int n) {
            switch (n) {
                default: {
                    return "Unknown camera error: " + n;
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
                case 1: 
            }
            return "Camera device is in use already.";
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            boolean bl = cameraStateCallback.Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            CameraStateCallback cameraStateCallback2 = this;
            Camera2Session.access$202(cameraStateCallback2.Camera2Session.this, SessionState.STOPPED);
            cameraStateCallback2.Camera2Session.this.stopInternal();
            if (bl) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.");
            } else {
                Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
            }
        }

        public void onError(CameraDevice cameraDevice, int n) {
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            cameraStateCallback.Camera2Session.this.reportError(this.getErrorDescription(n));
        }

        public void onOpened(CameraDevice object) {
            CaptureSessionCallback captureSessionCallback;
            Surface[] surfaceArray;
            CameraDevice cameraDevice = object;
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.access$702(cameraStateCallback.Camera2Session.this, object);
            cameraStateCallback.Camera2Session.this.surfaceTextureHelper.setTextureSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
            Camera2Session.access$1002(cameraStateCallback.Camera2Session.this, new Surface(Camera2Session.this.surfaceTextureHelper.getSurfaceTexture()));
            try {
                surfaceArray = new Surface[1];
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to create capture session. " + (Object)((Object)cameraAccessException));
                return;
            }
            surfaceArray[0] = Camera2Session.this.surface;
            List<Surface> list = Arrays.asList(surfaceArray);
            CameraStateCallback cameraStateCallback2 = this;
            object = captureSessionCallback;
            captureSessionCallback = new CaptureSessionCallback();
            cameraDevice.createCaptureSession(list, (CameraCaptureSession.StateCallback)object, cameraStateCallback2.Camera2Session.this.cameraThreadHandler);
        }

        public void onClosed(CameraDevice cameraDevice) {
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            cameraStateCallback.Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    private static final class SessionState
    extends Enum<SessionState> {
        public static final /* enum */ SessionState RUNNING;
        public static final /* enum */ SessionState STOPPED;
        private static final /* synthetic */ SessionState[] $VALUES;

        public static SessionState[] values() {
            return (SessionState[])$VALUES.clone();
        }

        public static SessionState valueOf(String string) {
            return Enum.valueOf(SessionState.class, string);
        }

        static {
            SessionState sessionState;
            RUNNING = new SessionState();
            SessionState sessionState2 = sessionState;
            STOPPED = new SessionState();
            $VALUES = new SessionState[]{RUNNING, sessionState2};
        }
    }
}

