/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.DefaultAudioDevice;
import com.opentok.android.OtLog;
import java.util.List;

public class BluetoothManager {
    private final OtLog.LogToken log;
    private boolean isBluetoothBroadcastReceiverRegistered;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothProfile bluetoothProfile;
    private AudioManager audioManager;
    private Context audioDeviceContext;
    private BaseAudioDevice.BluetoothState bluetoothState;
    private DefaultAudioDevice audioDevice;
    private BluetoothDevice bluetoothDevice;
    private final BluetoothProfile.ServiceListener bluetoothProfileServiceListener;
    private final BroadcastReceiver bluetoothBroadcastReceiver;

    static BluetoothManager create(Context context, DefaultAudioDevice defaultAudioDevice) {
        return new BluetoothManager(context, defaultAudioDevice);
    }

    protected BluetoothManager(Context context, DefaultAudioDevice defaultAudioDevice) {
        AudioManager audioManager;
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log = new OtLog.LogToken(this);
        bluetoothManager.bluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

            public void onServiceConnected(int n, BluetoothProfile bluetoothProfile) {
                if (Build.VERSION.SDK_INT >= 31 && BluetoothManager.this.audioDeviceContext.checkSelfPermission("android.permission.BLUETOOTH_CONNECT") != 0) {
                    BluetoothManager.this.log.e("Audio may not route through paired Bluetooth device unless the bluetooth permission has been granted explicitly in the App settings.", new Object[0]);
                    return;
                }
                BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceConnected() enter.", new Object[0]);
                if (1 == n) {
                    BluetoothManager.access$202(BluetoothManager.this, bluetoothProfile);
                    List list = bluetoothProfile.getConnectedDevices();
                    if (!list.isEmpty() && 2 == bluetoothProfile.getConnectionState((BluetoothDevice)list.get(0))) {
                        Intent intent;
                        1 v0 = this;
                        BluetoothManager.access$302(v0.BluetoothManager.this, (BluetoothDevice)list.get(0));
                        v0.BluetoothManager.this.log.d("Connected to bluetooth headset " + BluetoothManager.this.bluetoothDevice.getName(), new Object[0]);
                        list = intent;
                        new Intent("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED").putExtra("android.bluetooth.profile.extra.STATE", 2);
                        v0.BluetoothManager.this.bluetoothBroadcastReceiver.onReceive(BluetoothManager.this.audioDeviceContext, (Intent)list);
                    } else {
                        BluetoothManager.this.log.d("No bluetooth headset connected.", new Object[0]);
                    }
                } else {
                    BluetoothManager.this.log.d("profile = " + n, new Object[0]);
                }
                BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceConnected() exit.", new Object[0]);
            }

            public void onServiceDisconnected(int n) {
                BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceDisconnected() enter.", new Object[0]);
                if (n != 1) {
                    return;
                }
                1 v0 = this;
                BluetoothManager.access$302(v0.BluetoothManager.this, null);
                BluetoothManager.access$202(v0.BluetoothManager.this, null);
                v0.BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceDisconnected() exit.", new Object[0]);
            }
        };
        bluetoothManager.bluetoothBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getAction();
                if (object == null) {
                    BluetoothManager.this.log.e("bluetoothBroadcastReceiver.onReceive(): error !!", new Object[0]);
                    return;
                }
                int n = -1;
                int n2 = ((String)object).hashCode();
                if (n2 != -1692127708) {
                    if (n2 != -1435586571) {
                        if (n2 == 545516589 && ((String)object).equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                            n = 0;
                        }
                    } else if (((String)object).equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                        n = 2;
                    }
                } else if (((String)object).equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                    n = 1;
                }
                if (n != 0) {
                    if (n != 1) {
                        if (n == 2) {
                            switch (intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1)) {
                                default: {
                                    break;
                                }
                                case 12: {
                                    BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): BluetoothHeadset.STATE_AUDIO_CONNECTED", new Object[0]);
                                    break;
                                }
                                case 11: {
                                    BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): BluetoothHeadset.STATE_AUDIO_CONNECTING", new Object[0]);
                                    break;
                                }
                                case 10: {
                                    BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): BluetoothHeadset.STATE_AUDIO_DISCONNECTED", new Object[0]);
                                    break;
                                }
                            }
                        }
                    } else {
                        switch (intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1)) {
                            default: {
                                break;
                            }
                            case 2: {
                                BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): AudioManager.SCO_AUDIO_STATE_CONNECTING", new Object[0]);
                                break;
                            }
                            case 1: {
                                2 v0 = this;
                                v0.BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): AudioManager.SCO_AUDIO_STATE_CONNECTED", new Object[0]);
                                v0.BluetoothManager.this.setBluetoothState(BaseAudioDevice.BluetoothState.Connected);
                                v0.BluetoothManager.this.audioDevice.setOutputMode(BaseAudioDevice.OutputMode.Handset);
                                break;
                            }
                            case 0: {
                                2 v1 = this;
                                v1.BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): AudioManager.SCO_AUDIO_STATE_DISCONNECTED", new Object[0]);
                                if (v1.isInitialStickyBroadcast()) {
                                    BluetoothManager.this.log.d("Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.", new Object[0]);
                                    return;
                                }
                                2 v2 = this;
                                v2.BluetoothManager.this.setBluetoothState(BaseAudioDevice.BluetoothState.Disconnected);
                                v2.BluetoothManager.this.audioDevice.restoreAudioAfterBluetoothDisconnect();
                                break;
                            }
                            case -1: {
                                BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): AudioManager.SCO_AUDIO_STATE_ERROR", new Object[0]);
                                break;
                            }
                        }
                    }
                } else {
                    int n3 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    if (n3 != 0) {
                        if (n3 != 2) {
                            if (n3 == 3) {
                                BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): BluetoothHeadset.STATE_DISCONNECTING", new Object[0]);
                            }
                        } else {
                            2 v3 = this;
                            v3.BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): BluetoothHeadset.STATE_CONNECTED", new Object[0]);
                            v3.BluetoothManager.this.startBluetoothSCO();
                        }
                    } else {
                        2 v4 = this;
                        v4.BluetoothManager.this.log.d("bluetoothBroadcastReceiver.onReceive(): BluetoothHeadset.STATE_DISCONNECTED", new Object[0]);
                        v4.BluetoothManager.this.stopBluetoothSCO();
                    }
                }
            }
        };
        bluetoothManager.log.d("BluetoothManager constructor enter.", new Object[0]);
        this.audioManager = audioManager = (AudioManager)context.getSystemService("audio");
        if (!audioManager.isBluetoothScoAvailableOffCall()) {
            this.log.e("Bluetooth SCO audio is not available off call", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.audioDeviceContext = context;
        bluetoothManager2.audioDevice = defaultAudioDevice;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            this.log.w("Device does not support Bluetooth", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager3 = this;
        bluetoothManager3.setBluetoothState(BaseAudioDevice.BluetoothState.Disconnected);
        bluetoothManager3.registerBtReceiver();
        bluetoothManager3.audioManager.setBluetoothScoOn(true);
        bluetoothManager3.startBluetoothSCO();
        bluetoothManager3.log.d("BluetoothManager constructor exit.", new Object[0]);
    }

    private boolean hasEarpiece() {
        return this.audioDeviceContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    static /* synthetic */ BluetoothProfile access$202(BluetoothManager bluetoothManager, BluetoothProfile bluetoothProfile) {
        bluetoothManager.bluetoothProfile = bluetoothProfile;
        return bluetoothProfile;
    }

    static /* synthetic */ BluetoothDevice access$302(BluetoothManager bluetoothManager, BluetoothDevice bluetoothDevice) {
        bluetoothManager.bluetoothDevice = bluetoothDevice;
        return bluetoothDevice;
    }

    protected void finalize() {
        BluetoothAdapter bluetoothAdapter;
        BluetoothManager bluetoothManager = this;
        super.finalize();
        bluetoothManager.audioManager.setBluetoothScoOn(false);
        BluetoothProfile bluetoothProfile = bluetoothManager.bluetoothProfile;
        if (bluetoothProfile != null && (bluetoothAdapter = this.bluetoothAdapter) != null) {
            bluetoothAdapter.closeProfileProxy(1, bluetoothProfile);
        }
        this.setBluetoothState(BaseAudioDevice.BluetoothState.Disconnected);
    }

    void onPause() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("onPause() enter.", new Object[0]);
        bluetoothManager.log.d("onPause() exit.", new Object[0]);
    }

    void onResume() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("onResume() enter.", new Object[0]);
        bluetoothManager.forceInvokeConnectBluetooth();
        bluetoothManager.log.d("onResume() exit.", new Object[0]);
    }

    void registerBtReceiver() {
        IntentFilter intentFilter;
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("isBluetoothBroadcastReceiverRegistered = " + this.isBluetoothBroadcastReceiverRegistered, new Object[0]);
        if (bluetoothManager.isBluetoothBroadcastReceiverRegistered) {
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.log.d("registerBtReceiver() enter.", new Object[0]);
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter2.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        bluetoothManager2.audioDeviceContext.registerReceiver(this.bluetoothBroadcastReceiver, intentFilter2);
        bluetoothManager2.isBluetoothBroadcastReceiverRegistered = true;
        bluetoothManager2.log.d("registerBtReceiver() exit", new Object[0]);
    }

    public void unregisterBtReceiver() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("isBluetoothBroadcastReceiverRegistered = " + this.isBluetoothBroadcastReceiverRegistered, new Object[0]);
        if (!bluetoothManager.isBluetoothBroadcastReceiverRegistered) {
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.log.d("unregisterBtReceiver() enter", new Object[0]);
        bluetoothManager2.audioDeviceContext.unregisterReceiver(this.bluetoothBroadcastReceiver);
        bluetoothManager2.isBluetoothBroadcastReceiverRegistered = false;
        bluetoothManager2.log.d("unregisterBtReceiver() exit", new Object[0]);
    }

    void startBluetoothSCO() {
        if (this.audioDevice.isWiredHeadSetConnected()) {
            this.log.e("Bluetooth cannot be turned on when wired headset is connected.", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("startBluetoothSCO() enter <-", new Object[0]);
        try {
            bluetoothManager.audioManager.startBluetoothSco();
        }
        catch (NullPointerException nullPointerException) {
            this.log.e("startBluetoothSco(): " + nullPointerException.getMessage(), new Object[0]);
        }
        this.log.d("startBluetoothSCO() exit ->", new Object[0]);
    }

    void stopBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("stopBluetoothSCO() enter <-", new Object[0]);
        try {
            bluetoothManager.audioManager.stopBluetoothSco();
        }
        catch (NullPointerException nullPointerException) {
            this.log.e("stopBluetoothSco(): " + nullPointerException.getMessage(), new Object[0]);
        }
        this.log.d("stopBluetoothSCO() exit ->", new Object[0]);
    }

    public boolean isBluetoothConnected() {
        boolean bl = this.bluetoothDevice != null;
        this.log.d("isBluetoothConnected = " + bl, new Object[0]);
        return bl;
    }

    public boolean isBluetoothAvailable() {
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        boolean bl = bluetoothAdapter != null && bluetoothAdapter.isEnabled() && this.bluetoothProfile != null;
        this.log.d("isBluetoothAvailable = " + bl, new Object[0]);
        return bl;
    }

    BaseAudioDevice.BluetoothState getBluetoothState() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("getBluetoothState(). Current bluetoothState = " + (Object)((Object)this.bluetoothState), new Object[0]);
        return bluetoothManager.bluetoothState;
    }

    void setBluetoothState(BaseAudioDevice.BluetoothState bluetoothState) {
        this.bluetoothState = bluetoothState;
        this.log.d("setBluetoothState(). bluetoothState set to " + (Object)((Object)this.bluetoothState), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceInvokeConnectBluetooth() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("forceInvokeConnectBluetooth() enter", new Object[0]);
        Object object = bluetoothManager.audioDevice.bluetoothLock;
        synchronized (object) {
            block6: {
                if (bluetoothManager.bluetoothAdapter == null) break block6;
                BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
                BluetoothManager bluetoothManager2 = this;
                BluetoothManager bluetoothManager3 = bluetoothManager2;
                Context context = bluetoothManager2.audioDeviceContext;
                bluetoothAdapter.getProfileProxy(context, bluetoothManager3.bluetoothProfileServiceListener, 1);
            }
            // MONITOREXIT @DISABLED, blocks:[3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
            this.log.d("forceInvokeConnectBluetooth() exit", new Object[0]);
            return;
        }
    }
}

