/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.voiceengine;

import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.Timer;
import java.util.TimerTask;
import org.otwebrtc.ContextUtils;
import org.otwebrtc.Logging;
import org.otwebrtc.voiceengine.WebRtcAudioEffects;
import org.otwebrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static final boolean blacklistDeviceForAAudioUsage = true;
    private static boolean useStereoOutput;
    private static boolean useStereoInput;
    private static boolean blacklistDeviceForOpenSLESUsage;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private final long nativeAudioManager;
    private final AudioManager audioManager;
    private boolean initialized;
    private int nativeSampleRate;
    private int nativeChannels;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean lowLatencyOutput;
    private boolean lowLatencyInput;
    private boolean proAudio;
    private boolean aAudio;
    private int sampleRate;
    private int outputChannels;
    private int inputChannels;
    private int outputBufferSize;
    private int inputBufferSize;
    private final VolumeLogger volumeLogger;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean bl) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = bl;
    }

    public static synchronized void setStereoOutput(boolean bl) {
        Logging.w(TAG, "Overriding default output behavior: setStereoOutput(" + bl + ')');
        useStereoOutput = bl;
    }

    public static synchronized void setStereoInput(boolean bl) {
        Logging.w(TAG, "Overriding default input behavior: setStereoInput(" + bl + ')');
        useStereoInput = bl;
    }

    public static synchronized boolean getStereoOutput() {
        return useStereoOutput;
    }

    public static synchronized boolean getStereoInput() {
        return useStereoInput;
    }

    WebRtcAudioManager(long l) {
        WebRtcAudioManager webRtcAudioManager = webRtcAudioManager2;
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        webRtcAudioManager.nativeAudioManager = l;
        WebRtcAudioManager webRtcAudioManager2 = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        webRtcAudioManager.audioManager = webRtcAudioManager2;
        webRtcAudioManager.volumeLogger = new VolumeLogger((AudioManager)webRtcAudioManager2);
        webRtcAudioManager.storeAudioParameters();
        int n = webRtcAudioManager.sampleRate;
        int n2 = webRtcAudioManager.outputChannels;
        int n3 = webRtcAudioManager.inputChannels;
        boolean bl = webRtcAudioManager.hardwareAEC;
        boolean bl2 = webRtcAudioManager.hardwareAGC;
        boolean bl3 = webRtcAudioManager.hardwareNS;
        boolean bl4 = webRtcAudioManager.lowLatencyOutput;
        boolean bl5 = webRtcAudioManager.lowLatencyInput;
        boolean bl6 = webRtcAudioManager.proAudio;
        boolean bl7 = webRtcAudioManager.aAudio;
        int n4 = webRtcAudioManager.outputBufferSize;
        int n5 = webRtcAudioManager.inputBufferSize;
        webRtcAudioManager.nativeCacheAudioParameters(n, n2, n3, bl, bl2, bl3, bl4, bl5, bl6, bl7, n4, n5, l);
        WebRtcAudioUtils.logAudioState(TAG);
    }

    private boolean init() {
        Logging.d(TAG, "init" + WebRtcAudioUtils.getThreadInfo());
        if (this.initialized) {
            return true;
        }
        Logging.d(TAG, "audio mode is: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode()));
        this.initialized = true;
        this.volumeLogger.start();
        return true;
    }

    private void dispose() {
        Logging.d(TAG, "dispose" + WebRtcAudioUtils.getThreadInfo());
        if (!this.initialized) {
            return;
        }
        this.volumeLogger.stop();
    }

    private boolean isCommunicationModeEnabled() {
        return this.audioManager.getMode() == 3;
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean bl = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (bl) {
            Logging.d(TAG, Build.MODEL + " is blacklisted for OpenSL ES usage!");
        }
        return bl;
    }

    private void storeAudioParameters() {
        int n = WebRtcAudioManager.getStereoOutput() ? 2 : 1;
        this.outputChannels = n;
        n = WebRtcAudioManager.getStereoInput() ? 2 : 1;
        WebRtcAudioManager webRtcAudioManager = this;
        webRtcAudioManager.inputChannels = n;
        webRtcAudioManager.sampleRate = webRtcAudioManager.getNativeOutputSampleRate();
        webRtcAudioManager.hardwareAEC = WebRtcAudioManager.isAcousticEchoCancelerSupported();
        webRtcAudioManager.hardwareAGC = false;
        webRtcAudioManager.hardwareNS = WebRtcAudioManager.isNoiseSuppressorSupported();
        webRtcAudioManager.lowLatencyOutput = webRtcAudioManager.isLowLatencyOutputSupported();
        webRtcAudioManager.lowLatencyInput = webRtcAudioManager.isLowLatencyInputSupported();
        webRtcAudioManager.proAudio = webRtcAudioManager.isProAudioSupported();
        webRtcAudioManager.aAudio = webRtcAudioManager.isAAudioSupported();
        n = webRtcAudioManager.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.outputChannels);
        this.outputBufferSize = n;
        n = this.lowLatencyInput ? this.getLowLatencyInputFramesPerBuffer() : WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, this.inputChannels);
        this.inputBufferSize = n;
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private boolean isProAudioSupported() {
        return Build.VERSION.SDK_INT >= 23 && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    private boolean isAAudioSupported() {
        Logging.w(TAG, "AAudio support is currently disabled on all devices!");
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Logging.d(TAG, "Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz");
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int n = this.getSampleRateForApiLevel();
        Logging.d(TAG, "Sample rate is set to " + n + " Hz");
        return n;
    }

    private int getSampleRateForApiLevel() {
        if (Build.VERSION.SDK_INT < 17) {
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        String string = ((WebRtcAudioManager)((Object)string)).audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return string == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(string);
    }

    private int getLowLatencyOutputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(((WebRtcAudioManager)((Object)string)).isLowLatencyOutputSupported());
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        String string = ((WebRtcAudioManager)((Object)string)).audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return string == null ? 256 : Integer.parseInt(string);
    }

    private static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    private static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    private static int getMinOutputFrameSize(int n, int n2) {
        int n3 = n2;
        n2 = n3 * 2;
        int n4 = n3 == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)n, (int)n4, (int)2) / n2;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager webRtcAudioManager = this;
        WebRtcAudioManager.assertTrue(webRtcAudioManager.isLowLatencyInputSupported());
        return webRtcAudioManager.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int n, int n2) {
        int n3 = n2;
        n2 = n3 * 2;
        int n4 = n3 == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)n, (int)n4, (int)2) / n2;
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private native void nativeCacheAudioParameters(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, int var12, long var13);

    public boolean isLowLatencyInputSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.isLowLatencyOutputSupported();
    }

    private static class VolumeLogger {
        private static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
        private static final int TIMER_PERIOD_IN_SECONDS = 30;
        private final AudioManager audioManager;
        @Nullable
        private Timer timer;

        public VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        private void stop() {
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
                this.timer = null;
            }
        }

        public void start() {
            this.timer = new Timer(THREAD_NAME);
            VolumeLogger volumeLogger = this;
            int n = volumeLogger.audioManager.getStreamMaxVolume(2);
            this.timer.schedule((TimerTask)volumeLogger.new LogVolumeTask(n, volumeLogger.audioManager.getStreamMaxVolume(0)), 0L, 30000L);
        }

        private class LogVolumeTask
        extends TimerTask {
            private final int maxRingVolume;
            private final int maxVoiceCallVolume;

            LogVolumeTask(int n, int n2) {
                this.maxRingVolume = n;
                this.maxVoiceCallVolume = n2;
            }

            @Override
            public void run() {
                int n = VolumeLogger.this.audioManager.getMode();
                if (n == 1) {
                    Logging.d(WebRtcAudioManager.TAG, "STREAM_RING stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(2) + " (max=" + this.maxRingVolume + ")");
                } else if (n == 3) {
                    Logging.d(WebRtcAudioManager.TAG, "VOICE_CALL stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(0) + " (max=" + this.maxVoiceCallVolume + ")");
                }
            }
        }
    }
}

