/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.Logging;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.audio.JavaAudioDeviceModule;
import org.otwebrtc.audio.WebRtcAudioEffects;
import org.otwebrtc.audio.WebRtcAudioUtils;

class WebRtcAudioRecord {
    private static final String TAG = "WebRtcAudioRecordExternal";
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_SOURCE = 7;
    public static final int DEFAULT_AUDIO_FORMAT = 2;
    private static final int AUDIO_RECORD_START = 0;
    private static final int AUDIO_RECORD_STOP = 1;
    private static final int CHECK_REC_STATUS_DELAY_MS = 100;
    private final Context context;
    private final AudioManager audioManager;
    private final int audioSource;
    private final int audioFormat;
    private long nativeAudioRecord;
    private final WebRtcAudioEffects effects;
    @Nullable
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    @Nullable
    private AudioDeviceInfo preferredDevice;
    @Nullable
    private ScheduledExecutorService executor;
    @Nullable
    private ScheduledFuture<String> future;
    private volatile boolean microphoneMute;
    private boolean audioSourceMatchesRecordingSession;
    private boolean isAudioConfigVerified;
    private byte[] emptyBytes;
    @Nullable
    private final JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback;
    @Nullable
    private final JavaAudioDeviceModule.AudioRecordStateCallback stateCallback;
    @Nullable
    private final JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback;
    private final boolean isAcousticEchoCancelerSupported;
    private final boolean isNoiseSuppressorSupported;

    @CalledByNative
    WebRtcAudioRecord(Context context, AudioManager audioManager) {
        boolean bl = WebRtcAudioEffects.isAcousticEchoCancelerSupported();
        boolean bl2 = WebRtcAudioEffects.isNoiseSuppressorSupported();
        this(context, audioManager, 7, 2, null, null, null, bl, bl2);
    }

    public WebRtcAudioRecord(Context context, AudioManager audioManager, int n, int n2, @Nullable JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback, @Nullable JavaAudioDeviceModule.AudioRecordStateCallback audioRecordStateCallback, @Nullable JavaAudioDeviceModule.SamplesReadyCallback samplesReadyCallback, boolean bl, boolean bl2) {
        WebRtcAudioEffects webRtcAudioEffects;
        WebRtcAudioEffects webRtcAudioEffects2 = webRtcAudioEffects;
        webRtcAudioEffects = new WebRtcAudioEffects();
        this.effects = webRtcAudioEffects2;
        if (bl && !WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            throw new IllegalArgumentException("HW AEC not supported");
        }
        if (bl2 && !WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            throw new IllegalArgumentException("HW NS not supported");
        }
        this.context = context;
        this.audioManager = audioManager;
        this.audioSource = n;
        this.audioFormat = n2;
        this.errorCallback = audioRecordErrorCallback;
        this.stateCallback = audioRecordStateCallback;
        this.audioSamplesReadyCallback = samplesReadyCallback;
        this.isAcousticEchoCancelerSupported = bl;
        this.isNoiseSuppressorSupported = bl2;
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    @CalledByNative
    private boolean enableBuiltInAEC(boolean bl) {
        Logging.d(TAG, "enableBuiltInAEC(" + bl + ")");
        return this.effects.setAEC(bl);
    }

    @CalledByNative
    private boolean enableBuiltInNS(boolean bl) {
        Logging.d(TAG, "enableBuiltInNS(" + bl + ")");
        return this.effects.setNS(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private int initRecording(int n, int n2) {
        ByteBuffer byteBuffer;
        Logging.d(TAG, "initRecording(sampleRate=" + n + ", channels=" + n2 + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int n3 = n / 100;
        this.byteBuffer = byteBuffer = ByteBuffer.allocateDirect(n2 * WebRtcAudioRecord.getBytesPerSample(this.audioFormat) * n3);
        if (!byteBuffer.hasArray()) {
            this.reportWebRtcAudioRecordInitError("ByteBuffer does not have backing array.");
            return -1;
        }
        WebRtcAudioRecord webRtcAudioRecord = this;
        WebRtcAudioRecord webRtcAudioRecord2 = this;
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        webRtcAudioRecord2.emptyBytes = new byte[webRtcAudioRecord2.byteBuffer.capacity()];
        long l = webRtcAudioRecord2.nativeAudioRecord;
        ByteBuffer byteBuffer2 = webRtcAudioRecord2.byteBuffer;
        webRtcAudioRecord2.nativeCacheDirectBufferAddress(l, byteBuffer2);
        int n4 = webRtcAudioRecord.channelCountToConfiguration(n2);
        int n5 = AudioRecord.getMinBufferSize((int)n, (int)n4, (int)webRtcAudioRecord.audioFormat);
        if (n5 != -1 && n5 != -2) {
            RuntimeException runtimeException2;
            block12: {
                block11: {
                    AudioRecord audioRecord;
                    Logging.d(TAG, "AudioRecord.getMinBufferSize: " + n5);
                    n5 = Math.max(n5 * 2, this.byteBuffer.capacity());
                    Logging.d(TAG, "bufferSizeInBytes: " + n5);
                    try {
                        if (Build.VERSION.SDK_INT >= 23) {
                            WebRtcAudioRecord webRtcAudioRecord3 = this;
                            webRtcAudioRecord3.audioRecord = WebRtcAudioRecord.createAudioRecordOnMOrHigher(webRtcAudioRecord3.audioSource, n, n4, this.audioFormat, n5);
                            if (webRtcAudioRecord3.preferredDevice != null) {
                                WebRtcAudioRecord webRtcAudioRecord4 = this;
                                webRtcAudioRecord4.setPreferredDevice(webRtcAudioRecord4.preferredDevice);
                            }
                        } else {
                            this.audioRecord = WebRtcAudioRecord.createAudioRecordOnLowerThanM(this.audioSource, n, n4, this.audioFormat, n5);
                        }
                        if ((audioRecord = this.audioRecord) == null) break block11;
                    }
                    catch (UnsupportedOperationException runtimeException2) {
                        break block12;
                    }
                    catch (IllegalArgumentException runtimeException2) {
                        // empty catch block
                        break block12;
                    }
                    if (audioRecord.getState() == 1) {
                        WebRtcAudioRecord webRtcAudioRecord5 = this;
                        webRtcAudioRecord5.effects.enable(this.audioRecord.getAudioSessionId());
                        webRtcAudioRecord5.logMainParameters();
                        webRtcAudioRecord5.logMainParametersExtended();
                        int n6 = webRtcAudioRecord5.logRecordingConfigurations(false);
                        if (n6 != 0) {
                            Logging.w(TAG, "Potential microphone conflict. Active sessions: " + n6);
                        }
                        return n3;
                    }
                }
                WebRtcAudioRecord webRtcAudioRecord6 = this;
                webRtcAudioRecord6.reportWebRtcAudioRecordInitError("Creation or initialization of audio recorder failed.");
                webRtcAudioRecord6.releaseAudioResources();
                return -1;
            }
            String string = runtimeException2.getMessage();
            WebRtcAudioRecord webRtcAudioRecord7 = this;
            webRtcAudioRecord7.reportWebRtcAudioRecordInitError(string);
            webRtcAudioRecord7.releaseAudioResources();
            return -1;
        }
        this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + n5);
        return -1;
    }

    @CalledByNative
    private boolean startRecording() {
        AudioRecordThread audioRecordThread;
        block2: {
            Logging.d(TAG, "startRecording");
            WebRtcAudioRecord.assertTrue(this.audioRecord != null);
            WebRtcAudioRecord.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioRecord webRtcAudioRecord = this;
                webRtcAudioRecord.audioRecord.startRecording();
                if (webRtcAudioRecord.audioRecord.getRecordingState() == 3) break block2;
            }
            catch (IllegalStateException illegalStateException) {
                this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
                return false;
            }
            this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state: " + this.audioRecord.getRecordingState());
            return false;
        }
        AudioRecordThread audioRecordThread2 = audioRecordThread;
        audioRecordThread2("AudioRecordJavaThread");
        this.audioThread = audioRecordThread2;
        audioRecordThread.start();
        this.scheduleLogRecordingConfigurationsTask();
        return true;
    }

    @CalledByNative
    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        Object object = this.future;
        if (object != null) {
            if (!object.isDone()) {
                this.future.cancel(true);
            }
            this.future = null;
        }
        if ((object = this.executor) != null) {
            object.shutdownNow();
            this.executor = null;
        }
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioRecord.audioThread, 2000L)) {
            WebRtcAudioRecord webRtcAudioRecord2 = this;
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            object = webRtcAudioRecord2.context;
            AudioManager audioManager = webRtcAudioRecord2.audioManager;
            WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        }
        WebRtcAudioRecord webRtcAudioRecord3 = this;
        webRtcAudioRecord3.audioThread = null;
        webRtcAudioRecord3.effects.release();
        webRtcAudioRecord3.releaseAudioResources();
        return true;
    }

    @TargetApi(value=23)
    private static AudioRecord createAudioRecordOnMOrHigher(int n, int n2, int n3, int n4, int n5) {
        Logging.d(TAG, "createAudioRecordOnMOrHigher");
        return new AudioRecord.Builder().setAudioSource(n).setAudioFormat(new AudioFormat.Builder().setEncoding(n4).setSampleRate(n2).setChannelMask(n3).build()).setBufferSizeInBytes(n5).build();
    }

    private static AudioRecord createAudioRecordOnLowerThanM(int n, int n2, int n3, int n4, int n5) {
        Logging.d(TAG, "createAudioRecordOnLowerThanM");
        return new AudioRecord(n, n2, n3, n4, n5);
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    @TargetApi(value=23)
    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    @TargetApi(value=24)
    private int logRecordingConfigurations(boolean bl) {
        if (Build.VERSION.SDK_INT < 24) {
            Logging.w(TAG, "AudioManager#getActiveRecordingConfigurations() requires N or higher");
            return 0;
        }
        if (webRtcAudioRecord3.audioRecord == null) {
            return 0;
        }
        List list = webRtcAudioRecord3.audioManager.getActiveRecordingConfigurations();
        int n = list.size();
        Logging.d(TAG, "Number of active recording sessions: " + n);
        if (n > 0) {
            WebRtcAudioRecord.logActiveRecordingConfigs(webRtcAudioRecord3.audioRecord.getAudioSessionId(), list);
            if (bl) {
                WebRtcAudioRecord webRtcAudioRecord = webRtcAudioRecord3;
                WebRtcAudioRecord webRtcAudioRecord2 = webRtcAudioRecord3;
                WebRtcAudioRecord webRtcAudioRecord3 = webRtcAudioRecord2.audioRecord.getFormat();
                webRtcAudioRecord.audioSourceMatchesRecordingSession = WebRtcAudioRecord.verifyAudioConfig(webRtcAudioRecord.audioRecord.getAudioSource(), webRtcAudioRecord3.audioRecord.getAudioSessionId(), (AudioFormat)webRtcAudioRecord3, webRtcAudioRecord2.audioRecord.getRoutedDevice(), list);
                webRtcAudioRecord.isAudioConfigVerified = true;
            }
        }
        return n;
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n) {
        return n == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeDataIsRecorded(long var1, int var3);

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String string) {
        WebRtcAudioRecord webRtcAudioRecord = object;
        Logging.e(TAG, "Init recording error: " + string);
        Object object = webRtcAudioRecord.context;
        AudioManager audioManager = webRtcAudioRecord.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        webRtcAudioRecord.logRecordingConfigurations(false);
        object = webRtcAudioRecord.errorCallback;
        if (object != null) {
            object.onWebRtcAudioRecordInitError(string);
        }
    }

    private void reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode audioRecordStartErrorCode, String string) {
        WebRtcAudioRecord webRtcAudioRecord = object;
        Logging.e(TAG, "Start recording error: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string);
        Object object = webRtcAudioRecord.context;
        AudioManager audioManager = webRtcAudioRecord.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        webRtcAudioRecord.logRecordingConfigurations(false);
        object = webRtcAudioRecord.errorCallback;
        if (object != null) {
            object.onWebRtcAudioRecordStartError(audioRecordStartErrorCode, string);
        }
    }

    private void reportWebRtcAudioRecordError(String string) {
        WebRtcAudioRecord webRtcAudioRecord = object;
        Logging.e(TAG, "Run-time recording error: " + string);
        Object object = webRtcAudioRecord.context;
        AudioManager audioManager = webRtcAudioRecord.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioRecord.errorCallback;
        if (object != null) {
            object.onWebRtcAudioRecordError(string);
        }
    }

    private void doAudioRecordStateCallback(int n) {
        Logging.d(TAG, "doAudioRecordStateCallback: " + WebRtcAudioRecord.audioStateToString(n));
        JavaAudioDeviceModule.AudioRecordStateCallback audioRecordStateCallback = ((WebRtcAudioRecord)((Object)audioRecordStateCallback)).stateCallback;
        if (audioRecordStateCallback != null) {
            if (n == 0) {
                audioRecordStateCallback.onWebRtcAudioRecordStart();
            } else if (n == 1) {
                audioRecordStateCallback.onWebRtcAudioRecordStop();
            } else {
                Logging.e(TAG, "Invalid audio state");
            }
        }
    }

    private static int getBytesPerSample(int n) {
        if (n != 13) {
            switch (n) {
                default: {
                    throw new IllegalArgumentException("Bad audio format " + n);
                }
                case 4: {
                    return 4;
                }
                case 3: {
                    return 1;
                }
                case 1: 
                case 2: 
            }
        }
        return 2;
    }

    private void scheduleLogRecordingConfigurationsTask() {
        Logging.d(TAG, "scheduleLogRecordingConfigurationsTask");
        if (Build.VERSION.SDK_INT < 24) {
            return;
        }
        Object object = object2.executor;
        if (object != null) {
            object.shutdownNow();
        }
        WebRtcAudioRecord webRtcAudioRecord = object2;
        webRtcAudioRecord.executor = Executors.newSingleThreadScheduledExecutor();
        object = () -> {
            this.logRecordingConfigurations(true);
            return "Scheduled task is done";
        };
        ScheduledFuture<String> scheduledFuture = webRtcAudioRecord.future;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            object2.future.cancel(true);
        }
        WebRtcAudioRecord webRtcAudioRecord2 = object2;
        Object object2 = TimeUnit.MILLISECONDS;
        webRtcAudioRecord2.future = webRtcAudioRecord2.executor.schedule(object, 100L, (TimeUnit)((Object)object2));
    }

    @TargetApi(value=24)
    private static boolean logActiveRecordingConfigs(int n, List<AudioRecordingConfiguration> object) {
        List<AudioRecordingConfiguration> list = object;
        WebRtcAudioRecord.assertTrue(list.isEmpty() ^ true);
        object = list.iterator();
        Logging.d(TAG, "AudioRecordingConfigurations: ");
        while (object.hasNext()) {
            StringBuilder stringBuilder;
            AudioRecordingConfiguration audioRecordingConfiguration = (AudioRecordingConfiguration)object.next();
            AudioRecordingConfiguration audioRecordingConfiguration2 = audioRecordingConfiguration;
            StringBuilder stringBuilder2 = stringBuilder;
            AudioRecordingConfiguration audioRecordingConfiguration3 = audioRecordingConfiguration2;
            stringBuilder2();
            int n2 = audioRecordingConfiguration2.getClientAudioSource();
            stringBuilder2.append("  client audio source=").append(WebRtcAudioUtils.audioSourceToString(n2)).append(", client session id=").append(audioRecordingConfiguration2.getClientAudioSessionId()).append(" (").append(n).append(")").append("\n");
            audioRecordingConfiguration2 = audioRecordingConfiguration2.getFormat();
            stringBuilder2.append("  Device AudioFormat: ").append("channel count=").append(audioRecordingConfiguration2.getChannelCount()).append(", channel index mask=").append(audioRecordingConfiguration2.getChannelIndexMask()).append(", channel mask=").append(WebRtcAudioUtils.channelMaskToString(audioRecordingConfiguration2.getChannelMask())).append(", encoding=").append(WebRtcAudioUtils.audioEncodingToString(audioRecordingConfiguration2.getEncoding())).append(", sample rate=").append(audioRecordingConfiguration2.getSampleRate()).append("\n");
            audioRecordingConfiguration2 = audioRecordingConfiguration3.getClientFormat();
            stringBuilder.append("  Client AudioFormat: ").append("channel count=").append(audioRecordingConfiguration2.getChannelCount()).append(", channel index mask=").append(audioRecordingConfiguration2.getChannelIndexMask()).append(", channel mask=").append(WebRtcAudioUtils.channelMaskToString(audioRecordingConfiguration2.getChannelMask())).append(", encoding=").append(WebRtcAudioUtils.audioEncodingToString(audioRecordingConfiguration2.getEncoding())).append(", sample rate=").append(audioRecordingConfiguration2.getSampleRate()).append("\n");
            audioRecordingConfiguration2 = audioRecordingConfiguration.getAudioDevice();
            if (audioRecordingConfiguration2 != null) {
                WebRtcAudioRecord.assertTrue(audioRecordingConfiguration2.isSource());
                stringBuilder2.append("  AudioDevice: ").append("type=").append(WebRtcAudioUtils.deviceTypeToString(audioRecordingConfiguration2.getType())).append(", id=").append(audioRecordingConfiguration2.getId());
            }
            Logging.d(TAG, stringBuilder2.toString());
        }
        return true;
    }

    @TargetApi(value=24)
    private static boolean verifyAudioConfig(int n, int n2, AudioFormat audioFormat, AudioDeviceInfo audioDeviceInfo, List<AudioRecordingConfiguration> object) {
        List<AudioRecordingConfiguration> list = object;
        WebRtcAudioRecord.assertTrue(list.isEmpty() ^ true);
        for (AudioRecordingConfiguration audioRecordingConfiguration : list) {
            AudioDeviceInfo audioDeviceInfo2 = audioRecordingConfiguration.getAudioDevice();
            if (audioDeviceInfo2 == null || audioRecordingConfiguration.getClientAudioSource() != n || audioRecordingConfiguration.getClientAudioSessionId() != n2 || audioRecordingConfiguration.getClientFormat().getEncoding() != audioFormat.getEncoding() || audioRecordingConfiguration.getClientFormat().getSampleRate() != audioFormat.getSampleRate() || audioRecordingConfiguration.getClientFormat().getChannelMask() != audioFormat.getChannelMask() || audioRecordingConfiguration.getClientFormat().getChannelIndexMask() != audioFormat.getChannelIndexMask() || audioRecordingConfiguration.getFormat().getEncoding() == 0 || audioRecordingConfiguration.getFormat().getSampleRate() <= 0 || audioRecordingConfiguration.getFormat().getChannelMask() == 0 && audioRecordingConfiguration.getFormat().getChannelIndexMask() == 0 || !WebRtcAudioRecord.checkDeviceMatch(audioDeviceInfo2, audioDeviceInfo)) continue;
            Logging.d(TAG, "verifyAudioConfig: PASS");
            return true;
        }
        Logging.e(TAG, "verifyAudioConfig: FAILED");
        return false;
    }

    @TargetApi(value=24)
    private static boolean checkDeviceMatch(AudioDeviceInfo audioDeviceInfo, AudioDeviceInfo audioDeviceInfo2) {
        return audioDeviceInfo.getId() == audioDeviceInfo2.getId() && audioDeviceInfo.getType() == audioDeviceInfo2.getType();
    }

    private static String audioStateToString(int n) {
        if (n != 0) {
            if (n != 1) {
                return "INVALID";
            }
            return "STOP";
        }
        return "START";
    }

    @CalledByNative
    public void setNativeAudioRecord(long l) {
        this.nativeAudioRecord = l;
    }

    @CalledByNative
    boolean isAcousticEchoCancelerSupported() {
        return this.isAcousticEchoCancelerSupported;
    }

    @CalledByNative
    boolean isNoiseSuppressorSupported() {
        return this.isNoiseSuppressorSupported;
    }

    @CalledByNative
    boolean isAudioConfigVerified() {
        return this.isAudioConfigVerified;
    }

    @CalledByNative
    boolean isAudioSourceMatchingRecordingSession() {
        if (!this.isAudioConfigVerified) {
            Logging.w(TAG, "Audio configuration has not yet been verified");
            return false;
        }
        return this.audioSourceMatchesRecordingSession;
    }

    @RequiresApi(value=23)
    @TargetApi(value=23)
    void setPreferredDevice(@Nullable AudioDeviceInfo audioDeviceInfo) {
        String string = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("setPreferredDevice ");
        Integer n = audioDeviceInfo != null ? Integer.valueOf(audioDeviceInfo.getId()) : null;
        Logging.d(string, stringBuilder.append(n).toString());
        webRtcAudioRecord.preferredDevice = audioDeviceInfo;
        WebRtcAudioRecord webRtcAudioRecord = webRtcAudioRecord.audioRecord;
        if (webRtcAudioRecord != null && !webRtcAudioRecord.setPreferredDevice(audioDeviceInfo)) {
            Logging.e(TAG, "setPreferredDevice failed");
        }
    }

    public void setMicrophoneMute(boolean bl) {
        Logging.w(TAG, "setMicrophoneMute(" + bl + ")");
        this.microphoneMute = bl;
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            block7: {
                Process.setThreadPriority((int)-19);
                Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
                WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
                WebRtcAudioRecord.this.doAudioRecordStateCallback(0);
                System.nanoTime();
                while (this.keepAlive) {
                    int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                    if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                        if (WebRtcAudioRecord.this.microphoneMute) {
                            AudioRecordThread audioRecordThread = this;
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.clear();
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                        }
                        if (this.keepAlive) {
                            WebRtcAudioRecord webRtcAudioRecord = WebRtcAudioRecord.this;
                            webRtcAudioRecord.nativeDataIsRecorded(webRtcAudioRecord.nativeAudioRecord, n);
                        }
                        if (WebRtcAudioRecord.this.audioSamplesReadyCallback == null) continue;
                        AudioRecordThread audioRecordThread = this;
                        byte[] byArray = Arrays.copyOfRange(audioRecordThread.WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.arrayOffset(), WebRtcAudioRecord.this.byteBuffer.capacity() + WebRtcAudioRecord.this.byteBuffer.arrayOffset());
                        AudioRecordThread audioRecordThread2 = this;
                        int n2 = audioRecordThread2.WebRtcAudioRecord.this.audioRecord.getChannelCount();
                        audioRecordThread.WebRtcAudioRecord.this.audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(WebRtcAudioRecord.this.audioRecord.getAudioFormat(), n2, audioRecordThread2.WebRtcAudioRecord.this.audioRecord.getSampleRate(), byArray));
                        continue;
                    }
                    String string = "AudioRecord.read failed: " + n;
                    Logging.e(WebRtcAudioRecord.TAG, string);
                    if (n != -3) continue;
                    this.keepAlive = false;
                    WebRtcAudioRecord.this.reportWebRtcAudioRecordError(string);
                }
                if (WebRtcAudioRecord.this.audioRecord == null) break block7;
                try {
                    AudioRecordThread audioRecordThread = this;
                    audioRecordThread.WebRtcAudioRecord.this.audioRecord.stop();
                    audioRecordThread.WebRtcAudioRecord.this.doAudioRecordStateCallback(1);
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + illegalStateException.getMessage());
                }
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }
}

