/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.otwebrtc.GlShader;
import org.otwebrtc.GlTextureFrameBuffer;
import org.otwebrtc.GlUtil;
import org.otwebrtc.ThreadUtils;

class YuvConverter61 {
    private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oesTex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private final GlTextureFrameBuffer textureFrameBuffer;
    private final GlShader shader;
    private final int texMatrixLoc;
    private final int xUnitLoc;
    private final int coeffsLoc;
    private final ThreadUtils.ThreadChecker threadChecker;
    private boolean released;

    public YuvConverter61() {
        ThreadUtils.ThreadChecker threadChecker;
        YuvConverter61 yuvConverter61 = object;
        ThreadUtils.ThreadChecker threadChecker2 = threadChecker;
        YuvConverter61 yuvConverter612 = object;
        ThreadUtils.ThreadChecker threadChecker3 = threadChecker2;
        threadChecker3();
        yuvConverter612.threadChecker = threadChecker3;
        yuvConverter612.released = false;
        threadChecker.checkIsOnValidThread();
        yuvConverter61.textureFrameBuffer = new GlTextureFrameBuffer(6408);
        ((YuvConverter61)object).shader = new GlShader(VERTEX_SHADER, FRAGMENT_SHADER);
        ((YuvConverter61)object).shader.useProgram();
        yuvConverter61.texMatrixLoc = yuvConverter61.shader.getUniformLocation("texMatrix");
        yuvConverter61.xUnitLoc = yuvConverter61.shader.getUniformLocation("xUnit");
        yuvConverter61.coeffsLoc = yuvConverter61.shader.getUniformLocation("coeffs");
        GLES20.glUniform1i((int)yuvConverter61.shader.getUniformLocation("oesTex"), (int)0);
        GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        Object object = DEVICE_RECTANGLE;
        yuvConverter61.shader.setVertexAttribArray("in_pos", 2, (FloatBuffer)object);
        object = TEXTURE_RECTANGLE;
        yuvConverter61.shader.setVertexAttribArray("in_tc", 2, (FloatBuffer)object);
    }

    /*
     * WARNING - void declaration
     */
    public void convert(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, float[] fArray) {
        YuvConverter61 object;
        YuvConverter61 yuvConverter61 = object;
        yuvConverter61.threadChecker.checkIsOnValidThread();
        if (!yuvConverter61.released) {
            void fArray4;
            if (fArray4 % 8 == false) {
                void f2;
                if (fArray4 >= f2) {
                    void var1_3;
                    void var3_6;
                    void v1 = var3_6;
                    void v2 = f2;
                    void var7_13 = (v2 + 3) / 4;
                    void var8_14 = (v2 + 7) / 8;
                    void var9_15 = (v1 + true) / 2;
                    void var10_16 = v1 + var9_15;
                    void var11_17 = fArray4 * var10_16;
                    if (var1_3.capacity() >= var11_17) {
                        void var5_10;
                        void var6_12;
                        YuvConverter61 yuvConverter612 = object;
                        float[] fArray2 = new float[16];
                        float[] fArray3 = new float[16];
                        float[] n12 = fArray3;
                        fArray3[0] = 1.0f;
                        fArray3[1] = 0.0f;
                        fArray3[2] = 0.0f;
                        fArray3[3] = 0.0f;
                        fArray3[4] = 0.0f;
                        fArray3[5] = -1.0f;
                        fArray3[6] = 0.0f;
                        fArray3[7] = 0.0f;
                        fArray3[8] = 0.0f;
                        fArray3[9] = 0.0f;
                        fArray3[10] = 1.0f;
                        fArray3[11] = 0.0f;
                        fArray3[12] = 0.0f;
                        fArray3[13] = 1.0f;
                        fArray3[14] = 0.0f;
                        fArray3[15] = 1.0f;
                        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])var6_12, (int)0, (float[])n12, (int)0);
                        void var4_9 = fArray4 / 4;
                        yuvConverter612.textureFrameBuffer.setSize((int)var4_9, (int)var10_16);
                        GLES20.glBindFramebuffer((int)36160, (int)yuvConverter612.textureFrameBuffer.getFrameBufferId());
                        GlUtil.checkNoGLES2Error("glBindFramebuffer");
                        GLES20.glActiveTexture((int)33984);
                        GLES20.glBindTexture((int)36197, (int)var5_10);
                        GLES20.glUniformMatrix4fv((int)yuvConverter612.texMatrixLoc, (int)1, (boolean)false, (float[])fArray2, (int)0);
                        GLES20.glViewport((int)0, (int)0, (int)var7_13, (int)var3_6);
                        float f3 = (float)f2;
                        float f4 = fArray2[0] / f3;
                        GLES20.glUniform2f((int)yuvConverter612.xUnitLoc, (float)f4, (float)(fArray2[1] / f3));
                        GLES20.glUniform4f((int)yuvConverter612.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
                        GLES20.glDrawArrays((int)5, (int)0, (int)4);
                        GLES20.glViewport((int)0, (int)var3_6, (int)var8_14, (int)var9_15);
                        float f5 = fArray2[0] * 2.0f / f3;
                        GLES20.glUniform2f((int)yuvConverter612.xUnitLoc, (float)f5, (float)(fArray2[1] * 2.0f / f3));
                        GLES20.glUniform4f((int)yuvConverter612.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
                        GLES20.glDrawArrays((int)5, (int)0, (int)4);
                        GLES20.glViewport((int)(fArray4 / 8), (int)var3_6, (int)var8_14, (int)var9_15);
                        GLES20.glUniform4f((int)object.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
                        GLES20.glDrawArrays((int)5, (int)0, (int)4);
                        GLES20.glReadPixels((int)0, (int)0, (int)var4_9, (int)var10_16, (int)6408, (int)5121, (Buffer)var1_3);
                        GlUtil.checkNoGLES2Error("YuvConverter.convert");
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GLES20.glBindTexture((int)3553, (int)0);
                        GLES20.glBindTexture((int)36197, (int)0);
                        return;
                    }
                    throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
                }
                throw new IllegalArgumentException("Invalid stride, must >= width");
            }
            throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
        }
        throw new IllegalStateException("YuvConverter.convert called on released object");
    }

    public void release() {
        YuvConverter61 yuvConverter61 = this;
        yuvConverter61.threadChecker.checkIsOnValidThread();
        yuvConverter61.released = true;
        yuvConverter61.shader.release();
        yuvConverter61.textureFrameBuffer.release();
    }
}

