/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.Matrix;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.otwebrtc.GlGenericDrawer;
import org.otwebrtc.GlShader;
import org.otwebrtc.GlTextureFrameBuffer;
import org.otwebrtc.GlUtil;
import org.otwebrtc.JavaI420Buffer;
import org.otwebrtc.JniCommon;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoFrameDrawer;

public class YuvConverter {
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker;
    private final GlTextureFrameBuffer i420TextureFrameBuffer;
    private final ShaderCallbacks shaderCallbacks;
    private final GlGenericDrawer drawer;
    private final VideoFrameDrawer videoFrameDrawer;

    public YuvConverter() {
        VideoFrameDrawer videoFrameDrawer;
        YuvConverter yuvConverter = videoFrameDrawer2;
        VideoFrameDrawer videoFrameDrawer2 = videoFrameDrawer;
        videoFrameDrawer = new VideoFrameDrawer();
        yuvConverter(videoFrameDrawer2);
    }

    public YuvConverter(VideoFrameDrawer videoFrameDrawer) {
        this.threadChecker = new ThreadUtils.ThreadChecker();
        this.i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
        this.shaderCallbacks = new ShaderCallbacks();
        this.drawer = new GlGenericDrawer(FRAGMENT_SHADER, this.shaderCallbacks);
        this.videoFrameDrawer = videoFrameDrawer;
        this.threadChecker.detachThread();
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer textureBuffer) {
        Matrix matrix;
        ByteBuffer byteBuffer;
        YuvConverter yuvConverter = this;
        yuvConverter.threadChecker.checkIsOnValidThread();
        VideoFrame.TextureBuffer textureBuffer2 = textureBuffer;
        int n = textureBuffer2.getWidth();
        VideoFrame.TextureBuffer textureBuffer3 = (VideoFrame.TextureBuffer)yuvConverter.videoFrameDrawer.prepareBufferForViewportSize(textureBuffer2, n, textureBuffer2.getHeight());
        int n2 = textureBuffer3.getWidth();
        int n3 = textureBuffer3.getHeight();
        int n4 = (n2 + 7) / 8 * 8;
        int n5 = n3;
        int n6 = (n5 + 1) / 2;
        int n7 = n5 + n6;
        ByteBuffer byteBuffer2 = byteBuffer = JniCommon.nativeAllocateByteBuffer(n4 * n7);
        YuvConverter yuvConverter2 = this;
        int n8 = n4 / 4;
        Matrix matrix2 = matrix;
        new Matrix().preTranslate(0.5f, 0.5f);
        matrix2.preScale(1.0f, -1.0f);
        matrix2.preTranslate(-0.5f, -0.5f);
        yuvConverter2.i420TextureFrameBuffer.setSize(n8, n7);
        GLES20.glBindFramebuffer((int)36160, (int)yuvConverter2.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        yuvConverter2.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(yuvConverter2.drawer, textureBuffer3, matrix2, n2, n3, 0, 0, n8, n3);
        yuvConverter2.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(yuvConverter2.drawer, textureBuffer3, matrix2, n2, n3, 0, n3, n8 /= 2, n6);
        yuvConverter2.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(yuvConverter2.drawer, textureBuffer3, matrix2, n2, n3, n8, n3, n8, n6);
        n8 = yuvConverter2.i420TextureFrameBuffer.getWidth();
        int n9 = yuvConverter2.i420TextureFrameBuffer.getHeight();
        GLES20.glReadPixels((int)0, (int)0, (int)n8, (int)n9, (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        n8 = n4 * n3 + 0;
        n9 = n4 / 2;
        int n10 = n8 + n9;
        ByteBuffer byteBuffer3 = byteBuffer;
        ByteBuffer byteBuffer4 = byteBuffer;
        byteBuffer.position(0);
        byteBuffer4.limit(n8);
        ByteBuffer byteBuffer5 = byteBuffer4.slice();
        byteBuffer.position(n8);
        n9 = n4 * (n6 - 1) + n9;
        byteBuffer3.limit(n8 + n9);
        ByteBuffer byteBuffer6 = byteBuffer3.slice();
        byteBuffer.position(n10);
        byteBuffer2.limit(n10 + n9);
        ByteBuffer byteBuffer7 = byteBuffer2.slice();
        textureBuffer3.release();
        Runnable runnable = () -> JniCommon.nativeFreeByteBuffer(byteBuffer);
        return JavaI420Buffer.wrap(n2, n3, byteBuffer5, n4, byteBuffer6, n4, byteBuffer7, n4, runnable);
    }

    public void release() {
        YuvConverter yuvConverter = this;
        yuvConverter.threadChecker.checkIsOnValidThread();
        yuvConverter.drawer.release();
        yuvConverter.i420TextureFrameBuffer.release();
        yuvConverter.videoFrameDrawer.release();
        yuvConverter.threadChecker.detachThread();
    }

    private static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] yCoeffs = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
        private static final float[] uCoeffs = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
        private static final float[] vCoeffs = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        private int xUnitLoc;
        private int coeffsLoc;
        private float[] coeffs;
        private float stepSize;

        private ShaderCallbacks() {
        }

        public void setPlaneY() {
            ShaderCallbacks shaderCallbacks = this;
            shaderCallbacks.coeffs = yCoeffs;
            shaderCallbacks.stepSize = 1.0f;
        }

        public void setPlaneU() {
            ShaderCallbacks shaderCallbacks = this;
            shaderCallbacks.coeffs = uCoeffs;
            shaderCallbacks.stepSize = 2.0f;
        }

        public void setPlaneV() {
            ShaderCallbacks shaderCallbacks = this;
            shaderCallbacks.coeffs = vCoeffs;
            shaderCallbacks.stepSize = 2.0f;
        }

        @Override
        public void onNewShader(GlShader glShader) {
            this.xUnitLoc = glShader.getUniformLocation("xUnit");
            this.coeffsLoc = glShader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader glShader, float[] fArray, int n, int n2, int n3, int n4) {
            ShaderCallbacks shaderCallbacks = this;
            GLES20.glUniform4fv((int)shaderCallbacks.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            float f2 = this.stepSize;
            float f3 = n;
            float f4 = f2 * fArray[0] / f3;
            GLES20.glUniform2f((int)shaderCallbacks.xUnitLoc, (float)f4, (float)(f2 * fArray[1] / f3));
        }
    }
}

