/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.Matrix;
import java.nio.ByteBuffer;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.RefCounted;

public class VideoFrame
implements RefCounted {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;

    @CalledByNative
    public VideoFrame(Buffer buffer, int n, long l) {
        if (buffer != null) {
            if (n % 90 == 0) {
                VideoFrame videoFrame = this;
                videoFrame.buffer = buffer;
                videoFrame.rotation = n;
                videoFrame.timestampNs = l;
                return;
            }
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        throw new IllegalArgumentException("buffer not allowed to be null");
    }

    @CalledByNative
    public Buffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    public int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    public long getTimestampNs() {
        return this.timestampNs;
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    @CalledByNative
    public void release() {
        this.buffer.release();
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        public int getTextureId();

        public Matrix getTransformMatrix();

        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type OES;
            public static final /* enum */ Type RGB;
            private static final /* synthetic */ Type[] $VALUES;
            private final int glTarget;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String string) {
                return Enum.valueOf(Type.class, string);
            }

            private Type(int n2) {
                this.glTarget = n2;
            }

            static {
                Type type;
                OES = new Type(36197);
                Type type2 = type;
                RGB = new Type(3553);
                $VALUES = new Type[]{OES, type2};
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface I420Buffer
    extends Buffer {
        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I420Buffer")
        public int getStrideY();

        @CalledByNative(value="I420Buffer")
        public int getStrideU();

        @CalledByNative(value="I420Buffer")
        public int getStrideV();
    }

    public static interface Buffer
    extends RefCounted {
        @CalledByNative(value="Buffer")
        public int getWidth();

        @CalledByNative(value="Buffer")
        public int getHeight();

        @CalledByNative(value="Buffer")
        public I420Buffer toI420();

        @Override
        @CalledByNative(value="Buffer")
        public void retain();

        @Override
        @CalledByNative(value="Buffer")
        public void release();

        @CalledByNative(value="Buffer")
        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

