/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import org.otwebrtc.RefCounted;

class RefCountDelegate
implements RefCounted {
    private final AtomicInteger refCount;
    @Nullable
    private final Runnable releaseCallback;

    public RefCountDelegate(@Nullable Runnable runnable) {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2 = atomicInteger;
        atomicInteger = new AtomicInteger(1);
        v1.refCount = atomicInteger2;
        v1.releaseCallback = runnable;
    }

    @Override
    public void retain() {
        if (this.refCount.incrementAndGet() >= 2) {
            return;
        }
        throw new IllegalStateException("retain() called on an object with refcount < 1");
    }

    @Override
    public void release() {
        int n = ((RefCountDelegate)this).refCount.decrementAndGet();
        if (n >= 0) {
            if (n == 0 && (this = ((RefCountDelegate)this).releaseCallback) != null) {
                this.run();
            }
            return;
        }
        throw new IllegalStateException("release() called on an object with refcount < 1");
    }

    boolean safeRetain() {
        int n = this.refCount.get();
        while (n != 0) {
            int n2 = n;
            if (this.refCount.weakCompareAndSet(n2, n2 + 1)) {
                return true;
            }
            n = this.refCount.get();
        }
        return false;
    }
}

