/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.CandidatePairChangeEvent;
import org.otwebrtc.CryptoOptions;
import org.otwebrtc.DataChannel;
import org.otwebrtc.IceCandidate;
import org.otwebrtc.MediaConstraints;
import org.otwebrtc.MediaStream;
import org.otwebrtc.MediaStreamTrack;
import org.otwebrtc.NativePeerConnectionFactory;
import org.otwebrtc.RTCStatsCollectorCallback;
import org.otwebrtc.RtcCertificatePem;
import org.otwebrtc.RtpReceiver;
import org.otwebrtc.RtpSender;
import org.otwebrtc.RtpTransceiver;
import org.otwebrtc.SdpObserver;
import org.otwebrtc.SessionDescription;
import org.otwebrtc.StatsObserver;
import org.otwebrtc.TurnCustomizer;

public class PeerConnection {
    private final List<MediaStream> localStreams;
    private final long nativePeerConnection;
    private List<RtpSender> senders;
    private List<RtpReceiver> receivers;
    private List<RtpTransceiver> transceivers;

    public PeerConnection(NativePeerConnectionFactory nativePeerConnectionFactory) {
        this(nativePeerConnectionFactory.createNativePeerConnection());
    }

    PeerConnection(long l) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        Object object = arrayList4;
        arrayList4 = new ArrayList();
        v1.localStreams = object;
        object = arrayList3;
        arrayList3 = new ArrayList();
        v1.senders = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        v1.receivers = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.transceivers = object;
        v1.nativePeerConnection = l;
    }

    public static long createNativePeerConnectionObserver(Observer observer) {
        return PeerConnection.nativeCreatePeerConnectionObserver(observer);
    }

    private native long nativeGetNativePeerConnection();

    private native SessionDescription nativeGetLocalDescription();

    private native SessionDescription nativeGetRemoteDescription();

    private native RtcCertificatePem nativeGetCertificate();

    private native DataChannel nativeCreateDataChannel(String var1, DataChannel.Init var2);

    private native void nativeCreateOffer(SdpObserver var1, MediaConstraints var2);

    private native void nativeCreateAnswer(SdpObserver var1, MediaConstraints var2);

    private native void nativeSetLocalDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetRemoteDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetAudioPlayout(boolean var1);

    private native void nativeSetAudioRecording(boolean var1);

    private native boolean nativeSetBitrate(Integer var1, Integer var2, Integer var3);

    private native SignalingState nativeSignalingState();

    private native IceConnectionState nativeIceConnectionState();

    private native PeerConnectionState nativeConnectionState();

    private native IceGatheringState nativeIceGatheringState();

    private native void nativeClose();

    private static native long nativeCreatePeerConnectionObserver(Observer var0);

    private static native void nativeFreeOwnedPeerConnection(long var0);

    private native boolean nativeSetConfiguration(RTCConfiguration var1);

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeRemoveIceCandidates(IceCandidate[] var1);

    private native boolean nativeAddLocalStream(long var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeOldGetStats(StatsObserver var1, long var2);

    private native void nativeNewGetStats(RTCStatsCollectorCallback var1);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpReceiver> nativeGetReceivers();

    private native List<RtpTransceiver> nativeGetTransceivers();

    private native RtpSender nativeAddTrack(long var1, List<String> var3);

    private native boolean nativeRemoveTrack(long var1);

    private native RtpTransceiver nativeAddTransceiverWithTrack(long var1, RtpTransceiver.RtpTransceiverInit var3);

    private native RtpTransceiver nativeAddTransceiverOfType(MediaStreamTrack.MediaType var1, RtpTransceiver.RtpTransceiverInit var2);

    private native boolean nativeStartRtcEventLog(int var1, int var2);

    private native void nativeStopRtcEventLog();

    public SessionDescription getLocalDescription() {
        return this.nativeGetLocalDescription();
    }

    public SessionDescription getRemoteDescription() {
        return this.nativeGetRemoteDescription();
    }

    public RtcCertificatePem getCertificate() {
        return this.nativeGetCertificate();
    }

    public DataChannel createDataChannel(String string, DataChannel.Init init) {
        return this.nativeCreateDataChannel(string, init);
    }

    public void createOffer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateOffer(sdpObserver, mediaConstraints);
    }

    public void createAnswer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateAnswer(sdpObserver, mediaConstraints);
    }

    public void setLocalDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetLocalDescription(sdpObserver, sessionDescription);
    }

    public void setRemoteDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetRemoteDescription(sdpObserver, sessionDescription);
    }

    public void setAudioPlayout(boolean bl) {
        this.nativeSetAudioPlayout(bl);
    }

    public void setAudioRecording(boolean bl) {
        this.nativeSetAudioRecording(bl);
    }

    public boolean setConfiguration(RTCConfiguration rTCConfiguration) {
        return this.nativeSetConfiguration(rTCConfiguration);
    }

    public boolean addIceCandidate(IceCandidate iceCandidate) {
        PeerConnection peerConnection = string;
        IceCandidate iceCandidate2 = iceCandidate;
        String string = iceCandidate2.sdpMid;
        int n = iceCandidate2.sdpMLineIndex;
        String string2 = iceCandidate2.sdp;
        return peerConnection.nativeAddIceCandidate(string, n, string2);
    }

    public boolean removeIceCandidates(IceCandidate[] iceCandidateArray) {
        return this.nativeRemoveIceCandidates(iceCandidateArray);
    }

    public boolean addStream(MediaStream mediaStream) {
        if (!this.nativeAddLocalStream(mediaStream.getNativeMediaStream())) {
            return false;
        }
        this.localStreams.add(mediaStream);
        return true;
    }

    public void removeStream(MediaStream mediaStream) {
        PeerConnection peerConnection = this;
        peerConnection.nativeRemoveLocalStream(mediaStream.getNativeMediaStream());
        peerConnection.localStreams.remove(mediaStream);
    }

    public RtpSender createSender(String object, String string) {
        if ((object = this.nativeCreateSender((String)object, string)) != null) {
            this.senders.add((RtpSender)object);
        }
        return object;
    }

    public List<RtpSender> getSenders() {
        Iterator<RtpSender> iterator = ((PeerConnection)((Object)list)).senders.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        List<RtpSender> list = ((PeerConnection)((Object)list)).nativeGetSenders();
        v0.senders = list;
        return Collections.unmodifiableList(list);
    }

    public List<RtpReceiver> getReceivers() {
        Iterator<RtpReceiver> iterator = ((PeerConnection)((Object)list)).receivers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        List<RtpReceiver> list = ((PeerConnection)((Object)list)).nativeGetReceivers();
        v0.receivers = list;
        return Collections.unmodifiableList(list);
    }

    public List<RtpTransceiver> getTransceivers() {
        Iterator<RtpTransceiver> iterator = ((PeerConnection)((Object)list)).transceivers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        List<RtpTransceiver> list = ((PeerConnection)((Object)list)).nativeGetTransceivers();
        v0.transceivers = list;
        return Collections.unmodifiableList(list);
    }

    public RtpSender addTrack(MediaStreamTrack mediaStreamTrack) {
        return this.addTrack(mediaStreamTrack, Collections.emptyList());
    }

    public RtpSender addTrack(MediaStreamTrack object, List<String> list) {
        if (object != null && list != null) {
            if ((object = this.nativeAddTrack(((MediaStreamTrack)object).getNativeMediaStreamTrack(), list)) != null) {
                this.senders.add((RtpSender)object);
                return object;
            }
            throw new IllegalStateException("C++ addTrack failed.");
        }
        throw new NullPointerException("No MediaStreamTrack specified in addTrack.");
    }

    public boolean removeTrack(RtpSender rtpSender) {
        if (rtpSender != null) {
            return this.nativeRemoveTrack(rtpSender.getNativeRtpSender());
        }
        throw new NullPointerException("No RtpSender specified for removeTrack.");
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack mediaStreamTrack) {
        RtpTransceiver.RtpTransceiverInit rtpTransceiverInit;
        PeerConnection peerConnection = rtpTransceiverInit2;
        RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2 = rtpTransceiverInit;
        rtpTransceiverInit = new RtpTransceiver.RtpTransceiverInit();
        return peerConnection.addTransceiver(mediaStreamTrack, rtpTransceiverInit2);
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack object, @Nullable RtpTransceiver.RtpTransceiverInit rtpTransceiverInit) {
        if (object != null) {
            if (rtpTransceiverInit == null) {
                RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2;
                rtpTransceiverInit = rtpTransceiverInit2;
                rtpTransceiverInit2 = new RtpTransceiver.RtpTransceiverInit();
            }
            if ((object = this.nativeAddTransceiverWithTrack(((MediaStreamTrack)object).getNativeMediaStreamTrack(), rtpTransceiverInit)) != null) {
                this.transceivers.add((RtpTransceiver)object);
                return object;
            }
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        throw new NullPointerException("No MediaStreamTrack specified for addTransceiver.");
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType mediaType) {
        RtpTransceiver.RtpTransceiverInit rtpTransceiverInit;
        PeerConnection peerConnection = rtpTransceiverInit2;
        RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2 = rtpTransceiverInit;
        rtpTransceiverInit = new RtpTransceiver.RtpTransceiverInit();
        return peerConnection.addTransceiver(mediaType, rtpTransceiverInit2);
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType object, @Nullable RtpTransceiver.RtpTransceiverInit rtpTransceiverInit) {
        if (object != null) {
            if (rtpTransceiverInit == null) {
                RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2;
                rtpTransceiverInit = rtpTransceiverInit2;
                rtpTransceiverInit2 = new RtpTransceiver.RtpTransceiverInit();
            }
            if ((object = this.nativeAddTransceiverOfType((MediaStreamTrack.MediaType)((Object)object), rtpTransceiverInit)) != null) {
                this.transceivers.add((RtpTransceiver)object);
                return object;
            }
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        throw new NullPointerException("No MediaType specified for addTransceiver.");
    }

    @Deprecated
    public boolean getStats(StatsObserver statsObserver, @Nullable MediaStreamTrack mediaStreamTrack) {
        long l = mediaStreamTrack == null ? 0L : mediaStreamTrack.getNativeMediaStreamTrack();
        return this.nativeOldGetStats(statsObserver, l);
    }

    public void getStats(RTCStatsCollectorCallback rTCStatsCollectorCallback) {
        this.nativeNewGetStats(rTCStatsCollectorCallback);
    }

    public boolean setBitrate(Integer n, Integer n2, Integer n3) {
        return this.nativeSetBitrate(n, n2, n3);
    }

    public boolean startRtcEventLog(int n, int n2) {
        return this.nativeStartRtcEventLog(n, n2);
    }

    public void stopRtcEventLog() {
        this.nativeStopRtcEventLog();
    }

    public SignalingState signalingState() {
        return this.nativeSignalingState();
    }

    public IceConnectionState iceConnectionState() {
        return this.nativeIceConnectionState();
    }

    public PeerConnectionState connectionState() {
        return this.nativeConnectionState();
    }

    public IceGatheringState iceGatheringState() {
        return this.nativeIceGatheringState();
    }

    public void close() {
        this.nativeClose();
    }

    public void dispose() {
        PeerConnection peerConnection = this;
        peerConnection.close();
        for (MediaStream mediaStream : peerConnection.localStreams) {
            this.nativeRemoveLocalStream(mediaStream.getNativeMediaStream());
            mediaStream.dispose();
        }
        PeerConnection peerConnection2 = this;
        peerConnection2.localStreams.clear();
        Iterator<Object> iterator = peerConnection2.senders.iterator();
        while (iterator.hasNext()) {
            ((RtpSender)iterator.next()).dispose();
        }
        PeerConnection peerConnection3 = this;
        peerConnection3.senders.clear();
        iterator = peerConnection3.receivers.iterator();
        while (iterator.hasNext()) {
            ((RtpReceiver)iterator.next()).dispose();
        }
        iterator = this.transceivers.iterator();
        while (iterator.hasNext()) {
            ((RtpTransceiver)iterator.next()).dispose();
        }
        PeerConnection peerConnection4 = this;
        peerConnection4.transceivers.clear();
        peerConnection4.receivers.clear();
        PeerConnection.nativeFreeOwnedPeerConnection(peerConnection4.nativePeerConnection);
    }

    public long getNativePeerConnection() {
        return this.nativeGetNativePeerConnection();
    }

    @CalledByNative
    long getNativeOwnedPeerConnection() {
        return this.nativePeerConnection;
    }

    public static class RTCConfiguration {
        public IceTransportsType iceTransportsType;
        public List<IceServer> iceServers;
        public BundlePolicy bundlePolicy;
        @Nullable
        public RtcCertificatePem certificate;
        public RtcpMuxPolicy rtcpMuxPolicy;
        public TcpCandidatePolicy tcpCandidatePolicy;
        public CandidateNetworkPolicy candidateNetworkPolicy;
        public int audioJitterBufferMaxPackets;
        public boolean audioJitterBufferFastAccelerate;
        public int iceConnectionReceivingTimeout;
        public int iceBackupCandidatePairPingInterval;
        public KeyType keyType;
        public ContinualGatheringPolicy continualGatheringPolicy;
        public int iceCandidatePoolSize;
        @Deprecated
        public boolean pruneTurnPorts;
        public PortPrunePolicy turnPortPrunePolicy;
        public boolean presumeWritableWhenFullyRelayed;
        public boolean surfaceIceCandidatesOnIceTransportTypeChanged;
        @Nullable
        public Integer iceCheckIntervalStrongConnectivityMs;
        @Nullable
        public Integer iceCheckIntervalWeakConnectivityMs;
        @Nullable
        public Integer iceCheckMinInterval;
        @Nullable
        public Integer iceUnwritableTimeMs;
        @Nullable
        public Integer iceUnwritableMinChecks;
        @Nullable
        public Integer stunCandidateKeepaliveIntervalMs;
        public boolean disableIPv6OnWifi;
        public int maxIPv6Networks;
        public boolean disableIpv6;
        public boolean enableDscp;
        public boolean enableCpuOveruseDetection;
        public boolean enableRtpDataChannel;
        public boolean suspendBelowMinBitrate;
        @Nullable
        public Integer screencastMinBitrate;
        @Nullable
        public Boolean combinedAudioVideoBwe;
        @Nullable
        public Boolean enableDtlsSrtp;
        public AdapterType networkPreference;
        public SdpSemantics sdpSemantics;
        @Nullable
        public TurnCustomizer turnCustomizer;
        public boolean activeResetSrtpParams;
        @Nullable
        public Boolean allowCodecSwitching;
        public boolean useMediaTransport;
        public boolean useMediaTransportForDataChannels;
        @Nullable
        public CryptoOptions cryptoOptions;
        @Nullable
        public String turnLoggingId;

        public RTCConfiguration(List<IceServer> list) {
            RTCConfiguration rTCConfiguration = this;
            this.iceTransportsType = IceTransportsType.ALL;
            this.bundlePolicy = BundlePolicy.BALANCED;
            this.rtcpMuxPolicy = RtcpMuxPolicy.REQUIRE;
            this.tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
            this.candidateNetworkPolicy = CandidateNetworkPolicy.ALL;
            rTCConfiguration.iceServers = list;
            rTCConfiguration.audioJitterBufferMaxPackets = 50;
            rTCConfiguration.audioJitterBufferFastAccelerate = false;
            rTCConfiguration.iceConnectionReceivingTimeout = -1;
            rTCConfiguration.iceBackupCandidatePairPingInterval = -1;
            rTCConfiguration.keyType = KeyType.ECDSA;
            rTCConfiguration.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
            rTCConfiguration.iceCandidatePoolSize = 0;
            rTCConfiguration.pruneTurnPorts = false;
            rTCConfiguration.turnPortPrunePolicy = PortPrunePolicy.NO_PRUNE;
            rTCConfiguration.presumeWritableWhenFullyRelayed = false;
            rTCConfiguration.surfaceIceCandidatesOnIceTransportTypeChanged = false;
            rTCConfiguration.iceCheckIntervalStrongConnectivityMs = null;
            rTCConfiguration.iceCheckIntervalWeakConnectivityMs = null;
            rTCConfiguration.iceCheckMinInterval = null;
            rTCConfiguration.iceUnwritableTimeMs = null;
            rTCConfiguration.iceUnwritableMinChecks = null;
            rTCConfiguration.stunCandidateKeepaliveIntervalMs = null;
            rTCConfiguration.disableIPv6OnWifi = false;
            rTCConfiguration.maxIPv6Networks = 5;
            rTCConfiguration.disableIpv6 = false;
            rTCConfiguration.enableDscp = false;
            rTCConfiguration.enableCpuOveruseDetection = true;
            rTCConfiguration.enableRtpDataChannel = false;
            rTCConfiguration.suspendBelowMinBitrate = false;
            rTCConfiguration.screencastMinBitrate = null;
            rTCConfiguration.combinedAudioVideoBwe = null;
            rTCConfiguration.enableDtlsSrtp = null;
            rTCConfiguration.networkPreference = AdapterType.UNKNOWN;
            rTCConfiguration.sdpSemantics = SdpSemantics.PLAN_B;
            rTCConfiguration.activeResetSrtpParams = false;
            rTCConfiguration.useMediaTransport = false;
            rTCConfiguration.useMediaTransportForDataChannels = false;
            rTCConfiguration.cryptoOptions = null;
            rTCConfiguration.turnLoggingId = null;
            rTCConfiguration.allowCodecSwitching = null;
        }

        @CalledByNative(value="RTCConfiguration")
        IceTransportsType getIceTransportsType() {
            return this.iceTransportsType;
        }

        @CalledByNative(value="RTCConfiguration")
        List<IceServer> getIceServers() {
            return this.iceServers;
        }

        @CalledByNative(value="RTCConfiguration")
        BundlePolicy getBundlePolicy() {
            return this.bundlePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        PortPrunePolicy getTurnPortPrunePolicy() {
            return this.turnPortPrunePolicy;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        RtcCertificatePem getCertificate() {
            return this.certificate;
        }

        @CalledByNative(value="RTCConfiguration")
        RtcpMuxPolicy getRtcpMuxPolicy() {
            return this.rtcpMuxPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        TcpCandidatePolicy getTcpCandidatePolicy() {
            return this.tcpCandidatePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        CandidateNetworkPolicy getCandidateNetworkPolicy() {
            return this.candidateNetworkPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        int getAudioJitterBufferMaxPackets() {
            return this.audioJitterBufferMaxPackets;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getAudioJitterBufferFastAccelerate() {
            return this.audioJitterBufferFastAccelerate;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceConnectionReceivingTimeout() {
            return this.iceConnectionReceivingTimeout;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceBackupCandidatePairPingInterval() {
            return this.iceBackupCandidatePairPingInterval;
        }

        @CalledByNative(value="RTCConfiguration")
        KeyType getKeyType() {
            return this.keyType;
        }

        @CalledByNative(value="RTCConfiguration")
        ContinualGatheringPolicy getContinualGatheringPolicy() {
            return this.continualGatheringPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceCandidatePoolSize() {
            return this.iceCandidatePoolSize;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPruneTurnPorts() {
            return this.pruneTurnPorts;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPresumeWritableWhenFullyRelayed() {
            return this.presumeWritableWhenFullyRelayed;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getSurfaceIceCandidatesOnIceTransportTypeChanged() {
            return this.surfaceIceCandidatesOnIceTransportTypeChanged;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckIntervalStrongConnectivity() {
            return this.iceCheckIntervalStrongConnectivityMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckIntervalWeakConnectivity() {
            return this.iceCheckIntervalWeakConnectivityMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckMinInterval() {
            return this.iceCheckMinInterval;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceUnwritableTimeout() {
            return this.iceUnwritableTimeMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceUnwritableMinChecks() {
            return this.iceUnwritableMinChecks;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getStunCandidateKeepaliveInterval() {
            return this.stunCandidateKeepaliveIntervalMs;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIPv6OnWifi() {
            return this.disableIPv6OnWifi;
        }

        @CalledByNative(value="RTCConfiguration")
        int getMaxIPv6Networks() {
            return this.maxIPv6Networks;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        TurnCustomizer getTurnCustomizer() {
            return this.turnCustomizer;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIpv6() {
            return this.disableIpv6;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableDscp() {
            return this.enableDscp;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableCpuOveruseDetection() {
            return this.enableCpuOveruseDetection;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableRtpDataChannel() {
            return this.enableRtpDataChannel;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getSuspendBelowMinBitrate() {
            return this.suspendBelowMinBitrate;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getScreencastMinBitrate() {
            return this.screencastMinBitrate;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Boolean getCombinedAudioVideoBwe() {
            return this.combinedAudioVideoBwe;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Boolean getEnableDtlsSrtp() {
            return this.enableDtlsSrtp;
        }

        @CalledByNative(value="RTCConfiguration")
        AdapterType getNetworkPreference() {
            return this.networkPreference;
        }

        @CalledByNative(value="RTCConfiguration")
        SdpSemantics getSdpSemantics() {
            return this.sdpSemantics;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getActiveResetSrtpParams() {
            return this.activeResetSrtpParams;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Boolean getAllowCodecSwitching() {
            return this.allowCodecSwitching;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getUseMediaTransport() {
            return this.useMediaTransport;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getUseMediaTransportForDataChannels() {
            return this.useMediaTransportForDataChannels;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        CryptoOptions getCryptoOptions() {
            return this.cryptoOptions;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        String getTurnLoggingId() {
            return this.turnLoggingId;
        }
    }

    public static final class SdpSemantics
    extends Enum<SdpSemantics> {
        public static final /* enum */ SdpSemantics PLAN_B;
        public static final /* enum */ SdpSemantics UNIFIED_PLAN;
        private static final /* synthetic */ SdpSemantics[] $VALUES;

        public static SdpSemantics[] values() {
            return (SdpSemantics[])$VALUES.clone();
        }

        public static SdpSemantics valueOf(String string) {
            return Enum.valueOf(SdpSemantics.class, string);
        }

        static {
            SdpSemantics sdpSemantics;
            PLAN_B = new SdpSemantics();
            SdpSemantics sdpSemantics2 = sdpSemantics;
            UNIFIED_PLAN = new SdpSemantics();
            $VALUES = new SdpSemantics[]{PLAN_B, sdpSemantics2};
        }
    }

    public static final class PortPrunePolicy
    extends Enum<PortPrunePolicy> {
        public static final /* enum */ PortPrunePolicy NO_PRUNE;
        public static final /* enum */ PortPrunePolicy PRUNE_BASED_ON_PRIORITY;
        public static final /* enum */ PortPrunePolicy KEEP_FIRST_READY;
        private static final /* synthetic */ PortPrunePolicy[] $VALUES;

        public static PortPrunePolicy[] values() {
            return (PortPrunePolicy[])$VALUES.clone();
        }

        public static PortPrunePolicy valueOf(String string) {
            return Enum.valueOf(PortPrunePolicy.class, string);
        }

        static {
            PortPrunePolicy portPrunePolicy;
            NO_PRUNE = new PortPrunePolicy();
            PRUNE_BASED_ON_PRIORITY = new PortPrunePolicy();
            PortPrunePolicy portPrunePolicy2 = portPrunePolicy;
            KEEP_FIRST_READY = new PortPrunePolicy();
            $VALUES = new PortPrunePolicy[]{NO_PRUNE, PRUNE_BASED_ON_PRIORITY, portPrunePolicy2};
        }
    }

    public static final class ContinualGatheringPolicy
    extends Enum<ContinualGatheringPolicy> {
        public static final /* enum */ ContinualGatheringPolicy GATHER_ONCE;
        public static final /* enum */ ContinualGatheringPolicy GATHER_CONTINUALLY;
        private static final /* synthetic */ ContinualGatheringPolicy[] $VALUES;

        public static ContinualGatheringPolicy[] values() {
            return (ContinualGatheringPolicy[])$VALUES.clone();
        }

        public static ContinualGatheringPolicy valueOf(String string) {
            return Enum.valueOf(ContinualGatheringPolicy.class, string);
        }

        static {
            ContinualGatheringPolicy continualGatheringPolicy;
            GATHER_ONCE = new ContinualGatheringPolicy();
            ContinualGatheringPolicy continualGatheringPolicy2 = continualGatheringPolicy;
            GATHER_CONTINUALLY = new ContinualGatheringPolicy();
            $VALUES = new ContinualGatheringPolicy[]{GATHER_ONCE, continualGatheringPolicy2};
        }
    }

    public static final class KeyType
    extends Enum<KeyType> {
        public static final /* enum */ KeyType RSA;
        public static final /* enum */ KeyType ECDSA;
        private static final /* synthetic */ KeyType[] $VALUES;

        public static KeyType[] values() {
            return (KeyType[])$VALUES.clone();
        }

        public static KeyType valueOf(String string) {
            return Enum.valueOf(KeyType.class, string);
        }

        static {
            KeyType keyType;
            RSA = new KeyType();
            KeyType keyType2 = keyType;
            ECDSA = new KeyType();
            $VALUES = new KeyType[]{RSA, keyType2};
        }
    }

    public static final class AdapterType
    extends Enum<AdapterType> {
        public static final /* enum */ AdapterType UNKNOWN;
        public static final /* enum */ AdapterType ETHERNET;
        public static final /* enum */ AdapterType WIFI;
        public static final /* enum */ AdapterType CELLULAR;
        public static final /* enum */ AdapterType VPN;
        public static final /* enum */ AdapterType LOOPBACK;
        public static final /* enum */ AdapterType ADAPTER_TYPE_ANY;
        public static final /* enum */ AdapterType CELLULAR_2G;
        public static final /* enum */ AdapterType CELLULAR_3G;
        public static final /* enum */ AdapterType CELLULAR_4G;
        public static final /* enum */ AdapterType CELLULAR_5G;
        private static final Map<Integer, AdapterType> BY_BITMASK;
        private static final /* synthetic */ AdapterType[] $VALUES;
        public final Integer bitMask;

        public static AdapterType[] values() {
            return (AdapterType[])$VALUES.clone();
        }

        public static AdapterType valueOf(String string) {
            return Enum.valueOf(AdapterType.class, string);
        }

        private AdapterType(Integer n2) {
            this.bitMask = n2;
        }

        @Nullable
        @CalledByNative(value="AdapterType")
        static AdapterType fromNativeIndex(int n) {
            return BY_BITMASK.get(n);
        }

        static {
            AdapterType adapterType;
            AdapterType[] adapterTypeArray = 0;
            UNKNOWN = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 1;
            ETHERNET = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 2;
            WIFI = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 4;
            CELLULAR = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 8;
            VPN = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 16;
            LOOPBACK = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 32;
            ADAPTER_TYPE_ANY = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 64;
            CELLULAR_2G = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 128;
            CELLULAR_3G = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = 256;
            CELLULAR_4G = new AdapterType((Integer)adapterTypeArray);
            adapterTypeArray = adapterType;
            Integer n = 512;
            CELLULAR_5G = new AdapterType(n);
            $VALUES = new AdapterType[]{UNKNOWN, ETHERNET, WIFI, CELLULAR, VPN, LOOPBACK, ADAPTER_TYPE_ANY, CELLULAR_2G, CELLULAR_3G, CELLULAR_4G, adapterTypeArray};
            BY_BITMASK = new HashMap<Integer, AdapterType>();
            for (AdapterType adapterType2 : AdapterType.values()) {
                BY_BITMASK.put(adapterType2.bitMask, adapterType2);
            }
        }
    }

    public static final class CandidateNetworkPolicy
    extends Enum<CandidateNetworkPolicy> {
        public static final /* enum */ CandidateNetworkPolicy ALL;
        public static final /* enum */ CandidateNetworkPolicy LOW_COST;
        private static final /* synthetic */ CandidateNetworkPolicy[] $VALUES;

        public static CandidateNetworkPolicy[] values() {
            return (CandidateNetworkPolicy[])$VALUES.clone();
        }

        public static CandidateNetworkPolicy valueOf(String string) {
            return Enum.valueOf(CandidateNetworkPolicy.class, string);
        }

        static {
            CandidateNetworkPolicy candidateNetworkPolicy;
            ALL = new CandidateNetworkPolicy();
            CandidateNetworkPolicy candidateNetworkPolicy2 = candidateNetworkPolicy;
            LOW_COST = new CandidateNetworkPolicy();
            $VALUES = new CandidateNetworkPolicy[]{ALL, candidateNetworkPolicy2};
        }
    }

    public static final class TcpCandidatePolicy
    extends Enum<TcpCandidatePolicy> {
        public static final /* enum */ TcpCandidatePolicy ENABLED;
        public static final /* enum */ TcpCandidatePolicy DISABLED;
        private static final /* synthetic */ TcpCandidatePolicy[] $VALUES;

        public static TcpCandidatePolicy[] values() {
            return (TcpCandidatePolicy[])$VALUES.clone();
        }

        public static TcpCandidatePolicy valueOf(String string) {
            return Enum.valueOf(TcpCandidatePolicy.class, string);
        }

        static {
            TcpCandidatePolicy tcpCandidatePolicy;
            ENABLED = new TcpCandidatePolicy();
            TcpCandidatePolicy tcpCandidatePolicy2 = tcpCandidatePolicy;
            DISABLED = new TcpCandidatePolicy();
            $VALUES = new TcpCandidatePolicy[]{ENABLED, tcpCandidatePolicy2};
        }
    }

    public static final class RtcpMuxPolicy
    extends Enum<RtcpMuxPolicy> {
        public static final /* enum */ RtcpMuxPolicy NEGOTIATE;
        public static final /* enum */ RtcpMuxPolicy REQUIRE;
        private static final /* synthetic */ RtcpMuxPolicy[] $VALUES;

        public static RtcpMuxPolicy[] values() {
            return (RtcpMuxPolicy[])$VALUES.clone();
        }

        public static RtcpMuxPolicy valueOf(String string) {
            return Enum.valueOf(RtcpMuxPolicy.class, string);
        }

        static {
            RtcpMuxPolicy rtcpMuxPolicy;
            NEGOTIATE = new RtcpMuxPolicy();
            RtcpMuxPolicy rtcpMuxPolicy2 = rtcpMuxPolicy;
            REQUIRE = new RtcpMuxPolicy();
            $VALUES = new RtcpMuxPolicy[]{NEGOTIATE, rtcpMuxPolicy2};
        }
    }

    public static final class BundlePolicy
    extends Enum<BundlePolicy> {
        public static final /* enum */ BundlePolicy BALANCED;
        public static final /* enum */ BundlePolicy MAXBUNDLE;
        public static final /* enum */ BundlePolicy MAXCOMPAT;
        private static final /* synthetic */ BundlePolicy[] $VALUES;

        public static BundlePolicy[] values() {
            return (BundlePolicy[])$VALUES.clone();
        }

        public static BundlePolicy valueOf(String string) {
            return Enum.valueOf(BundlePolicy.class, string);
        }

        static {
            BundlePolicy bundlePolicy;
            BALANCED = new BundlePolicy();
            MAXBUNDLE = new BundlePolicy();
            BundlePolicy bundlePolicy2 = bundlePolicy;
            MAXCOMPAT = new BundlePolicy();
            $VALUES = new BundlePolicy[]{BALANCED, MAXBUNDLE, bundlePolicy2};
        }
    }

    public static final class IceTransportsType
    extends Enum<IceTransportsType> {
        public static final /* enum */ IceTransportsType NONE;
        public static final /* enum */ IceTransportsType RELAY;
        public static final /* enum */ IceTransportsType NOHOST;
        public static final /* enum */ IceTransportsType ALL;
        private static final /* synthetic */ IceTransportsType[] $VALUES;

        public static IceTransportsType[] values() {
            return (IceTransportsType[])$VALUES.clone();
        }

        public static IceTransportsType valueOf(String string) {
            return Enum.valueOf(IceTransportsType.class, string);
        }

        static {
            IceTransportsType iceTransportsType;
            NONE = new IceTransportsType();
            RELAY = new IceTransportsType();
            NOHOST = new IceTransportsType();
            IceTransportsType iceTransportsType2 = iceTransportsType;
            ALL = new IceTransportsType();
            $VALUES = new IceTransportsType[]{NONE, RELAY, NOHOST, iceTransportsType2};
        }
    }

    public static class IceServer {
        @Deprecated
        public final String uri;
        public final List<String> urls;
        public final String username;
        public final String password;
        public final TlsCertPolicy tlsCertPolicy;
        public final String hostname;
        public final List<String> tlsAlpnProtocols;
        public final List<String> tlsEllipticCurves;

        @Deprecated
        public IceServer(String string) {
            this(string, "", "");
        }

        @Deprecated
        public IceServer(String string, String string2, String string3) {
            IceServer iceServer = object;
            Object object = TlsCertPolicy.TLS_CERT_POLICY_SECURE;
            iceServer(string, string2, string3, (TlsCertPolicy)((Object)object));
        }

        @Deprecated
        public IceServer(String string, String string2, String string3, TlsCertPolicy tlsCertPolicy) {
            this(string, string2, string3, tlsCertPolicy, "");
        }

        @Deprecated
        public IceServer(String string, String string2, String string3, TlsCertPolicy tlsCertPolicy, String string4) {
            this(string, Collections.singletonList(string), string2, string3, tlsCertPolicy, string4, null, null);
        }

        private IceServer(String string, List<String> list, String string2, String string3, TlsCertPolicy tlsCertPolicy, String string4, List<String> list2, List<String> list3) {
            if (string != null && list != null && !list.isEmpty()) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    throw new IllegalArgumentException("urls element is null: " + list);
                }
                if (string2 != null) {
                    if (string3 != null) {
                        if (string4 != null) {
                            IceServer iceServer = this;
                            iceServer.uri = string;
                            iceServer.urls = list;
                            iceServer.username = string2;
                            iceServer.password = string3;
                            iceServer.tlsCertPolicy = tlsCertPolicy;
                            iceServer.hostname = string4;
                            iceServer.tlsAlpnProtocols = list2;
                            iceServer.tlsEllipticCurves = list3;
                            return;
                        }
                        throw new IllegalArgumentException("hostname == null");
                    }
                    throw new IllegalArgumentException("password == null");
                }
                throw new IllegalArgumentException("username == null");
            }
            throw new IllegalArgumentException("uri == null || urls == null || urls.isEmpty()");
        }

        public static Builder builder(String string) {
            return new Builder(Collections.singletonList(string));
        }

        public static Builder builder(List<String> list) {
            return new Builder(list);
        }

        public String toString() {
            return this.urls + " [" + this.username + ":" + this.password + "] [" + (Object)((Object)this.tlsCertPolicy) + "] [" + this.hostname + "] [" + this.tlsAlpnProtocols + "] [" + this.tlsEllipticCurves + "]";
        }

        public boolean equals(@Nullable Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof IceServer)) {
                return false;
            }
            object = (IceServer)object;
            return this.uri.equals(((IceServer)object).uri) && this.urls.equals(((IceServer)object).urls) && this.username.equals(((IceServer)object).username) && this.password.equals(((IceServer)object).password) && this.tlsCertPolicy.equals((Object)((IceServer)object).tlsCertPolicy) && this.hostname.equals(((IceServer)object).hostname) && this.tlsAlpnProtocols.equals(((IceServer)object).tlsAlpnProtocols) && this.tlsEllipticCurves.equals(((IceServer)object).tlsEllipticCurves);
        }

        public int hashCode() {
            Object[] objectArray = new Object[8];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.uri;
            objectArray2[1] = this.urls;
            objectArray2[2] = this.username;
            objectArray2[3] = this.password;
            objectArray2[4] = this.tlsCertPolicy;
            objectArray2[5] = this.hostname;
            objectArray2[6] = this.tlsAlpnProtocols;
            objectArray[7] = this.tlsEllipticCurves;
            return Arrays.hashCode(objectArray);
        }

        @Nullable
        @CalledByNative(value="IceServer")
        List<String> getUrls() {
            return this.urls;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        String getUsername() {
            return this.username;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        String getPassword() {
            return this.password;
        }

        @CalledByNative(value="IceServer")
        TlsCertPolicy getTlsCertPolicy() {
            return this.tlsCertPolicy;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        String getHostname() {
            return this.hostname;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsAlpnProtocols() {
            return this.tlsAlpnProtocols;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsEllipticCurves() {
            return this.tlsEllipticCurves;
        }

        public static class Builder {
            @Nullable
            private final List<String> urls;
            private String username = "";
            private String password = "";
            private TlsCertPolicy tlsCertPolicy = TlsCertPolicy.TLS_CERT_POLICY_SECURE;
            private String hostname = "";
            private List<String> tlsAlpnProtocols;
            private List<String> tlsEllipticCurves;

            private Builder(List<String> list) {
                if (list != null && !list.isEmpty()) {
                    this.urls = list;
                    return;
                }
                throw new IllegalArgumentException("urls == null || urls.isEmpty(): " + list);
            }

            public Builder setUsername(String string) {
                this.username = string;
                return this;
            }

            public Builder setPassword(String string) {
                this.password = string;
                return this;
            }

            public Builder setTlsCertPolicy(TlsCertPolicy tlsCertPolicy) {
                this.tlsCertPolicy = tlsCertPolicy;
                return this;
            }

            public Builder setHostname(String string) {
                this.hostname = string;
                return this;
            }

            public Builder setTlsAlpnProtocols(List<String> list) {
                this.tlsAlpnProtocols = list;
                return this;
            }

            public Builder setTlsEllipticCurves(List<String> list) {
                this.tlsEllipticCurves = list;
                return this;
            }

            public IceServer createIceServer() {
                Builder builder = string;
                String string = builder.urls.get(0);
                List<String> list = builder.urls;
                String string2 = builder.username;
                String string3 = builder.password;
                TlsCertPolicy tlsCertPolicy = builder.tlsCertPolicy;
                String string4 = builder.hostname;
                List<String> list2 = builder.tlsAlpnProtocols;
                List<String> list3 = builder.tlsEllipticCurves;
                return new IceServer(string, list, string2, string3, tlsCertPolicy, string4, list2, list3);
            }
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onSignalingChange(SignalingState var1);

        @CalledByNative(value="Observer")
        public void onIceConnectionChange(IceConnectionState var1);

        @CalledByNative(value="Observer")
        default public void onStandardizedIceConnectionChange(IceConnectionState iceConnectionState) {
        }

        @CalledByNative(value="Observer")
        default public void onConnectionChange(PeerConnectionState peerConnectionState) {
        }

        @CalledByNative(value="Observer")
        public void onIceConnectionReceivingChange(boolean var1);

        @CalledByNative(value="Observer")
        public void onIceGatheringChange(IceGatheringState var1);

        @CalledByNative(value="Observer")
        public void onIceCandidate(IceCandidate var1);

        @CalledByNative(value="Observer")
        public void onIceCandidatesRemoved(IceCandidate[] var1);

        @CalledByNative(value="Observer")
        default public void onSelectedCandidatePairChanged(CandidatePairChangeEvent candidatePairChangeEvent) {
        }

        @CalledByNative(value="Observer")
        public void onAddStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onRemoveStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onDataChannel(DataChannel var1);

        @CalledByNative(value="Observer")
        public void onRenegotiationNeeded();

        @CalledByNative(value="Observer")
        public void onAddTrack(RtpReceiver var1, MediaStream[] var2);

        @CalledByNative(value="Observer")
        default public void onTrack(RtpTransceiver rtpTransceiver) {
        }
    }

    public static final class SignalingState
    extends Enum<SignalingState> {
        public static final /* enum */ SignalingState STABLE;
        public static final /* enum */ SignalingState HAVE_LOCAL_OFFER;
        public static final /* enum */ SignalingState HAVE_LOCAL_PRANSWER;
        public static final /* enum */ SignalingState HAVE_REMOTE_OFFER;
        public static final /* enum */ SignalingState HAVE_REMOTE_PRANSWER;
        public static final /* enum */ SignalingState CLOSED;
        private static final /* synthetic */ SignalingState[] $VALUES;

        public static SignalingState[] values() {
            return (SignalingState[])$VALUES.clone();
        }

        public static SignalingState valueOf(String string) {
            return Enum.valueOf(SignalingState.class, string);
        }

        @CalledByNative(value="SignalingState")
        static SignalingState fromNativeIndex(int n) {
            return SignalingState.values()[n];
        }

        static {
            SignalingState signalingState;
            STABLE = new SignalingState();
            HAVE_LOCAL_OFFER = new SignalingState();
            HAVE_LOCAL_PRANSWER = new SignalingState();
            HAVE_REMOTE_OFFER = new SignalingState();
            HAVE_REMOTE_PRANSWER = new SignalingState();
            SignalingState signalingState2 = signalingState;
            CLOSED = new SignalingState();
            $VALUES = new SignalingState[]{STABLE, HAVE_LOCAL_OFFER, HAVE_LOCAL_PRANSWER, HAVE_REMOTE_OFFER, HAVE_REMOTE_PRANSWER, signalingState2};
        }
    }

    public static final class TlsCertPolicy
    extends Enum<TlsCertPolicy> {
        public static final /* enum */ TlsCertPolicy TLS_CERT_POLICY_SECURE;
        public static final /* enum */ TlsCertPolicy TLS_CERT_POLICY_INSECURE_NO_CHECK;
        private static final /* synthetic */ TlsCertPolicy[] $VALUES;

        public static TlsCertPolicy[] values() {
            return (TlsCertPolicy[])$VALUES.clone();
        }

        public static TlsCertPolicy valueOf(String string) {
            return Enum.valueOf(TlsCertPolicy.class, string);
        }

        static {
            TlsCertPolicy tlsCertPolicy;
            TLS_CERT_POLICY_SECURE = new TlsCertPolicy();
            TlsCertPolicy tlsCertPolicy2 = tlsCertPolicy;
            TLS_CERT_POLICY_INSECURE_NO_CHECK = new TlsCertPolicy();
            $VALUES = new TlsCertPolicy[]{TLS_CERT_POLICY_SECURE, tlsCertPolicy2};
        }
    }

    public static final class PeerConnectionState
    extends Enum<PeerConnectionState> {
        public static final /* enum */ PeerConnectionState NEW;
        public static final /* enum */ PeerConnectionState CONNECTING;
        public static final /* enum */ PeerConnectionState CONNECTED;
        public static final /* enum */ PeerConnectionState DISCONNECTED;
        public static final /* enum */ PeerConnectionState FAILED;
        public static final /* enum */ PeerConnectionState CLOSED;
        private static final /* synthetic */ PeerConnectionState[] $VALUES;

        public static PeerConnectionState[] values() {
            return (PeerConnectionState[])$VALUES.clone();
        }

        public static PeerConnectionState valueOf(String string) {
            return Enum.valueOf(PeerConnectionState.class, string);
        }

        @CalledByNative(value="PeerConnectionState")
        static PeerConnectionState fromNativeIndex(int n) {
            return PeerConnectionState.values()[n];
        }

        static {
            PeerConnectionState peerConnectionState;
            NEW = new PeerConnectionState();
            CONNECTING = new PeerConnectionState();
            CONNECTED = new PeerConnectionState();
            DISCONNECTED = new PeerConnectionState();
            FAILED = new PeerConnectionState();
            PeerConnectionState peerConnectionState2 = peerConnectionState;
            CLOSED = new PeerConnectionState();
            $VALUES = new PeerConnectionState[]{NEW, CONNECTING, CONNECTED, DISCONNECTED, FAILED, peerConnectionState2};
        }
    }

    public static final class IceConnectionState
    extends Enum<IceConnectionState> {
        public static final /* enum */ IceConnectionState NEW;
        public static final /* enum */ IceConnectionState CHECKING;
        public static final /* enum */ IceConnectionState CONNECTED;
        public static final /* enum */ IceConnectionState COMPLETED;
        public static final /* enum */ IceConnectionState FAILED;
        public static final /* enum */ IceConnectionState DISCONNECTED;
        public static final /* enum */ IceConnectionState CLOSED;
        private static final /* synthetic */ IceConnectionState[] $VALUES;

        public static IceConnectionState[] values() {
            return (IceConnectionState[])$VALUES.clone();
        }

        public static IceConnectionState valueOf(String string) {
            return Enum.valueOf(IceConnectionState.class, string);
        }

        @CalledByNative(value="IceConnectionState")
        static IceConnectionState fromNativeIndex(int n) {
            return IceConnectionState.values()[n];
        }

        static {
            IceConnectionState iceConnectionState;
            NEW = new IceConnectionState();
            CHECKING = new IceConnectionState();
            CONNECTED = new IceConnectionState();
            COMPLETED = new IceConnectionState();
            FAILED = new IceConnectionState();
            DISCONNECTED = new IceConnectionState();
            IceConnectionState iceConnectionState2 = iceConnectionState;
            CLOSED = new IceConnectionState();
            $VALUES = new IceConnectionState[]{NEW, CHECKING, CONNECTED, COMPLETED, FAILED, DISCONNECTED, iceConnectionState2};
        }
    }

    public static final class IceGatheringState
    extends Enum<IceGatheringState> {
        public static final /* enum */ IceGatheringState NEW;
        public static final /* enum */ IceGatheringState GATHERING;
        public static final /* enum */ IceGatheringState COMPLETE;
        private static final /* synthetic */ IceGatheringState[] $VALUES;

        public static IceGatheringState[] values() {
            return (IceGatheringState[])$VALUES.clone();
        }

        public static IceGatheringState valueOf(String string) {
            return Enum.valueOf(IceGatheringState.class, string);
        }

        @CalledByNative(value="IceGatheringState")
        static IceGatheringState fromNativeIndex(int n) {
            return IceGatheringState.values()[n];
        }

        static {
            IceGatheringState iceGatheringState;
            NEW = new IceGatheringState();
            GATHERING = new IceGatheringState();
            IceGatheringState iceGatheringState2 = iceGatheringState;
            COMPLETE = new IceGatheringState();
            $VALUES = new IceGatheringState[]{NEW, GATHERING, iceGatheringState2};
        }
    }
}

