/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import org.otwebrtc.CalledByNative;
import org.otwebrtc.CapturerObserver;
import org.otwebrtc.NativeAndroidVideoTrackSource;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoProcessor;

class NativeCapturerObserver
implements CapturerObserver {
    private final NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;

    @CalledByNative
    public NativeCapturerObserver(long l) {
        NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;
        NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource2 = nativeAndroidVideoTrackSource;
        nativeAndroidVideoTrackSource = new NativeAndroidVideoTrackSource(l);
        v1.nativeAndroidVideoTrackSource = nativeAndroidVideoTrackSource2;
    }

    @Override
    public void onCapturerStarted(boolean bl) {
        this.nativeAndroidVideoTrackSource.setState(bl);
    }

    @Override
    public void onCapturerStopped() {
        this.nativeAndroidVideoTrackSource.setState(false);
    }

    @Override
    public void onFrameCaptured(VideoFrame videoFrame) {
        VideoProcessor.FrameAdaptationParameters frameAdaptationParameters = this.nativeAndroidVideoTrackSource.adaptFrame(videoFrame);
        if (frameAdaptationParameters == null) {
            return;
        }
        VideoProcessor.FrameAdaptationParameters frameAdaptationParameters2 = frameAdaptationParameters;
        int n = frameAdaptationParameters2.cropX;
        int n2 = frameAdaptationParameters2.cropY;
        int n3 = frameAdaptationParameters2.cropWidth;
        int n4 = frameAdaptationParameters2.cropHeight;
        int n5 = frameAdaptationParameters2.scaleWidth;
        int n6 = frameAdaptationParameters2.scaleHeight;
        VideoFrame.Buffer buffer = videoFrame.getBuffer().cropAndScale(n, n2, n3, n4, n5, n6);
        int n7 = videoFrame.getRotation();
        long l = frameAdaptationParameters.timestampNs;
        this.nativeAndroidVideoTrackSource.onFrameCaptured(new VideoFrame(buffer, n7, l));
        buffer.release();
    }
}

