/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import org.otwebrtc.AudioTrack;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.JniCommon;
import org.otwebrtc.VideoTrack;

public class MediaStreamTrack {
    public static final String AUDIO_TRACK_KIND = "audio";
    public static final String VIDEO_TRACK_KIND = "video";
    private long nativeTrack;

    @Nullable
    static MediaStreamTrack createMediaStreamTrack(long l) {
        if (l == 0L) {
            return null;
        }
        String string = MediaStreamTrack.nativeGetKind(l);
        if (string.equals(AUDIO_TRACK_KIND)) {
            return new AudioTrack(l);
        }
        if (string.equals(VIDEO_TRACK_KIND)) {
            return new VideoTrack(l);
        }
        return null;
    }

    public MediaStreamTrack(long l) {
        if (l != 0L) {
            this.nativeTrack = l;
            return;
        }
        throw new IllegalArgumentException("nativeTrack may not be null");
    }

    private void checkMediaStreamTrackExists() {
        if (this.nativeTrack != 0L) {
            return;
        }
        throw new IllegalStateException("MediaStreamTrack has been disposed.");
    }

    private static native String nativeGetId(long var0);

    private static native String nativeGetKind(long var0);

    private static native boolean nativeGetEnabled(long var0);

    private static native boolean nativeSetEnabled(long var0, boolean var2);

    private static native State nativeGetState(long var0);

    public String id() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetId(mediaStreamTrack.nativeTrack);
    }

    public String kind() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetKind(mediaStreamTrack.nativeTrack);
    }

    public boolean enabled() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetEnabled(mediaStreamTrack.nativeTrack);
    }

    public boolean setEnabled(boolean bl) {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeSetEnabled(mediaStreamTrack.nativeTrack, bl);
    }

    public State state() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetState(mediaStreamTrack.nativeTrack);
    }

    public void dispose() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        JniCommon.nativeReleaseRef(mediaStreamTrack.nativeTrack);
        mediaStreamTrack.nativeTrack = 0L;
    }

    long getNativeMediaStreamTrack() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return mediaStreamTrack.nativeTrack;
    }

    public static final class MediaType
    extends Enum<MediaType> {
        public static final /* enum */ MediaType MEDIA_TYPE_AUDIO;
        public static final /* enum */ MediaType MEDIA_TYPE_VIDEO;
        private static final /* synthetic */ MediaType[] $VALUES;
        private final int nativeIndex;

        public static MediaType[] values() {
            return (MediaType[])$VALUES.clone();
        }

        public static MediaType valueOf(String string) {
            return Enum.valueOf(MediaType.class, string);
        }

        private MediaType(int n2) {
            this.nativeIndex = n2;
        }

        @CalledByNative(value="MediaType")
        static MediaType fromNativeIndex(int n) {
            for (MediaType mediaType : MediaType.values()) {
                if (mediaType.getNative() != n) continue;
                return mediaType;
            }
            throw new IllegalArgumentException("Unknown native media type: " + n);
        }

        static {
            MediaType mediaType;
            MEDIA_TYPE_AUDIO = new MediaType(0);
            MediaType mediaType2 = mediaType;
            MEDIA_TYPE_VIDEO = new MediaType(1);
            $VALUES = new MediaType[]{MEDIA_TYPE_AUDIO, mediaType2};
        }

        @CalledByNative(value="MediaType")
        int getNative() {
            return this.nativeIndex;
        }
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State LIVE;
        public static final /* enum */ State ENDED;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        @CalledByNative(value="State")
        static State fromNativeIndex(int n) {
            return State.values()[n];
        }

        static {
            State state;
            LIVE = new State();
            State state2 = state;
            ENDED = new State();
            $VALUES = new State[]{LIVE, state2};
        }
    }
}

