/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import org.otwebrtc.CalledByNative;
import org.otwebrtc.JniCommon;
import org.otwebrtc.RefCountDelegate;

public class MediaSource {
    private final RefCountDelegate refCountDelegate = new RefCountDelegate(() -> JniCommon.nativeReleaseRef(l));
    private long nativeSource;

    public MediaSource(long l) {
        this.nativeSource = l;
    }

    private void checkMediaSourceExists() {
        if (this.nativeSource != 0L) {
            return;
        }
        throw new IllegalStateException("MediaSource has been disposed.");
    }

    private static native State nativeGetState(long var0);

    public State state() {
        MediaSource mediaSource = this;
        mediaSource.checkMediaSourceExists();
        return MediaSource.nativeGetState(mediaSource.nativeSource);
    }

    public void dispose() {
        MediaSource mediaSource = this;
        mediaSource.checkMediaSourceExists();
        mediaSource.refCountDelegate.release();
        mediaSource.nativeSource = 0L;
    }

    protected long getNativeMediaSource() {
        MediaSource mediaSource = this;
        mediaSource.checkMediaSourceExists();
        return mediaSource.nativeSource;
    }

    void runWithReference(Runnable runnable) {
        if (this.refCountDelegate.safeRetain()) {
            try {
                runnable.run();
                this.refCountDelegate.release();
            }
            catch (Throwable throwable) {
                this.refCountDelegate.release();
                throw throwable;
            }
        }
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIALIZING;
        public static final /* enum */ State LIVE;
        public static final /* enum */ State ENDED;
        public static final /* enum */ State MUTED;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        @CalledByNative(value="State")
        static State fromNativeIndex(int n) {
            return State.values()[n];
        }

        static {
            State state;
            INITIALIZING = new State();
            LIVE = new State();
            ENDED = new State();
            State state2 = state;
            MUTED = new State();
            $VALUES = new State[]{INITIALIZING, LIVE, ENDED, state2};
        }
    }
}

