/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import org.otwebrtc.AndroidVideoDecoder;
import org.otwebrtc.EglBase;
import org.otwebrtc.Logging;
import org.otwebrtc.MediaCodecUtils;
import org.otwebrtc.MediaCodecWrapperFactoryImpl;
import org.otwebrtc.Predicate;
import org.otwebrtc.VideoCodecInfo;
import org.otwebrtc.VideoCodecMimeType;
import org.otwebrtc.VideoDecoder;
import org.otwebrtc.VideoDecoderFactory;

class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    @Nullable
    private final EglBase.Context sharedContext;
    @Nullable
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;

    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context context, @Nullable Predicate<MediaCodecInfo> predicate) {
        this.sharedContext = context;
        this.codecAllowedPredicate = predicate;
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecMimeType videoCodecMimeType) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecMimeType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecMimeType videoCodecMimeType) {
        mediaCodecInfo.getName();
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecMimeType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecMimeType.mimeType())) == null) {
            return false;
        }
        return this.isCodecAllowed(mediaCodecInfo);
    }

    private boolean isCodecAllowed(MediaCodecInfo mediaCodecInfo) {
        Predicate<MediaCodecInfo> predicate = ((MediaCodecVideoDecoderFactory)((Object)predicate)).codecAllowedPredicate;
        if (predicate == null) {
            return true;
        }
        return predicate.test(mediaCodecInfo);
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        String string = mediaCodecInfo.getName();
        if (Build.VERSION.SDK_INT >= 21 && string.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && string.startsWith("OMX.Exynos.");
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo object) {
        MediaCodecWrapperFactoryImpl mediaCodecWrapperFactoryImpl;
        Object object2 = ((MediaCodecVideoDecoderFactory)((Object)mediaCodecWrapperFactoryImpl2)).findCodecForType((VideoCodecMimeType)((Object)(object = VideoCodecMimeType.valueOf(((VideoCodecInfo)object).getName()))));
        if (object2 == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = object2.getCapabilitiesForType(((VideoCodecMimeType)((Object)object)).mimeType());
        MediaCodecVideoDecoderFactory mediaCodecVideoDecoderFactory = mediaCodecWrapperFactoryImpl2;
        MediaCodecWrapperFactoryImpl mediaCodecWrapperFactoryImpl2 = mediaCodecWrapperFactoryImpl;
        mediaCodecWrapperFactoryImpl = new MediaCodecWrapperFactoryImpl();
        object2 = object2.getName();
        int n = MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, codecCapabilities);
        EglBase.Context context = mediaCodecVideoDecoderFactory.sharedContext;
        return new AndroidVideoDecoder(mediaCodecWrapperFactoryImpl2, (String)object2, (VideoCodecMimeType)((Object)object), n, context);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<MediaCodecInfo> arrayList;
        ArrayList<MediaCodecInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<MediaCodecInfo>();
        int n = 3;
        VideoCodecMimeType[] videoCodecMimeTypeArray = new VideoCodecMimeType[3];
        VideoCodecMimeType[] videoCodecMimeTypeArray2 = videoCodecMimeTypeArray;
        videoCodecMimeTypeArray[0] = VideoCodecMimeType.VP8;
        videoCodecMimeTypeArray[1] = VideoCodecMimeType.VP9;
        videoCodecMimeTypeArray[2] = VideoCodecMimeType.H264;
        for (int i2 = 0; i2 < n; ++i2) {
            VideoCodecInfo videoCodecInfo;
            VideoCodecMimeType videoCodecMimeType = videoCodecMimeTypeArray2[i2];
            Object object = this.findCodecForType(videoCodecMimeType);
            if (object == null) continue;
            VideoCodecMimeType videoCodecMimeType2 = videoCodecMimeType;
            String string = videoCodecMimeType2.name();
            if (videoCodecMimeType2 == VideoCodecMimeType.H264 && this.isH264HighProfileSupported((MediaCodecInfo)object)) {
                VideoCodecInfo videoCodecInfo2;
                object = videoCodecInfo2;
                videoCodecInfo2 = new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecMimeType, true));
                arrayList2.add((MediaCodecInfo)object);
            }
            object = videoCodecInfo;
            videoCodecInfo = new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecMimeType, false));
            arrayList2.add((MediaCodecInfo)object);
        }
        ArrayList<MediaCodecInfo> arrayList3 = arrayList2;
        return arrayList3.toArray(new VideoCodecInfo[arrayList3.size()]);
    }
}

