/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.otwebrtc.Loggable;

public class Logging {
    private static final Logger fallbackLogger = Logging.createFallbackLogger();
    private static volatile boolean loggingEnabled;
    @Nullable
    private static Loggable loggable;
    private static Severity loggableSeverity;

    private static Logger createFallbackLogger() {
        Logger logger = Logger.getLogger("org.otwebrtc.Logging");
        logger.setLevel(Level.ALL);
        return logger;
    }

    static void injectLoggable(Loggable loggable, Severity severity) {
        if (loggable != null) {
            Logging.loggable = loggable;
            loggableSeverity = severity;
        }
    }

    static void deleteInjectedLoggable() {
        loggable = null;
    }

    public static void enableLogThreads() {
        Logging.nativeEnableLogThreads();
    }

    public static void enableLogTimeStamps() {
        Logging.nativeEnableLogTimeStamps();
    }

    @Deprecated
    public static void enableTracing(String string, EnumSet<TraceLevel> enumSet) {
    }

    public static synchronized void enableLogToDebugOutput(Severity severity) {
        if (loggable == null) {
            Logging.nativeEnableLogToDebugOutput(severity.ordinal());
            loggingEnabled = true;
            return;
        }
        throw new IllegalStateException("Logging to native debug output not supported while Loggable is injected. Delete the Loggable before calling this method.");
    }

    public static void log(Severity severity, String string, String string2) {
        if (string != null && string2 != null) {
            if (loggable != null) {
                if (severity.ordinal() < loggableSeverity.ordinal()) {
                    return;
                }
                loggable.onLogMessage(string2, severity, string);
                return;
            }
            if (loggingEnabled) {
                Logging.nativeLog(severity.ordinal(), string, string2);
                return;
            }
            int n = 1.$SwitchMap$org$otwebrtc$Logging$Severity[severity.ordinal()];
            Level level = n != 1 ? (n != 2 ? (n != 3 ? Level.FINE : Level.INFO) : Level.WARNING) : Level.SEVERE;
            fallbackLogger.log(level, string + ": " + string2);
            return;
        }
        throw new IllegalArgumentException("Logging tag or message may not be null.");
    }

    public static void d(String string, String string2) {
        Logging.log(Severity.LS_INFO, string, string2);
    }

    public static void e(String string, String string2) {
        Logging.log(Severity.LS_ERROR, string, string2);
    }

    public static void w(String string, String string2) {
        Logging.log(Severity.LS_WARNING, string, string2);
    }

    public static void e(String string, String string2, Throwable throwable) {
        Logging.log(Severity.LS_ERROR, string, string2);
        Logging.log(Severity.LS_ERROR, string, throwable.toString());
        Logging.log(Severity.LS_ERROR, string, Logging.getStackTraceString(throwable));
    }

    public static void w(String string, String string2, Throwable throwable) {
        Logging.log(Severity.LS_WARNING, string, string2);
        Logging.log(Severity.LS_WARNING, string, throwable.toString());
        Logging.log(Severity.LS_WARNING, string, Logging.getStackTraceString(throwable));
    }

    public static void v(String string, String string2) {
        Logging.log(Severity.LS_VERBOSE, string, string2);
    }

    private static String getStackTraceString(Throwable object) {
        StringWriter stringWriter;
        if (object == null) {
            return "";
        }
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).toString();
    }

    private static native void nativeEnableLogToDebugOutput(int var0);

    private static native void nativeEnableLogThreads();

    private static native void nativeEnableLogTimeStamps();

    private static native void nativeLog(int var0, String var1, String var2);

    public static final class Severity
    extends Enum<Severity> {
        public static final /* enum */ Severity LS_VERBOSE;
        public static final /* enum */ Severity LS_INFO;
        public static final /* enum */ Severity LS_WARNING;
        public static final /* enum */ Severity LS_ERROR;
        public static final /* enum */ Severity LS_NONE;
        private static final /* synthetic */ Severity[] $VALUES;

        public static Severity[] values() {
            return (Severity[])$VALUES.clone();
        }

        public static Severity valueOf(String string) {
            return Enum.valueOf(Severity.class, string);
        }

        static {
            Severity severity;
            LS_VERBOSE = new Severity();
            LS_INFO = new Severity();
            LS_WARNING = new Severity();
            LS_ERROR = new Severity();
            Severity severity2 = severity;
            LS_NONE = new Severity();
            $VALUES = new Severity[]{LS_VERBOSE, LS_INFO, LS_WARNING, LS_ERROR, severity2};
        }
    }

    @Deprecated
    public static final class TraceLevel
    extends Enum<TraceLevel> {
        public static final /* enum */ TraceLevel TRACE_NONE;
        public static final /* enum */ TraceLevel TRACE_STATEINFO;
        public static final /* enum */ TraceLevel TRACE_WARNING;
        public static final /* enum */ TraceLevel TRACE_ERROR;
        public static final /* enum */ TraceLevel TRACE_CRITICAL;
        public static final /* enum */ TraceLevel TRACE_APICALL;
        public static final /* enum */ TraceLevel TRACE_DEFAULT;
        public static final /* enum */ TraceLevel TRACE_MODULECALL;
        public static final /* enum */ TraceLevel TRACE_MEMORY;
        public static final /* enum */ TraceLevel TRACE_TIMER;
        public static final /* enum */ TraceLevel TRACE_STREAM;
        public static final /* enum */ TraceLevel TRACE_DEBUG;
        public static final /* enum */ TraceLevel TRACE_INFO;
        public static final /* enum */ TraceLevel TRACE_TERSEINFO;
        public static final /* enum */ TraceLevel TRACE_ALL;
        private static final /* synthetic */ TraceLevel[] $VALUES;
        public final int level;

        public static TraceLevel[] values() {
            return (TraceLevel[])$VALUES.clone();
        }

        public static TraceLevel valueOf(String string) {
            return Enum.valueOf(TraceLevel.class, string);
        }

        private TraceLevel(int n2) {
            this.level = n2;
        }

        static {
            TraceLevel traceLevel;
            TRACE_NONE = new TraceLevel(0);
            TRACE_STATEINFO = new TraceLevel(1);
            TRACE_WARNING = new TraceLevel(2);
            TRACE_ERROR = new TraceLevel(4);
            TRACE_CRITICAL = new TraceLevel(8);
            TRACE_APICALL = new TraceLevel(16);
            TRACE_DEFAULT = new TraceLevel(255);
            TRACE_MODULECALL = new TraceLevel(32);
            TRACE_MEMORY = new TraceLevel(256);
            TRACE_TIMER = new TraceLevel(512);
            TRACE_STREAM = new TraceLevel(1024);
            TRACE_DEBUG = new TraceLevel(2048);
            TRACE_INFO = new TraceLevel(4096);
            TRACE_TERSEINFO = new TraceLevel(8192);
            TraceLevel traceLevel2 = traceLevel;
            TRACE_ALL = new TraceLevel(65535);
            $VALUES = new TraceLevel[]{TRACE_NONE, TRACE_STATEINFO, TRACE_WARNING, TRACE_ERROR, TRACE_CRITICAL, TRACE_APICALL, TRACE_DEFAULT, TRACE_MODULECALL, TRACE_MEMORY, TRACE_TIMER, TRACE_STREAM, TRACE_DEBUG, TRACE_INFO, TRACE_TERSEINFO, traceLevel2};
        }
    }
}

