/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.otwebrtc.JniCommon;
import org.otwebrtc.RefCountDelegate;
import org.otwebrtc.RefCounted;
import org.otwebrtc.VideoFrame;

public class JavaI420Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final RefCountDelegate refCountDelegate;

    private JavaI420Buffer(int n, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4, ByteBuffer byteBuffer3, int n5, @Nullable Runnable runnable) {
        RefCountDelegate refCountDelegate;
        refCounted.width = n;
        refCounted.height = n2;
        refCounted.dataY = byteBuffer;
        refCounted.dataU = byteBuffer2;
        refCounted.dataV = byteBuffer3;
        refCounted.strideY = n3;
        refCounted.strideU = n4;
        refCounted.strideV = n5;
        RefCounted refCounted = refCountDelegate;
        refCountDelegate = new RefCountDelegate(runnable);
        v1.refCountDelegate = refCounted;
    }

    private static void checkCapacity(ByteBuffer byteBuffer, int n, int n2, int n3) {
        n = n3 * (n2 - 1) + n;
        if (byteBuffer.capacity() >= n) {
            return;
        }
        throw new IllegalArgumentException("Buffer must be at least " + n + " bytes, but was " + byteBuffer.capacity());
    }

    public static JavaI420Buffer wrap(int n, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4, ByteBuffer byteBuffer3, int n5, @Nullable Runnable runnable) {
        if (byteBuffer != null && byteBuffer2 != null && byteBuffer3 != null) {
            if (byteBuffer.isDirect() && byteBuffer2.isDirect() && byteBuffer3.isDirect()) {
                byteBuffer = byteBuffer.slice();
                byteBuffer2 = byteBuffer2.slice();
                byteBuffer3 = byteBuffer3.slice();
                int n6 = (n + 1) / 2;
                int n7 = (n2 + 1) / 2;
                JavaI420Buffer.checkCapacity(byteBuffer, n, n2, n3);
                JavaI420Buffer.checkCapacity(byteBuffer2, n6, n7, n4);
                JavaI420Buffer.checkCapacity(byteBuffer3, n6, n7, n5);
                return new JavaI420Buffer(n, n2, byteBuffer, n3, byteBuffer2, n4, byteBuffer3, n5, runnable);
            }
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        throw new IllegalArgumentException("Data buffers cannot be null.");
    }

    public static JavaI420Buffer allocate(int n, int n2) {
        int n3 = (n2 + 1) / 2;
        int n4 = (n + 1) / 2;
        int n5 = n * n2;
        int n6 = n5 + 0;
        int n7 = n4 * n3;
        int n8 = n6 + n7;
        Object object = JniCommon.nativeAllocateByteBuffer(n5 + n4 * 2 * n3);
        ByteBuffer byteBuffer = object;
        ByteBuffer byteBuffer2 = object;
        ((ByteBuffer)object).position(0);
        byteBuffer2.limit(n6);
        ByteBuffer byteBuffer3 = byteBuffer2.slice();
        ((ByteBuffer)object).position(n6);
        byteBuffer.limit(n8);
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        ((ByteBuffer)object).position(n8);
        ((ByteBuffer)object).limit(n8 + n7);
        ByteBuffer byteBuffer5 = ((ByteBuffer)object).slice();
        object = () -> JavaI420Buffer.a((ByteBuffer)object);
        return new JavaI420Buffer(n, n2, byteBuffer3, n, byteBuffer4, n4, byteBuffer5, n4, (Runnable)object);
    }

    public static VideoFrame.Buffer cropAndScaleI420(VideoFrame.I420Buffer object, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 == n5 && n4 == n6) {
            VideoFrame.I420Buffer i420Buffer = object;
            ByteBuffer byteBuffer = i420Buffer.getDataY();
            ByteBuffer byteBuffer2 = i420Buffer.getDataU();
            ByteBuffer byteBuffer3 = i420Buffer.getDataV();
            VideoFrame.I420Buffer i420Buffer2 = object;
            VideoFrame.I420Buffer i420Buffer3 = object;
            byteBuffer.position(n + n2 * object.getStrideY());
            byteBuffer2.position((n /= 2) + (n2 /= 2) * object.getStrideU());
            byteBuffer3.position(n + n2 * object.getStrideV());
            object.retain();
            object = byteBuffer.slice();
            n = i420Buffer3.getStrideY();
            ByteBuffer byteBuffer4 = byteBuffer2.slice();
            int n7 = i420Buffer2.getStrideU();
            byteBuffer2 = byteBuffer3.slice();
            int n8 = i420Buffer.getStrideV();
            Objects.requireNonNull(i420Buffer);
            Runnable runnable = i420Buffer::release;
            return JavaI420Buffer.wrap(n5, n6, (ByteBuffer)object, n, byteBuffer4, n7, byteBuffer2, n8, runnable);
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n5, n6);
        VideoFrame.I420Buffer i420Buffer = object;
        int n9 = i420Buffer.getStrideY();
        ByteBuffer byteBuffer = i420Buffer.getDataU();
        int n10 = i420Buffer.getStrideU();
        ByteBuffer byteBuffer5 = i420Buffer.getDataV();
        int n11 = i420Buffer.getStrideV();
        ByteBuffer byteBuffer6 = javaI420Buffer.getDataY();
        int n12 = javaI420Buffer.getStrideY();
        ByteBuffer byteBuffer7 = javaI420Buffer.getDataU();
        int n13 = javaI420Buffer.getStrideU();
        ByteBuffer byteBuffer8 = javaI420Buffer.getDataV();
        int n14 = javaI420Buffer.getStrideV();
        JavaI420Buffer.nativeCropAndScaleI420(object.getDataY(), n9, byteBuffer, n10, byteBuffer5, n11, n, n2, n3, n4, byteBuffer6, n12, byteBuffer7, n13, byteBuffer8, n14, n5, n6);
        return javaI420Buffer;
    }

    private static native void nativeCropAndScaleI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);

    private static /* synthetic */ void a(ByteBuffer byteBuffer) {
        JniCommon.nativeFreeByteBuffer(byteBuffer);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        JavaI420Buffer javaI420Buffer = this;
        javaI420Buffer.retain();
        return javaI420Buffer;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n, int n2, int n3, int n4, int n5, int n6) {
        return JavaI420Buffer.cropAndScaleI420(this, n, n2, n3, n4, n5, n6);
    }
}

