/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.otwebrtc.BaseBitrateAdjuster;
import org.otwebrtc.BitrateAdjuster;
import org.otwebrtc.DynamicBitrateAdjuster;
import org.otwebrtc.EglBase;
import org.otwebrtc.EglBase14;
import org.otwebrtc.FramerateBitrateAdjuster;
import org.otwebrtc.H264Utils;
import org.otwebrtc.HardwareVideoEncoder;
import org.otwebrtc.Logging;
import org.otwebrtc.MediaCodecUtils;
import org.otwebrtc.MediaCodecWrapperFactoryImpl;
import org.otwebrtc.Predicate;
import org.otwebrtc.VideoCodecInfo;
import org.otwebrtc.VideoCodecMimeType;
import org.otwebrtc.VideoEncoder;
import org.otwebrtc.VideoEncoderFactory;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    private static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    @Nullable
    private final EglBase14.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;
    @Nullable
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this(context, bl, bl2, null);
    }

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2, @Nullable Predicate<MediaCodecInfo> predicate) {
        if (context instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)context;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        HardwareVideoEncoderFactory hardwareVideoEncoderFactory = this;
        hardwareVideoEncoderFactory.enableIntelVp8Encoder = bl;
        hardwareVideoEncoderFactory.enableH264HighProfile = bl2;
        hardwareVideoEncoderFactory.codecAllowedPredicate = predicate;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecMimeType videoCodecMimeType) {
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecMimeType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecMimeType videoCodecMimeType) {
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecMimeType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecMimeType.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupportedInCurrentSdk(mediaCodecInfo, videoCodecMimeType) && this.isMediaCodecAllowed(mediaCodecInfo);
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo mediaCodecInfo, VideoCodecMimeType videoCodecMimeType) {
        int n = 1.$SwitchMap$org$otwebrtc$VideoCodecMimeType[videoCodecMimeType.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return false;
                }
                return this.isHardwareSupportedInCurrentSdkH264(mediaCodecInfo);
            }
            return this.isHardwareSupportedInCurrentSdkVp9(mediaCodecInfo);
        }
        return this.isHardwareSupportedInCurrentSdkVp8(mediaCodecInfo);
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo object) {
        return ((String)(object = object.getName())).startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || ((String)object).startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || ((String)object).startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo mediaCodecInfo) {
        String string = mediaCodecInfo.getName();
        return (string.startsWith("OMX.qcom.") || string.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo mediaCodecInfo) {
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String string = mediaCodecInfo.getName();
        return string.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21;
    }

    private boolean isMediaCodecAllowed(MediaCodecInfo mediaCodecInfo) {
        Predicate<MediaCodecInfo> predicate = ((HardwareVideoEncoderFactory)((Object)predicate)).codecAllowedPredicate;
        if (predicate == null) {
            return true;
        }
        return predicate.test(mediaCodecInfo);
    }

    private int getKeyFrameIntervalSec(VideoCodecMimeType videoCodecMimeType) {
        int n = 1.$SwitchMap$org$otwebrtc$VideoCodecMimeType[videoCodecMimeType.ordinal()];
        if (n != 1 && n != 2) {
            if (n == 3) {
                return 20;
            }
            throw new IllegalArgumentException("Unsupported VideoCodecMimeType " + (Object)((Object)videoCodecMimeType));
        }
        return 100;
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecMimeType videoCodecMimeType, String string) {
        if (videoCodecMimeType == VideoCodecMimeType.VP8 && string.startsWith("OMX.qcom.")) {
            int n = Build.VERSION.SDK_INT;
            if (n != 21 && n != 22) {
                if (n == 23) {
                    return 20000;
                }
                if (n > 23) {
                    return 15000;
                }
            } else {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecMimeType videoCodecMimeType, String string) {
        if (string.startsWith("OMX.Exynos.")) {
            if (videoCodecMimeType == VideoCodecMimeType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        return this.enableH264HighProfile && Build.VERSION.SDK_INT > 23 && mediaCodecInfo.getName().startsWith("OMX.Exynos.");
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo object) {
        MediaCodecWrapperFactoryImpl mediaCodecWrapperFactoryImpl;
        int n;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecMimeType videoCodecMimeType = VideoCodecMimeType.valueOf(((VideoCodecInfo)object).name);
        MediaCodecInfo mediaCodecInfo = ((HardwareVideoEncoderFactory)((Object)mediaCodecWrapperFactoryImpl2)).findCodecForType(videoCodecMimeType);
        if (mediaCodecInfo == null) {
            return null;
        }
        VideoCodecMimeType videoCodecMimeType2 = videoCodecMimeType;
        String string = mediaCodecInfo.getName();
        Object object2 = videoCodecMimeType2.mimeType();
        Integer n2 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType((String)object2));
        object2 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType((String)object2));
        if (videoCodecMimeType2 == VideoCodecMimeType.H264) {
            n = H264Utils.isSameH264Profile(((VideoCodecInfo)object).params, MediaCodecUtils.getCodecProperties(videoCodecMimeType, true));
            boolean bl = H264Utils.isSameH264Profile(((VideoCodecInfo)object).params, MediaCodecUtils.getCodecProperties(videoCodecMimeType, false));
            if (n == 0 && !bl) {
                return null;
            }
            if (n != 0 && !super.isH264HighProfileSupported(mediaCodecInfo)) {
                return null;
            }
        }
        HardwareVideoEncoderFactory hardwareVideoEncoderFactory = mediaCodecWrapperFactoryImpl2;
        MediaCodecWrapperFactoryImpl mediaCodecWrapperFactoryImpl2 = mediaCodecWrapperFactoryImpl;
        mediaCodecWrapperFactoryImpl = new MediaCodecWrapperFactoryImpl();
        object = ((VideoCodecInfo)object).params;
        int n3 = hardwareVideoEncoderFactory.getKeyFrameIntervalSec(videoCodecMimeType);
        n = hardwareVideoEncoderFactory.getForcedKeyFrameIntervalMs(videoCodecMimeType, string);
        BitrateAdjuster bitrateAdjuster = hardwareVideoEncoderFactory.createBitrateAdjuster(videoCodecMimeType, string);
        EglBase14.Context context = hardwareVideoEncoderFactory.sharedContext;
        return new HardwareVideoEncoder(mediaCodecWrapperFactoryImpl2, string, videoCodecMimeType, n2, (Integer)object2, (Map<String, String>)object, n3, n, bitrateAdjuster, context);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<MediaCodecInfo> arrayList;
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<MediaCodecInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<MediaCodecInfo>();
        int n = 3;
        VideoCodecMimeType[] videoCodecMimeTypeArray = new VideoCodecMimeType[3];
        VideoCodecMimeType[] videoCodecMimeTypeArray2 = videoCodecMimeTypeArray;
        videoCodecMimeTypeArray[0] = VideoCodecMimeType.VP8;
        videoCodecMimeTypeArray[1] = VideoCodecMimeType.VP9;
        videoCodecMimeTypeArray[2] = VideoCodecMimeType.H264;
        for (int i2 = 0; i2 < n; ++i2) {
            VideoCodecInfo videoCodecInfo;
            VideoCodecMimeType videoCodecMimeType = videoCodecMimeTypeArray2[i2];
            Object object = this.findCodecForType(videoCodecMimeType);
            if (object == null) continue;
            VideoCodecMimeType videoCodecMimeType2 = videoCodecMimeType;
            String string = videoCodecMimeType2.name();
            if (videoCodecMimeType2 == VideoCodecMimeType.H264 && this.isH264HighProfileSupported((MediaCodecInfo)object)) {
                VideoCodecInfo videoCodecInfo2;
                object = videoCodecInfo2;
                videoCodecInfo2 = new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecMimeType, true));
                arrayList2.add((MediaCodecInfo)object);
            }
            object = videoCodecInfo;
            videoCodecInfo = new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecMimeType, false));
            arrayList2.add((MediaCodecInfo)object);
        }
        ArrayList<MediaCodecInfo> arrayList3 = arrayList2;
        return arrayList3.toArray(new VideoCodecInfo[arrayList3.size()]);
    }
}

