/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.content.Context;
import android.os.SystemClock;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.CapturerObserver;
import org.otwebrtc.JavaI420Buffer;
import org.otwebrtc.Logging;
import org.otwebrtc.SurfaceTextureHelper;
import org.otwebrtc.VideoCapturer;
import org.otwebrtc.VideoFrame;

public class FileVideoCapturer
implements VideoCapturer {
    private static final String TAG = "FileVideoCapturer";
    private final VideoReader videoReader;
    private CapturerObserver capturerObserver;
    private final Timer timer = new Timer();
    private final TimerTask tickTask = new TimerTask(){

        @Override
        public void run() {
            FileVideoCapturer.this.tick();
        }
    };

    public FileVideoCapturer(String string) {
        try {
            this.videoReader = new VideoReaderY4M(string);
            return;
        }
        catch (IOException iOException) {
            Logging.d(TAG, "Could not open video file: " + string);
            throw iOException;
        }
    }

    public void tick() {
        VideoFrame videoFrame = this.videoReader.getNextFrame();
        this.capturerObserver.onFrameCaptured(videoFrame);
        videoFrame.release();
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
    }

    @Override
    public void startCapture(int n, int n2, int n3) {
        long l = 1000 / n3;
        this.timer.schedule(this.tickTask, 0L, l);
    }

    @Override
    public void stopCapture() {
        this.timer.cancel();
    }

    @Override
    public void changeCaptureFormat(int n, int n2, int n3) {
    }

    @Override
    public void dispose() {
        this.videoReader.close();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    private static class VideoReaderY4M
    implements VideoReader {
        private static final String TAG = "VideoReaderY4M";
        private static final String Y4M_FRAME_DELIMETER = "FRAME";
        private static final int FRAME_DELIMETER_LENGTH = 6;
        private final int frameWidth;
        private final int frameHeight;
        private final long videoStart;
        private final RandomAccessFile mediaFile;
        private final FileChannel mediaFileChannel;

        public VideoReaderY4M(String stringArray) {
            int n;
            StringBuilder stringBuilder;
            RandomAccessFile randomAccessFile;
            Object object = randomAccessFile;
            this.mediaFile = new RandomAccessFile((String)stringArray, "r");
            this.mediaFileChannel = ((RandomAccessFile)object).getChannel();
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            while ((n = this.mediaFile.read()) != -1) {
                if (n == 10) {
                    this.videoStart = this.mediaFileChannel.position();
                    stringArray = ((StringBuilder)object).toString().split("[ ]");
                    int n2 = 0;
                    n = 0;
                    String string = "";
                    for (String string2 : stringArray) {
                        char c2 = string2.charAt(0);
                        if (c2 != 'C') {
                            if (c2 != 'H') {
                                if (c2 != 'W') continue;
                                n2 = Integer.parseInt(string2.substring(1));
                                continue;
                            }
                            n = Integer.parseInt(string2.substring(1));
                            continue;
                        }
                        string = string2.substring(1);
                    }
                    Logging.d(TAG, "Color space: " + string);
                    if (!string.equals("420") && !string.equals("420mpeg2")) {
                        throw new IllegalArgumentException("Does not support any other color space than I420 or I420mpeg2");
                    }
                    if (n2 % 2 != 1 && n % 2 != 1) {
                        this.frameWidth = n2;
                        this.frameHeight = n;
                        Logging.d(TAG, "frame dim: (" + n2 + ", " + n + ")");
                        return;
                    }
                    throw new IllegalArgumentException("Does not support odd width or height");
                }
                ((StringBuilder)object).append((char)n);
            }
            throw new RuntimeException("Found end of file before end of header for file: " + (String)stringArray);
        }

        @Override
        public VideoFrame getNextFrame() {
            String string;
            block12: {
                String string2;
                ByteBuffer byteBuffer;
                ByteBuffer byteBuffer2;
                ByteBuffer byteBuffer3;
                ByteBuffer byteBuffer4;
                JavaI420Buffer javaI420Buffer;
                long l;
                block11: {
                    VideoReaderY4M videoReaderY4M = this;
                    l = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                    JavaI420Buffer javaI420Buffer2 = javaI420Buffer = JavaI420Buffer.allocate(videoReaderY4M.frameWidth, this.frameHeight);
                    byteBuffer4 = javaI420Buffer2.getDataY();
                    byteBuffer3 = javaI420Buffer2.getDataU();
                    byteBuffer2 = javaI420Buffer2.getDataV();
                    int cfr_ignored_0 = (this.frameHeight + 1) / 2;
                    javaI420Buffer.getStrideY();
                    javaI420Buffer.getStrideU();
                    javaI420Buffer.getStrideV();
                    try {
                        byteBuffer = ByteBuffer.allocate(FRAME_DELIMETER_LENGTH);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    if (videoReaderY4M.mediaFileChannel.read(byteBuffer) >= FRAME_DELIMETER_LENGTH) break block11;
                    VideoReaderY4M videoReaderY4M2 = this;
                    VideoReaderY4M videoReaderY4M3 = videoReaderY4M2;
                    videoReaderY4M2.mediaFileChannel.position(this.videoStart);
                    if (videoReaderY4M3.mediaFileChannel.read(byteBuffer) >= FRAME_DELIMETER_LENGTH) break block11;
                    throw new RuntimeException("Error looping video");
                }
                string = string2;
                if (!new String(byteBuffer.array(), Charset.forName("US-ASCII")).equals("FRAME\n")) break block12;
                VideoReaderY4M videoReaderY4M = this;
                VideoReaderY4M videoReaderY4M4 = videoReaderY4M;
                VideoReaderY4M videoReaderY4M5 = videoReaderY4M;
                videoReaderY4M.mediaFileChannel.read(byteBuffer4);
                videoReaderY4M5.mediaFileChannel.read(byteBuffer3);
                videoReaderY4M4.mediaFileChannel.read(byteBuffer2);
                return new VideoFrame(javaI420Buffer, 0, l);
            }
            throw new RuntimeException("Frames should be delimited by FRAME plus newline, found delimter was: '" + string + "'");
        }

        @Override
        public void close() {
            try {
                this.mediaFile.close();
            }
            catch (IOException iOException) {
                Logging.e(TAG, "Problem closing file", iOException);
            }
        }
    }

    private static interface VideoReader {
        public VideoFrame getNextFrame();

        public void close();
    }
}

