/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.EglBase;
import org.otwebrtc.GlTextureFrameBuffer;
import org.otwebrtc.GlUtil;
import org.otwebrtc.Logging;
import org.otwebrtc.RendererCommon;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoFrameDrawer;
import org.otwebrtc.VideoSink;

public class EglRenderer
implements VideoSink {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    protected final String name;
    private final Object handlerLock;
    @Nullable
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners;
    private volatile ErrorCallback errorCallback;
    private final Object fpsReductionLock;
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    @Nullable
    private EglBase eglBase;
    private final VideoFrameDrawer frameDrawer;
    @Nullable
    private RendererCommon.GlDrawer drawer;
    private boolean usePresentationTimeStamp;
    private final Matrix drawMatrix;
    private final Object frameLock;
    @Nullable
    private VideoFrame pendingFrame;
    private final Object layoutLock;
    private float layoutAspectRatio;
    private boolean mirrorHorizontally;
    private boolean mirrorVertically;
    private final Object statisticsLock;
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private final GlTextureFrameBuffer bitmapTextureFramebuffer;
    private final Runnable logStatisticsRunnable;
    private final EglSurfaceCreation eglSurfaceCreationRunnable;

    public EglRenderer(String string) {
        VideoFrameDrawer videoFrameDrawer;
        EglRenderer eglRenderer = videoFrameDrawer2;
        VideoFrameDrawer videoFrameDrawer2 = videoFrameDrawer;
        videoFrameDrawer = new VideoFrameDrawer();
        eglRenderer(string, videoFrameDrawer2);
    }

    public EglRenderer(String string, VideoFrameDrawer videoFrameDrawer) {
        EglSurfaceCreation eglSurfaceCreation;
        Runnable runnable;
        GlTextureFrameBuffer glTextureFrameBuffer;
        Object object;
        Object object2;
        Object object3;
        Matrix matrix;
        Object object4;
        ArrayList arrayList;
        Object object5;
        Object object6 = object5;
        object5 = new Object();
        this.handlerLock = object6;
        object6 = arrayList;
        arrayList = new ArrayList();
        this.frameListeners = object6;
        object6 = object4;
        object4 = new Object();
        this.fpsReductionLock = object6;
        object6 = matrix;
        matrix = new Matrix();
        this.drawMatrix = object6;
        object6 = object3;
        object3 = new Object();
        this.frameLock = object6;
        object6 = object2;
        object2 = new Object();
        this.layoutLock = object6;
        object6 = object;
        object = new Object();
        this.statisticsLock = object6;
        object6 = glTextureFrameBuffer;
        glTextureFrameBuffer = new GlTextureFrameBuffer(6408);
        this.bitmapTextureFramebuffer = object6;
        object6 = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 v0 = this;
                v0.EglRenderer.this.logStatistics();
                Object object = v0.EglRenderer.this.handlerLock;
                synchronized (object) {
                    block5: {
                        if (v0.EglRenderer.this.renderThreadHandler == null) break block5;
                        1 v2 = this;
                        v2.EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                        v2.EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                    }
                    return;
                }
            }
        };
        this.logStatisticsRunnable = object6;
        object6 = eglSurfaceCreation;
        eglSurfaceCreation = new EglSurfaceCreation();
        this.eglSurfaceCreationRunnable = object6;
        this.name = string;
        this.frameDrawer = videoFrameDrawer;
    }

    private void createEglSurfaceInternal(Object object) {
        EglRenderer eglRenderer = this;
        eglRenderer.eglSurfaceCreationRunnable.setSurface(object);
        eglRenderer.postToRenderThread(eglRenderer.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long l) {
        Object object = this.statisticsLock;
        EglRenderer eglRenderer = this;
        synchronized (object) {
            eglRenderer.statisticsStartTimeNs = l;
            eglRenderer.framesReceived = 0;
            eglRenderer.framesDropped = 0;
            eglRenderer.framesRendered = 0;
            eglRenderer.renderTimeNs = 0L;
            eglRenderer.renderSwapBufferTimeNs = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            block5: {
                if (eglRenderer.renderThreadHandler == null) break block5;
                this.renderThreadHandler.post(runnable);
            }
            return;
        }
    }

    private void clearSurfaceOnRenderThread(float f2, float f3, float f4, float f5) {
        EglBase eglBase = this.eglBase;
        if (eglBase != null && eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)f2, (float)f3, (float)f4, (float)f5);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderFrameOnRenderThread() {
        block30: {
            block33: {
                block28: {
                    block32: {
                        block31: {
                            v0 = this;
                            var1_1 = v0.frameLock;
                            // MONITORENTER : var1_1
                            if (v0.pendingFrame == null) {
                                // MONITOREXIT : var1_1
                                return;
                            }
                            var2_6 = this.pendingFrame;
                            this.pendingFrame = null;
                            // MONITOREXIT : var1_1
                            var1_1 = this.eglBase;
                            if (var1_1 == null || !var1_1.hasSurface()) ** GOTO lbl116
                            v1 = this;
                            var1_1 = v1.fpsReductionLock;
                            {
                                catch (Throwable v2) {
                                    // MONITOREXIT : var1_1
                                    throw v2;
                                }
                            }
                            // MONITORENTER : var1_1
                            if (v1.minRenderPeriodNs == 0x7FFFFFFFFFFFFFFFL) break block31;
                            if (this.minRenderPeriodNs <= 0L) ** GOTO lbl33
                            var3_7 = System.nanoTime();
                            if (var3_7 >= this.nextFrameTimeNs) break block32;
                            this.logD("Skipping frame rendering - fps reduction is active.");
                        }
                        var3_8 = false;
                        ** GOTO lbl34
                    }
                    var5_9 = this.nextFrameTimeNs + this.minRenderPeriodNs;
                    this.nextFrameTimeNs = var5_9;
                    this.nextFrameTimeNs = Math.max(var5_9, var3_7);
lbl33:
                    // 2 sources

                    var3_8 = true;
lbl34:
                    // 2 sources

                    v3 = this;
                    {
                        catch (Throwable v4) {
                            // MONITOREXIT : var1_1
                            throw v4;
                        }
                    }
                    {
                        v5 = v3;
                        v6 = v3;
                        v7 = var2_6;
                        // MONITOREXIT : var1_1
                    }
                    var4_10 = System.nanoTime();
                    var1_2 = (float)v7.getRotatedWidth() / (float)var2_6.getRotatedHeight();
                    var6_11 = v5.layoutLock;
                    // MONITORENTER : var6_11
                    var7_15 = v6.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : var1_2;
                    // MONITOREXIT : var6_11
                    if (!(var1_2 > var7_15)) break block28;
                    {
                        catch (Throwable v8) {
                            // MONITOREXIT : var6_11
                            throw v8;
                        }
                    }
                    var1_2 = var7_15 / var1_2;
                    var6_12 = 1.0f;
                    break block33;
                }
                v9 = var1_2;
                var1_2 = 1.0f;
                var6_12 = v9 / var7_15;
            }
            v10 = this;
            v10.drawMatrix.reset();
            v10.drawMatrix.preTranslate(0.5f, 0.5f);
            var7_16 = v10.drawMatrix;
            var8_18 = v10.mirrorHorizontally != false ? -1.0f : 1.0f;
            var9_21 = this.mirrorVertically != false ? -1.0f : 1.0f;
            v11 = this;
            var7_16.preScale(var8_18, var9_21);
            v11.drawMatrix.preScale(var1_2, var6_12);
            v11.drawMatrix.preTranslate(-0.5f, -0.5f);
            if (!var3_8) ** GOTO lbl113
            v12 = this;
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            v13 = this;
            var1_3 = v13.drawer;
            var6_13 = v13.drawMatrix;
            var7_17 = 0;
            var8_19 = 0;
            var9_22 = v13.eglBase.surfaceWidth();
            var10_23 = v13.eglBase.surfaceHeight();
            v12.frameDrawer.drawFrame(var2_6, (RendererCommon.GlDrawer)var1_3, var6_13, var7_17, var8_19, var9_22, var10_23);
            var6_14 = System.nanoTime();
            if (v12.usePresentationTimeStamp) {
                this.eglBase.swapBuffers(var2_6.getTimestampNs());
            } else {
                this.eglBase.swapBuffers();
            }
            var8_20 = System.nanoTime();
            var1_3 = this.statisticsLock;
            v14 = this;
            v15 = v14;
            v16 = v14;
            v17 = v14;
            v18 = v14;
            v19 = v14;
            v20 = v14;
            // MONITORENTER : var1_3
            try {
                v18.framesRendered = v17.framesRendered + 1;
                v20.renderTimeNs = v19.renderTimeNs + (var8_20 - var4_10);
                v16.renderSwapBufferTimeNs = v15.renderSwapBufferTimeNs + (var8_20 - var6_14);
                // MONITOREXIT : var1_3
                ** GOTO lbl113
            }
            catch (Throwable v21) {
                block29: {
                    // MONITOREXIT : var1_3
                    throw v21;
lbl113:
                    // 2 sources

                    v22 = var2_6;
                    this.notifyCallbacks(var2_6, var3_8);
                    break block29;
lbl116:
                    // 1 sources

                    this.logD("Dropping frame - No surface");
                    var2_6.release();
                    return;
                }
lbl120:
                // 2 sources

                while (true) {
                    v22.release();
                    return;
                }
                {
                    catch (Throwable v23) {
                        break block30;
                    }
                    catch (GlUtil.GlOutOfMemoryException var1_4) {}
                    {
                        v24 = this;
                        v24.logE("Error while drawing frame", var1_4);
                        var1_5 = v24.errorCallback;
                        if (var1_5 == null) ** GOTO lbl131
                    }
                    {
                        var1_5.onGlOutOfMemory();
lbl131:
                        // 2 sources

                        v22 = var2_6;
                        v25 = this;
                        v25.drawer.release();
                        v25.frameDrawer.release();
                        v25.bitmapTextureFramebuffer.release();
                        ** continue;
                    }
                }
            }
        }
        var2_6.release();
        throw v23;
    }

    private void notifyCallbacks(VideoFrame videoFrame, boolean bl) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        EglRenderer eglRenderer = this;
        eglRenderer.drawMatrix.reset();
        eglRenderer.drawMatrix.preTranslate(0.5f, 0.5f);
        Object object = eglRenderer.drawMatrix;
        float f2 = eglRenderer.mirrorHorizontally ? -1.0f : 1.0f;
        float f3 = this.mirrorVertically ? -1.0f : 1.0f;
        EglRenderer eglRenderer2 = this;
        object.preScale(f2, f3);
        eglRenderer2.drawMatrix.preScale(1.0f, -1.0f);
        eglRenderer2.drawMatrix.preTranslate(-0.5f, -0.5f);
        object = eglRenderer2.frameListeners.iterator();
        while (object.hasNext()) {
            Object object2 = (FrameListenerAndParams)object.next();
            if (!bl && ((FrameListenerAndParams)object2).applyFpsReduction) continue;
            object.remove();
            int n = (int)(((FrameListenerAndParams)object2).scale * (float)videoFrame.getRotatedWidth());
            int n2 = (int)(((FrameListenerAndParams)object2).scale * (float)videoFrame.getRotatedHeight());
            if (n != 0 && n2 != 0) {
                FrameListenerAndParams frameListenerAndParams = object2;
                EglRenderer eglRenderer3 = this;
                eglRenderer3.bitmapTextureFramebuffer.setSize(n, n2);
                GLES20.glBindFramebuffer((int)36160, (int)eglRenderer3.bitmapTextureFramebuffer.getFrameBufferId());
                int n3 = eglRenderer3.bitmapTextureFramebuffer.getTextureId();
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n3, (int)0);
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLES20.glClear((int)16384);
                object2 = ((FrameListenerAndParams)object2).drawer;
                eglRenderer3.frameDrawer.drawFrame(videoFrame, (RendererCommon.GlDrawer)object2, this.drawMatrix, 0, 0, n, n2);
                object2 = ByteBuffer.allocateDirect(n * n2 * 4);
                GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
                GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)object2);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
                Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.copyPixelsFromBuffer((Buffer)object2);
                frameListenerAndParams.listener.onFrame(bitmap);
                continue;
            }
            ((FrameListenerAndParams)object2).listener.onFrame(null);
        }
    }

    private String averageTimeAsString(long l, int n) {
        return n <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(l / (long)n) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void logStatistics() {
        var1_2 = v0;
        v0 = new DecimalFormat("#.0");
        var2_4 = System.nanoTime();
        v1 = this;
        var4_6 = v1.statisticsLock;
        synchronized (var4_6) {
            block13: {
                var5_7 = var2_4 - v1.statisticsStartTimeNs;
                if (var5_7 <= 0L) ** GOTO lbl49
                if (this.minRenderPeriodNs != 0x7FFFFFFFFFFFFFFFL) break block13;
                if (this.framesReceived == 0) ** GOTO lbl49
            }
            v3 = var4_6;
            v4 = this;
            v5 = var2_4;
            v6 = this;
            v7 = v6;
            v8 = v6.framesRendered;
            var2_5 = (float)(v8 * TimeUnit.SECONDS.toNanos(1L)) / (float)var5_7;
            v9 = new StringBuilder().append("Duration: ").append(TimeUnit.NANOSECONDS.toMillis(var5_7)).append(" ms. Frames received: ").append(this.framesReceived).append(". Dropped: ").append(this.framesDropped).append(". Rendered: ").append(this.framesRendered).append(". Render fps: ");
            v10 = v9.append(var1_2.format(var2_5)).append(". Average render time: ");
            v11 = this;
            v12 = v11;
            v13 = v11;
            var1_3 = v11.renderTimeNs;
            var3_8 = v13.framesRendered;
            v14 = v10.append(v12.averageTimeAsString(var1_3, var3_8)).append(". Average swapBuffer time: ");
            v15 = this;
            v16 = v15;
            v17 = v15;
            var1_3 = v15.renderSwapBufferTimeNs;
            var0_1 = v17.framesRendered;
            v7.logD(v14.append(v16.averageTimeAsString(var1_3, var0_1)).append(".").toString());
            v4.resetStatistics(v5);
            // ** MonitorExit[v3] (shouldn't be in output)
            return;
lbl49:
            // 2 sources

            return;
        }
    }

    private void logE(String string, Throwable throwable) {
        Logging.e(TAG, this.name + string, throwable);
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + string);
    }

    private void logW(String string) {
        Logging.w(TAG, this.name + string);
    }

    private /* synthetic */ void a(Runnable runnable) {
        EglBase eglBase = this.eglBase;
        if (eglBase != null) {
            eglBase.detachCurrent();
            this.eglBase.releaseSurface();
        }
        runnable.run();
    }

    private /* synthetic */ void a(Looper looper) {
        this.logD("Quitting render thread.");
        looper.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void a(CountDownLatch countDownLatch) {
        Object object = EglBase.lock;
        synchronized (object) {
            GLES20.glUseProgram((int)0);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
            object = this.drawer;
            if (object != null) {
                object.release();
                this.drawer = null;
            }
            EglRenderer eglRenderer = this;
            eglRenderer.frameDrawer.release();
            eglRenderer.bitmapTextureFramebuffer.release();
            if (eglRenderer.eglBase != null) {
                EglRenderer eglRenderer2 = this;
                eglRenderer2.logD("eglBase detach and release.");
                eglRenderer2.eglBase.detachCurrent();
                eglRenderer2.eglBase.release();
                eglRenderer2.eglBase = null;
            }
            this.frameListeners.clear();
            countDownLatch.countDown();
            return;
        }
    }

    private /* synthetic */ void a(EglBase.Context context, int[] nArray) {
        if (context == null) {
            this.logD("EglBase10.create context");
            this.eglBase = EglBase.createEgl10(nArray);
        } else {
            this.logD("EglBase.create shared context");
            this.eglBase = EglBase.create(context, nArray);
        }
    }

    static /* synthetic */ Handler access$302(EglRenderer eglRenderer, Handler handler) {
        eglRenderer.renderThreadHandler = handler;
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void init(@Nullable EglBase.Context var1_1, int[] var2_2, RendererCommon.GlDrawer var3_3, boolean var4_4) {
        v0 = this;
        var5_6 = v0.handlerLock;
        synchronized (var5_6) {
            if (v0.renderThreadHandler != null) ** GOTO lbl35
            v2 = var5_6;
            v3 = this;
            v4 = v3;
            v5 = v3;
            v6 = v3;
            this.logD("Initializing EglRenderer");
            this.drawer = var3_3;
            v3.usePresentationTimeStamp = var4_4;
            var3_3 = v7;
            new HandlerThread(this.name + "EglRenderer").start();
            var4_5 = v8;
            v9 = var4_5;
            v9(var3_3.getLooper(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EglRenderer.this.handlerLock;
                    synchronized (object) {
                        EglRenderer.access$302(EglRenderer.this, null);
                        return;
                    }
                }
            });
            this.renderThreadHandler = v9;
            ThreadUtils.invokeAtFrontUninterruptibly((Handler)v8, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(org.otwebrtc.EglBase$Context int[] ), ()V)((EglRenderer)this, (EglBase.Context)var1_1, (int[])var2_2));
            v4.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            v5.resetStatistics(System.nanoTime());
            v6.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
lbl35:
            // 1 sources

            v10 = v11;
            v12 = v11;
            v10(this.name + "Already initialized");
            throw v12;
        }
    }

    public void init(@Nullable EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.init(context, nArray, glDrawer, false);
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        CountDownLatch countDownLatch;
        EglRenderer eglRenderer = this;
        eglRenderer.logD("Releasing.");
        Object object = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Object object2 = eglRenderer.handlerLock;
        synchronized (object2) {
            if (eglRenderer.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            EglRenderer eglRenderer2 = this;
            EglRenderer eglRenderer3 = eglRenderer2;
            EglRenderer eglRenderer4 = eglRenderer2;
            CountDownLatch countDownLatch2 = object;
            Object object3 = object2;
            EglRenderer eglRenderer5 = this;
            EglRenderer eglRenderer6 = eglRenderer5;
            EglRenderer eglRenderer7 = eglRenderer5;
            EglRenderer eglRenderer8 = eglRenderer5;
            eglRenderer5.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            eglRenderer5.renderThreadHandler.postAtFrontOfQueue(() -> this.a((CountDownLatch)object));
            {
                object = eglRenderer7.renderThreadHandler.getLooper();
                eglRenderer8.renderThreadHandler.post(() -> this.a((Looper)object));
            }
            {
                eglRenderer6.renderThreadHandler = null;
                // ** MonitorExit[v6] (shouldn't be in output)
            }
            ThreadUtils.awaitUninterruptibly(countDownLatch2);
            object = eglRenderer3.frameLock;
            synchronized (object) {
                if (eglRenderer4.pendingFrame != null) {
                    this.pendingFrame.release();
                    this.pendingFrame = null;
                }
                // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl39 : MonitorExitStatement: MONITOREXIT : var1_1
                this.logD("Releasing done.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            block13: {
                StackTraceElement[] stackTraceElementArray;
                block12: {
                    block11: {
                        if (eglRenderer.renderThreadHandler != null) break block11;
                        stackTraceElementArray = null;
                        break block12;
                    }
                    stackTraceElementArray = this.renderThreadHandler.getLooper().getThread();
                }
                if (stackTraceElementArray != null) {
                    stackTraceElementArray = stackTraceElementArray.getStackTrace();
                    if (stackTraceElementArray.length <= 0) break block13;
                    this.logW("EglRenderer stack trace:");
                    int n = stackTraceElementArray.length;
                    for (int i2 = 0; i2 < n; ++i2) {
                        this.logW(stackTraceElementArray[i2].toString());
                        continue;
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setMirrorHorizontally: " + bl);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.mirrorHorizontally = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirrorVertically(boolean bl) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setMirrorVertically: " + bl);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.mirrorVertically = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float f2) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setLayoutAspectRatio: " + f2);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setFpsReduction(float var1_1) {
        v0 = this;
        v0.logD("setFpsReduction: " + var1_1);
        var2_2 = v0.fpsReductionLock;
        synchronized (var2_2) {
            var3_3 = v0.minRenderPeriodNs;
            if (!(var1_1 <= 0.0f)) ** GOTO lbl13
            this.minRenderPeriodNs = 0x7FFFFFFFFFFFFFFFL;
            ** GOTO lbl17
lbl13:
            // 1 sources

            v2 = this;
            v3 = TimeUnit.SECONDS.toNanos(1L);
            v2.minRenderPeriodNs = (long)(v3 / var1_1);
lbl17:
            // 2 sources

            if (this.minRenderPeriodNs == var3_3) ** GOTO lbl20
            this.nextFrameTimeNs = System.nanoTime();
lbl20:
            // 2 sources

            return;
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener frameListener, float f2) {
        this.addFrameListener(frameListener, f2, null, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.addFrameListener(frameListener, f2, glDrawer, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, @Nullable RendererCommon.GlDrawer glDrawer, boolean bl) {
        EglRenderer eglRenderer = this;
        eglRenderer.postToRenderThread(() -> {
            if (glDrawer == null) {
                glDrawer = this.drawer;
            }
            this.frameListeners.add(new FrameListenerAndParams(frameListener, f2, glDrawer, bl));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFrameListener(FrameListener frameListener) {
        CountDownLatch countDownLatch;
        EglRenderer eglRenderer = this;
        CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            if (eglRenderer.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() != this.renderThreadHandler.getLooper().getThread()) {
                EglRenderer eglRenderer2 = this;
                eglRenderer2.postToRenderThread(() -> {
                    countDownLatch2.countDown();
                    Iterator<FrameListenerAndParams> iterator = ((EglRenderer)((Object)iterator)).frameListeners.iterator();
                    while (iterator.hasNext()) {
                        if (((FrameListenerAndParams)iterator.next()).listener != frameListener) continue;
                        iterator.remove();
                    }
                });
                // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                ThreadUtils.awaitUninterruptibly(countDownLatch2);
                return;
            }
            throw new RuntimeException("removeFrameListener must not be called on the render thread.");
        }
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onFrame(VideoFrame object) {
        EglRenderer eglRenderer = this;
        Object object2 = eglRenderer.statisticsLock;
        // MONITORENTER : object2
        ++this.framesReceived;
        // MONITOREXIT : object2
        Object object3 = eglRenderer.handlerLock;
        // MONITORENTER : object3
        if (eglRenderer.renderThreadHandler == null) {
            this.logD("Dropping frame - Not initialized or already released.");
            // MONITOREXIT : object3
            return;
        }
        EglRenderer eglRenderer2 = this;
        EglRenderer eglRenderer3 = eglRenderer2;
        object2 = eglRenderer2.frameLock;
        {
            catch (Throwable throwable) {
                // MONITOREXIT : object3
                throw throwable;
            }
        }
        boolean bl = eglRenderer3.pendingFrame != null;
        if (bl) {
            this.pendingFrame.release();
        }
        boolean bl2 = bl;
        Object object4 = object3;
        Object object5 = object2;
        this.pendingFrame = object;
        ((VideoFrame)object).retain();
        this.renderThreadHandler.post(this::renderFrameOnRenderThread);
        if (!bl2) return;
        object = this.statisticsLock;
        // MONITORENTER : object
        ++this.framesDropped;
        // MONITOREXIT : object
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object2
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void releaseEglSurface(Runnable var1_1) {
        v0 = this;
        v0.eglSurfaceCreationRunnable.setSurface(null);
        var2_2 = v0.handlerLock;
        synchronized (var2_2) {
            if (v0.renderThreadHandler == null) ** GOTO lbl18
            v2 = var2_2;
            v3 = this;
            v3.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
            v3.renderThreadHandler.postAtFrontOfQueue((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(java.lang.Runnable ), ()V)((EglRenderer)this, (Runnable)var1_1));
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
lbl18:
            // 1 sources

            // MONITOREXIT @DISABLED, blocks:[2, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
            var1_1.run();
            return;
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearImage(float f2, float f3, float f4, float f5) {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            if (eglRenderer.renderThreadHandler == null) {
                return;
            }
            Object object2 = object;
            this.renderThreadHandler.postAtFrontOfQueue(() -> this.clearSurfaceOnRenderThread(f2, f3, f4, f5));
            {
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }
    }

    private static class HandlerWithExceptionCallback
    extends Handler {
        private final Runnable exceptionCallback;

        public HandlerWithExceptionCallback(Looper looper, Runnable runnable) {
            super(looper);
            this.exceptionCallback = runnable;
        }

        public void dispatchMessage(Message object) {
            try {
                super.dispatchMessage(object);
                return;
            }
            catch (Exception exception) {
                object = exception;
                Logging.e(EglRenderer.TAG, "Exception on EglRenderer thread", (Throwable)object);
                this.exceptionCallback.run();
                throw exception;
            }
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object object) {
            this.surface = object;
        }

        @Override
        public synchronized void run() {
            block4: {
                if (this.surface == null || EglRenderer.this.eglBase == null || EglRenderer.this.eglBase.hasSurface()) break block4;
                Object object = this.surface;
                if (object instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else {
                    if (!(object instanceof SurfaceTexture)) {
                        throw new IllegalStateException("Invalid surface: " + this.surface);
                    }
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer, boolean bl) {
            this.listener = frameListener;
            this.scale = f2;
            this.drawer = glDrawer;
            this.applyFpsReduction = bl;
        }
    }

    public static interface ErrorCallback {
        public void onGlOutOfMemory();
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

