/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.content.Context;
import android.graphics.Matrix;
import android.view.WindowManager;
import org.otwebrtc.TextureBufferImpl;
import org.otwebrtc.VideoFrame;

interface CameraSession {
    public static int getDeviceOrientation(Context context) {
        int n = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return 0;
                }
                return 270;
            }
            return 180;
        }
        return 90;
    }

    public static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBufferImpl textureBufferImpl, boolean bl, int n) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        new Matrix().preTranslate(0.5f, 0.5f);
        if (bl) {
            matrix2.preScale(-1.0f, 1.0f);
        }
        TextureBufferImpl textureBufferImpl2 = textureBufferImpl;
        Matrix matrix3 = matrix2;
        matrix3.preRotate((float)n);
        matrix3.preTranslate(-0.5f, -0.5f);
        int n2 = textureBufferImpl2.getWidth();
        return textureBufferImpl.applyTransformMatrix(matrix2, n2, textureBufferImpl2.getHeight());
    }

    public void stop();

    public static interface Events {
        public void onCameraOpening();

        public void onCameraError(CameraSession var1, String var2);

        public void onCameraDisconnected(CameraSession var1);

        public void onCameraClosed(CameraSession var1);

        public void onFrameCaptured(CameraSession var1, VideoFrame var2);
    }

    public static interface CreateSessionCallback {
        public void onDone(CameraSession var1);

        public void onFailure(FailureType var1, String var2);
    }

    public static final class FailureType
    extends Enum<FailureType> {
        public static final /* enum */ FailureType ERROR;
        public static final /* enum */ FailureType DISCONNECTED;
        private static final /* synthetic */ FailureType[] $VALUES;

        public static FailureType[] values() {
            return (FailureType[])$VALUES.clone();
        }

        public static FailureType valueOf(String string) {
            return Enum.valueOf(FailureType.class, string);
        }

        static {
            FailureType failureType;
            ERROR = new FailureType();
            FailureType failureType2 = failureType;
            DISCONNECTED = new FailureType();
            $VALUES = new FailureType[]{ERROR, failureType2};
        }
    }
}

