/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.otwebrtc.Camera1Capturer;
import org.otwebrtc.CameraEnumerationAndroid;
import org.otwebrtc.CameraEnumerator;
import org.otwebrtc.CameraVideoCapturer;
import org.otwebrtc.Logging;
import org.otwebrtc.Size;

public class Camera1Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera1Enumerator";
    private static List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;
    private final boolean captureToTexture;

    public Camera1Enumerator() {
        this(true);
    }

    public Camera1Enumerator(boolean bl) {
        this.captureToTexture = bl;
    }

    @Nullable
    private static Camera.CameraInfo getCameraInfo(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
            return cameraInfo;
        }
        catch (Exception exception) {
            Logging.e(TAG, "getCameraInfo failed on index " + n, exception);
            return null;
        }
    }

    static synchronized List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n) {
        if (cachedSupportedFormats == null) {
            cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
            for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
                cachedSupportedFormats.add(Camera1Enumerator.enumerateFormats(i2));
            }
        }
        return cachedSupportedFormats.get(n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int n) {
        Throwable throwable222222;
        Object object;
        long l;
        block14: {
            List list;
            ArrayList arrayList;
            Object object2;
            block13: {
                Logging.d(TAG, "Get supported formats for camera index " + n + ".");
                l = SystemClock.elapsedRealtime();
                object = null;
                Logging.d(TAG, "Opening camera with index " + n);
                object = Camera.open((int)n);
                object2 = object.getParameters();
                if (object == null) break block13;
                object.release();
            }
            object = arrayList;
            arrayList = new ArrayList();
            int n2 = 0;
            int n3 = 0;
            try {
                list = object2.getSupportedPreviewFpsRange();
                if (list != null) {
                    List list2 = list;
                    int[] nArray = (int[])list2.get(list2.size() - 1);
                    n2 = nArray[0];
                    n3 = nArray[1];
                }
                object2 = object2.getSupportedPreviewSizes().iterator();
            }
            catch (Exception exception) {
                Logging.e(TAG, "getSupportedFormats() failed on camera index " + n, exception);
                break block14;
            }
            while (object2.hasNext()) {
                List list3 = list = (Camera.Size)object2.next();
                int n4 = ((Camera.Size)list3).width;
                object.add(new CameraEnumerationAndroid.CaptureFormat(n4, ((Camera.Size)list3).height, n2, n3));
            }
        }
        long l2 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n + " done. Time spent: " + (l2 - l) + " ms.");
        return object;
        {
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList2;
            block15: {
                ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList2;
                catch (Throwable throwable222222) {
                }
                catch (RuntimeException runtimeException) {}
                {
                    Logging.e(TAG, "Open camera failed on camera index " + n, runtimeException);
                }
                arrayList2 = arrayList2;
                {
                    arrayList2 = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
                    if (object == null) break block15;
                }
                object.release();
            }
            return arrayList2;
        }
        if (object != null) {
            object.release();
        }
        throw throwable222222;
    }

    static List<Size> convertSizes(List<Camera.Size> arrayList) {
        ArrayList<Size> arrayList2;
        ArrayList<Size> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<Size>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            Camera.Size size;
            Camera.Size size2 = size = (Camera.Size)iterator.next();
            int n = size2.width;
            arrayList.add(new Size(n, size2.height));
        }
        return arrayList;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(List<int[]> arrayList) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList2;
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (int[] nArray : arrayList3) {
            int n = nArray[0];
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(n, nArray[1]));
        }
        return arrayList;
    }

    static int getCameraIndex(String string) {
        Logging.d(TAG, "getCameraIndex: " + string);
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            if (!string.equals(Camera1Enumerator.getDeviceName(i2))) continue;
            return i2;
        }
        throw new IllegalArgumentException("No such camera: " + string);
    }

    @Nullable
    static String getDeviceName(int n) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(n);
        if (cameraInfo == null) {
            return null;
        }
        String string = cameraInfo.facing == 1 ? "front" : "back";
        return "Camera " + n + ", Facing " + string + ", Orientation " + cameraInfo.orientation;
    }

    @Override
    public String[] getDeviceNames() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            String string = Camera1Enumerator.getDeviceName(i2);
            if (string != null) {
                arrayList2.add(string);
                Logging.d(TAG, "Index: " + i2 + ". " + string);
                continue;
            }
            Logging.e(TAG, "Index: " + i2 + ". Failed to query camera name.");
        }
        ArrayList arrayList3 = arrayList2;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    @Override
    public boolean isFrontFacing(String string) {
        Camera1Enumerator camera1Enumerator = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string));
        return camera1Enumerator != null && ((Camera.CameraInfo)camera1Enumerator).facing == 1;
    }

    @Override
    public boolean isBackFacing(String string) {
        Camera1Enumerator camera1Enumerator = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string));
        return camera1Enumerator != null && ((Camera.CameraInfo)camera1Enumerator).facing == 0;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string) {
        return Camera1Enumerator.getSupportedFormats(Camera1Enumerator.getCameraIndex(string));
    }

    @Override
    public CameraVideoCapturer createCapturer(String string, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        boolean bl = this.captureToTexture;
        return new Camera1Capturer(string, cameraEventsHandler, bl);
    }
}

