/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.Camera2VideoCapturer;
import com.opentok.android.DefaultVideoCapturer;
import com.opentok.android.OtLog;
import com.opentok.android.Publisher;
import com.opentok.android.Session;

class VideoCaptureFactory {
    private static final OtLog.LogToken log;
    private static boolean camera2Enabled;

    VideoCaptureFactory() {
    }

    @SuppressLint(value={"LogNotTimber"})
    public static BaseVideoCapturer constructCapturer(Context context, Publisher.CameraCaptureResolution cameraCaptureResolution, Publisher.CameraCaptureFrameRate cameraCaptureFrameRate) {
        if (VideoCaptureFactory.isCamera2Capable()) {
            log.i("Using Camera2 Capturer", new Object[0]);
            return new Camera2VideoCapturer(context, cameraCaptureResolution, cameraCaptureFrameRate);
        }
        log.i("Using Camera Capturer", new Object[0]);
        return new DefaultVideoCapturer(context, cameraCaptureResolution, cameraCaptureFrameRate);
    }

    public static BaseVideoCapturer constructCapturer(Context context) {
        return VideoCaptureFactory.constructCapturer(context, Publisher.CameraCaptureResolution.defaultResolution(), Publisher.CameraCaptureFrameRate.defaultFrameRate());
    }

    public static void enableCamera2api(boolean bl) {
        camera2Enabled = bl;
    }

    private static boolean isCamera2Capable() {
        return camera2Enabled;
    }

    static {
        Session.SessionOptions sessionOptions;
        log = new OtLog.LogToken();
        camera2Enabled = false;
        Session.SessionOptions sessionOptions2 = sessionOptions;
        sessionOptions = new Session.SessionOptions(){};
        camera2Enabled = Build.VERSION.SDK_INT >= 21 && sessionOptions2.isCamera2Capable();
    }
}

