/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.opentok.android.AudioDeviceManager;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.BaseVideoRenderer;
import com.opentok.android.DefaultAudioDevice;
import com.opentok.android.Loader;
import com.opentok.android.OpenTokConfig;
import com.opentok.android.OpentokError;
import com.opentok.android.OtLog;
import com.opentok.android.Session;
import com.opentok.android.Stream;
import com.opentok.android.Utils;
import com.opentok.otc.SWIGTYPE_p_otc_publisher;
import com.opentok.otc.SWIGTYPE_p_otc_stream;
import com.opentok.otc.a;
import com.opentok.otc.e;
import com.opentok.otc.i;
import com.opentok.otc.otc_publisher_callbacks;
import com.opentok.otc.otc_publisher_rtc_stats_report_cb;
import com.opentok.otc.otc_video_capturer_callbacks;
import com.opentok.otc.otc_video_capturer_settings;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class PublisherKit
implements Observer {
    private static final Map<PublisherKitVideoType, i> OTCPublisherVideoTypeMap;
    private static final Map<i, PublisherKitVideoType> PublisherKitVideoTypeMap;
    protected Handler handler;
    protected PublisherListener publisherListener;
    protected AudioLevelListener audioLevelListener;
    protected VideoStatsListener videoStatsListener;
    protected AudioStatsListener audioStatsListener;
    protected PublisherRtcStatsReportListener rtcStatsReportListener;
    protected Context context;
    protected BaseVideoRenderer renderer;
    protected BaseVideoCapturer capturer;
    boolean resumePublishVideoOnSessionResume;
    boolean isPaused = false;
    SWIGTYPE_p_otc_publisher otc_publisher;
    swig_otc_publisher_cb publisher_cb;
    swig_otc_video_capturer_cb capturer_cb;
    swig_otc_rtc_stats_report_cb rtc_stats_report_cb;
    long otcCapturerHandle = 0L;
    private final OtLog.LogToken log;

    @Deprecated
    protected PublisherKit(Context context, String string, boolean bl, boolean bl2, BaseVideoCapturer baseVideoCapturer, BaseVideoRenderer baseVideoRenderer) {
        this(context, string, bl, 0, bl2, baseVideoCapturer, baseVideoRenderer);
    }

    protected PublisherKit(Context object, String string, boolean bl, int n, boolean bl2, BaseVideoCapturer baseVideoCapturer, BaseVideoRenderer baseVideoRenderer) {
        OtLog.LogToken logToken;
        Object object2 = logToken;
        logToken = new OtLog.LogToken(this);
        this.log = object2;
        if (object != null) {
            this.context = object;
            if (AudioDeviceManager.getAudioDevice() == null) {
                BaseAudioDevice.AudioBus audioBus;
                DefaultAudioDevice defaultAudioDevice;
                object2 = defaultAudioDevice;
                BaseAudioDevice.AudioBus audioBus2 = audioBus;
                audioBus = new BaseAudioDevice.AudioBus((BaseAudioDevice)object2);
                new DefaultAudioDevice((Context)object).setAudioBus(audioBus2);
                AudioDeviceManager.setAudioDevice((BaseAudioDevice)object2);
            }
            PublisherKit publisherKit = this;
            Utils.initOtcEngine(object, AudioDeviceManager.getAudioDevice(), OpenTokConfig.getJNILogs(), OpenTokConfig.getOTKitLogs(), OpenTokConfig.getWebRTCLogs(), OpenTokConfig.getDumpClientLoggingToFile());
            this.handler = new Handler(Looper.myLooper());
            this.renderer = baseVideoRenderer;
            publisherKit.capturer = baseVideoCapturer;
            publisherKit.publisher_cb = new swig_otc_publisher_cb(this.build_native_publisher_cb());
            publisherKit.capturer_cb = new swig_otc_video_capturer_cb(this.build_native_video_capturer_cb());
            object = e.b();
            e.a((a)object, Utils.booleanToInt(bl));
            e.b((a)object, Utils.booleanToInt(bl2));
            if (string == null) {
                string = "";
            }
            Object object3 = object;
            e.a((a)object, string);
            e.a((a)object, this.capturer_cb);
            object = e.a(this.publisher_cb, (a)object);
            this.otc_publisher = object;
            e.a((SWIGTYPE_p_otc_publisher)object, (long)n);
            e.a((a)object3);
            return;
        }
        throw new IllegalArgumentException("(Context context) is null, cannot create publisher object!");
    }

    @Deprecated
    public PublisherKit(Context context, String string, boolean bl, boolean bl2) {
        this(context, string, bl, 0, bl2, null, null);
    }

    @Deprecated
    public PublisherKit(Context context) {
        this(context, null, true, 0, true, null, null);
    }

    @Deprecated
    public PublisherKit(Context context, String string) {
        this(context, string, true, 0, true, null, null);
    }

    static {
        Loader.load();
        OTCPublisherVideoTypeMap = new HashMap<PublisherKitVideoType, i>(){
            {
                1 v0 = this;
                v0.put(PublisherKitVideoType.PublisherKitVideoTypeCamera, i.c);
                v0.put(PublisherKitVideoType.PublisherKitVideoTypeScreen, i.d);
            }
        };
        PublisherKitVideoTypeMap = new HashMap<i, PublisherKitVideoType>(){
            {
                2 v0 = this;
                v0.put(i.c, PublisherKitVideoType.PublisherKitVideoTypeCamera);
                v0.put(i.d, PublisherKitVideoType.PublisherKitVideoTypeScreen);
            }
        };
    }

    public void onPause() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onPause() called", new Object[0]);
        Object object = publisherKit.renderer;
        if (object != null) {
            ((BaseVideoRenderer)object).onPause();
        }
        if ((object = this.capturer) != null) {
            ((BaseVideoCapturer)object).onPause();
        }
        PublisherKit publisherKit2 = this;
        publisherKit2.resumePublishVideoOnSessionResume = publisherKit2.getPublishVideo();
        publisherKit2.setPublishVideo(false);
        publisherKit2.isPaused = true;
    }

    public void onResume() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onResume() called", new Object[0]);
        if (publisherKit.isPaused) {
            this.isPaused = false;
            Object object = this.renderer;
            if (object != null) {
                ((BaseVideoRenderer)object).onResume();
            }
            if ((object = this.capturer) != null) {
                ((BaseVideoCapturer)object).onResume();
            }
            PublisherKit publisherKit2 = this;
            publisherKit2.setPublishVideo(publisherKit2.resumePublishVideoOnSessionResume);
        }
    }

    @Deprecated
    public void destroy() {
        this.log.d("Destroy(...) called", new Object[0]);
    }

    public void setPublishVideo(boolean bl) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("setPublishVideo(" + bl + ") called", new Object[0]);
        e.c(publisherKit.otc_publisher, Utils.booleanToInt(bl));
    }

    public void setPublishAudio(boolean bl) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("setPublishAudio(" + bl + ") called", new Object[0]);
        e.b(publisherKit.otc_publisher, Utils.booleanToInt(bl));
    }

    @Deprecated
    public void setName(String string) {
    }

    public void setPublisherVideoType(PublisherKitVideoType publisherKitVideoType) {
        e.a(this.otc_publisher, OTCPublisherVideoTypeMap.get((Object)publisherKitVideoType));
    }

    public String getName() {
        return e.c(this.otc_publisher);
    }

    public boolean getPublishVideo() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("getPublishVideo() called", new Object[0]);
        return Utils.intToBoolean(e.e(publisherKit.otc_publisher));
    }

    public boolean getPublishAudio() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("getPublishAudio() called", new Object[0]);
        return Utils.intToBoolean(e.d(publisherKit.otc_publisher));
    }

    public Session getSession() {
        return new Session(e.g(this.otc_publisher), false);
    }

    public Stream getStream() {
        Object object;
        Object object2 = e.h(((PublisherKit)object2).otc_publisher);
        if (object2 == null) {
            object = object2 = null;
        } else {
            Stream stream;
            object = stream;
            stream = new Stream((SWIGTYPE_p_otc_stream)object2, false);
        }
        return object;
    }

    public PublisherKitVideoType getPublisherVideoType() {
        return PublisherKitVideoTypeMap.get(e.i(this.otc_publisher));
    }

    public void setPublisherListener(PublisherListener publisherListener) {
        this.publisherListener = publisherListener;
    }

    public void setAudioLevelListener(AudioLevelListener audioLevelListener) {
        this.audioLevelListener = audioLevelListener;
    }

    public void setRtcStatsReportListener(PublisherRtcStatsReportListener object) {
        swig_otc_rtc_stats_report_cb swig_otc_rtc_stats_report_cb2;
        PublisherRtcStatsReportListener publisherRtcStatsReportListener = object;
        object = swig_otc_rtc_stats_report_cb2;
        this.rtc_stats_report_cb = new swig_otc_rtc_stats_report_cb(this.build_rtc_stats_report_cb());
        e.a(this.otc_publisher, (otc_publisher_rtc_stats_report_cb)object);
        this.rtcStatsReportListener = publisherRtcStatsReportListener;
    }

    public void setStyle(String string, String string2) {
        BaseVideoRenderer baseVideoRenderer = ((PublisherKit)((Object)baseVideoRenderer)).renderer;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.setStyle(string, string2);
        }
    }

    @Deprecated
    public void setRenderer(BaseVideoRenderer baseVideoRenderer) {
    }

    public BaseVideoRenderer getRenderer() {
        return this.renderer;
    }

    public BaseVideoCapturer getCapturer() {
        return this.capturer;
    }

    @Deprecated
    public void setCapturer(BaseVideoCapturer baseVideoCapturer) {
    }

    public View getView() {
        if (this.getRenderer() != null) {
            return this.renderer.getView();
        }
        return null;
    }

    public void setVideoStatsListener(VideoStatsListener videoStatsListener) {
        this.videoStatsListener = videoStatsListener;
    }

    public void setAudioStatsListener(AudioStatsListener audioStatsListener) {
        this.audioStatsListener = audioStatsListener;
    }

    public void setAudioFallbackEnabled(boolean bl) {
        e.a(this.otc_publisher, Utils.booleanToInt(bl));
    }

    public boolean getAudioFallbackEnabled() {
        return Utils.intToBoolean(e.b(this.otc_publisher));
    }

    public void getRtcStatsReport() {
        e.f(this.otc_publisher);
    }

    void throwError(OpentokError opentokError) {
        this.onErrorJNI(opentokError.errorMessage, opentokError.errorCode.ordinal());
    }

    protected void onRtcStatsReport(PublisherRtcStats[] publisherRtcStatsArray) {
    }

    void onRtcStatsReportsJNI(String[] stringArray, String[] stringArray2) {
        this.log.d("onRtcStatsReportsJNI(...) called", new Object[0]);
        if (stringArray.length == 0) {
            this.log.e("onRtcStatsReportsJNI called with empty reports", new Object[0]);
            return;
        }
        PublisherRtcStats[] publisherRtcStatsArray = new PublisherRtcStats[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            PublisherRtcStats publisherRtcStats;
            PublisherRtcStats publisherRtcStats2 = publisherRtcStats;
            publisherRtcStats = new PublisherRtcStats();
            publisherRtcStatsArray[i2] = publisherRtcStats2;
            publisherRtcStatsArray[i2].jsonArrayOfReports = stringArray[i2];
            publisherRtcStatsArray[i2].connectionId = stringArray2[i2];
        }
        PublisherKit publisherKit = this;
        publisherKit.handler.post(() -> this.onRtcStatsReport(publisherRtcStatsArray));
        if (publisherKit.rtcStatsReportListener != null) {
            this.handler.post(() -> {
                PublisherRtcStatsReportListener publisherRtcStatsReportListener = this.rtcStatsReportListener;
                if (publisherRtcStatsReportListener != null) {
                    publisherRtcStatsReportListener.onRtcStatsReport(this, publisherRtcStatsArray);
                }
            });
        }
    }

    protected void onStreamCreated(Stream stream) {
    }

    void onStreamCreatedJNI(long l) {
        Stream stream;
        PublisherKit publisherKit = this;
        publisherKit.log.d("onStreamCreated(...) called", new Object[0]);
        Stream stream2 = stream;
        stream = new Stream(l, true);
        publisherKit.handler.post(() -> this.onStreamCreated(stream2));
        if (publisherKit.publisherListener != null) {
            this.handler.post(() -> {
                PublisherListener publisherListener = this.publisherListener;
                if (publisherListener != null) {
                    publisherListener.onStreamCreated(this, stream2);
                }
            });
        }
    }

    protected void onStreamDestroyed(Stream stream) {
    }

    void onStreamDestroyedJNI(long l) {
        Stream stream;
        PublisherKit publisherKit = this;
        publisherKit.log.d("onStreamDestroyed(...) called", new Object[0]);
        Stream stream2 = stream;
        stream = new Stream(l, true);
        publisherKit.handler.post(() -> this.onStreamDestroyed(stream2));
        if (publisherKit.publisherListener != null) {
            this.handler.post(() -> {
                PublisherListener publisherListener = this.publisherListener;
                if (publisherListener != null) {
                    publisherListener.onStreamDestroyed(this, stream2);
                }
            });
        }
    }

    protected void onError(OpentokError opentokError) {
    }

    void onErrorJNI(String string, int n) {
        OpentokError opentokError;
        PublisherKit publisherKit = this;
        OpentokError opentokError2 = opentokError;
        opentokError = new OpentokError(OpentokError.Domain.PublisherErrorDomain, n, string);
        publisherKit.handler.post(() -> this.onError(opentokError2));
        if (publisherKit.publisherListener != null) {
            this.handler.post(() -> {
                PublisherListener publisherListener = this.publisherListener;
                if (publisherListener != null) {
                    publisherListener.onError(this, opentokError2);
                }
            });
        }
    }

    protected void onAudioLevelUpdated(float f2) {
    }

    void onAudioLevelUpdatedJNI(float f2) {
        PublisherKit publisherKit = this;
        publisherKit.handler.post(() -> this.onAudioLevelUpdated(f2));
        if (publisherKit.audioLevelListener != null) {
            this.handler.post(() -> {
                AudioLevelListener audioLevelListener = this.audioLevelListener;
                if (audioLevelListener != null) {
                    audioLevelListener.onAudioLevelUpdated(this, f2);
                }
            });
        }
    }

    SWIGTYPE_p_otc_publisher getOtcPublisher() {
        return this.otc_publisher;
    }

    boolean onCaptureInitJNI(long l) {
        this.log.d("onCaptureInit(...) called", new Object[0]);
        this.otcCapturerHandle = l;
        if (this.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.init();
                }
            });
        }
        return true;
    }

    boolean onCaptureDestroyJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureDestroy(...) called", new Object[0]);
        publisherKit.otcCapturerHandle = 0L;
        if (publisherKit.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.destroy();
                }
            });
        }
        return true;
    }

    boolean onCaptureStartJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureStart(...) called", new Object[0]);
        if (publisherKit.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.startCapture();
                }
            });
        }
        return true;
    }

    boolean onCaptureStopJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureStop(...) called", new Object[0]);
        if (publisherKit.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.stopCapture();
                }
            });
        }
        return true;
    }

    boolean onCaptureSettingsJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureSettings(...) called", new Object[0]);
        if (publisherKit.capturer != null) {
            new swig_otc_video_capturer_settings(l, false).updateValuesWithSettings(this.capturer.getCaptureSettings());
            return true;
        }
        return false;
    }

    void onFrameJNI(long l) {
        Object object = this.renderer;
        if (object != null) {
            object = ((BaseVideoRenderer)object).buildFrameInstance();
            ((BaseVideoRenderer.Frame)object).copyOtcFrame(l, this.capturer.getCaptureSettings().mirrorInLocalRender);
            this.renderer.onFrame((BaseVideoRenderer.Frame)object);
        }
    }

    void onAudioStatsJNI(PublisherAudioStats[] publisherAudioStatsArray) {
        if (this.audioStatsListener != null) {
            this.handler.post(() -> {
                AudioStatsListener audioStatsListener = this.audioStatsListener;
                if (audioStatsListener != null) {
                    audioStatsListener.onAudioStats(this, publisherAudioStatsArray);
                }
            });
        }
    }

    void onVideoStatsJNI(PublisherVideoStats[] publisherVideoStatsArray) {
        if (this.videoStatsListener != null) {
            this.handler.post(() -> {
                VideoStatsListener videoStatsListener = this.videoStatsListener;
                if (videoStatsListener != null) {
                    videoStatsListener.onVideoStats(this, publisherVideoStatsArray);
                }
            });
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(observable instanceof Session)) {
            return;
        }
        if (!(object instanceof Session.SessionPauseResumeEvent)) {
            return;
        }
        if (((Session.SessionPauseResumeEvent)object).isSessionPaused()) {
            this.onPause();
        } else {
            this.onResume();
        }
    }

    protected void finalize() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("finalize()", new Object[0]);
        Object object = publisherKit.otc_publisher;
        if (object != null) {
            e.a((SWIGTYPE_p_otc_publisher)object);
            this.otc_publisher = null;
            object = this.publisher_cb;
            if (object != null && this.capturer_cb != null) {
                PublisherKit publisherKit2 = this;
                long l = publisherKit2.capturer_cb.getCPointer();
                long l2 = publisherKit2.rtc_stats_report_cb.getCPointer();
                this.destroy_native_publisher_cbs(((swig_otc_publisher_cb)object).getCPointer(), l, l2);
            }
        }
        super.finalize();
    }

    public void onStop() {
        if ((this = ((PublisherKit)this).getCapturer()) != null) {
            ((BaseVideoCapturer)this).onStop();
        }
    }

    public void onRestart() {
        if ((this = ((PublisherKit)this).getCapturer()) != null) {
            ((BaseVideoCapturer)this).onRestart();
        }
    }

    native long build_native_publisher_cb();

    native long build_native_video_capturer_cb();

    native long build_rtc_stats_report_cb();

    native void destroy_native_publisher_cbs(long var1, long var3, long var5);

    static class swig_otc_rtc_stats_report_cb
    extends otc_publisher_rtc_stats_report_cb {
        public swig_otc_rtc_stats_report_cb(long l) {
            super(l, true);
        }

        public long getCPointer() {
            return otc_publisher_rtc_stats_report_cb.getCPtr(this);
        }
    }

    static class swig_otc_video_capturer_settings
    extends otc_video_capturer_settings {
        public swig_otc_video_capturer_settings(long l, boolean bl) {
            super(l, bl);
        }

        public void updateValuesWithSettings(BaseVideoCapturer.CaptureSettings captureSettings) {
            this.setExpected_delay(captureSettings.expectedDelay);
            this.setFormat(captureSettings.format);
            this.setFps(captureSettings.fps);
            this.setHeight(captureSettings.height);
            this.setWidth(captureSettings.width);
            this.setMirror_on_local_render(Utils.booleanToInt(captureSettings.mirrorInLocalRender));
        }
    }

    static class swig_otc_video_capturer_cb
    extends otc_video_capturer_callbacks {
        public swig_otc_video_capturer_cb(long l) {
            super(l, true);
        }

        public long getCPointer() {
            return otc_video_capturer_callbacks.getCPtr(this);
        }
    }

    static class swig_otc_publisher_cb
    extends otc_publisher_callbacks {
        public swig_otc_publisher_cb(long l) {
            super(l, true);
        }

        public long getCPointer() {
            return otc_publisher_callbacks.getCPtr(this);
        }
    }

    public static class Builder {
        Context context;
        String name;
        boolean audioTrack = true;
        boolean videoTrack = true;
        BaseVideoCapturer capturer = null;
        BaseVideoRenderer renderer = null;
        int audioBitrate;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder name(String string) {
            this.name = string;
            return this;
        }

        public Builder audioTrack(boolean bl) {
            this.audioTrack = bl;
            return this;
        }

        public Builder videoTrack(boolean bl) {
            this.videoTrack = bl;
            return this;
        }

        public Builder capturer(BaseVideoCapturer baseVideoCapturer) {
            this.capturer = baseVideoCapturer;
            return this;
        }

        public Builder renderer(BaseVideoRenderer baseVideoRenderer) {
            this.renderer = baseVideoRenderer;
            return this;
        }

        public Builder audioBitrate(int n) {
            this.audioBitrate = n;
            return this;
        }

        public PublisherKit build() {
            Builder builder = builder2;
            Builder builder2 = builder.context;
            String string = builder.name;
            boolean bl = builder.audioTrack;
            int n = builder.audioBitrate;
            boolean bl2 = builder.videoTrack;
            BaseVideoCapturer baseVideoCapturer = builder.capturer;
            BaseVideoRenderer baseVideoRenderer = builder.renderer;
            return new PublisherKit((Context)builder2, string, bl, n, bl2, baseVideoCapturer, baseVideoRenderer);
        }
    }

    public static interface AudioStatsListener {
        public void onAudioStats(PublisherKit var1, PublisherAudioStats[] var2);
    }

    public static interface VideoStatsListener {
        public void onVideoStats(PublisherKit var1, PublisherVideoStats[] var2);
    }

    public static class PublisherAudioStats {
        public String connectionId;
        public String subscriberId;
        public long audioPacketsLost;
        public long audioPacketsSent;
        public long audioBytesSent;
        public double timeStamp;
        public double startTime;

        PublisherAudioStats(String string, String string2, long l, long l2, long l3, double d2, double d3) {
            this.connectionId = string;
            this.subscriberId = string2;
            this.audioPacketsLost = l;
            this.audioPacketsSent = l2;
            this.audioBytesSent = l3;
            this.timeStamp = d2;
            this.startTime = d3;
        }
    }

    public static class PublisherVideoStats {
        public String connectionId;
        public String subscriberId;
        public long videoPacketsLost;
        public long videoPacketsSent;
        public long videoBytesSent;
        public double timeStamp;
        public double startTime;

        PublisherVideoStats(String string, String string2, long l, long l2, long l3, double d2, double d3) {
            this.connectionId = string;
            this.subscriberId = string2;
            this.videoPacketsLost = l;
            this.videoPacketsSent = l2;
            this.videoBytesSent = l3;
            this.timeStamp = d2;
            this.startTime = d3;
        }
    }

    public static interface AudioLevelListener {
        public void onAudioLevelUpdated(PublisherKit var1, float var2);
    }

    public static interface PublisherRtcStatsReportListener {
        public void onRtcStatsReport(PublisherKit var1, PublisherRtcStats[] var2);
    }

    public static class PublisherRtcStats {
        public String connectionId;
        public String jsonArrayOfReports;
    }

    public static interface PublisherListener {
        public void onStreamCreated(PublisherKit var1, Stream var2);

        public void onStreamDestroyed(PublisherKit var1, Stream var2);

        public void onError(PublisherKit var1, OpentokError var2);
    }

    public static final class PublisherKitVideoType
    extends Enum<PublisherKitVideoType> {
        public static final /* enum */ PublisherKitVideoType PublisherKitVideoTypeCamera;
        public static final /* enum */ PublisherKitVideoType PublisherKitVideoTypeScreen;
        private static final /* synthetic */ PublisherKitVideoType[] $VALUES;
        private int videoType;

        public static PublisherKitVideoType[] values() {
            return (PublisherKitVideoType[])$VALUES.clone();
        }

        public static PublisherKitVideoType valueOf(String string) {
            return Enum.valueOf(PublisherKitVideoType.class, string);
        }

        private PublisherKitVideoType(int n2) {
            this.videoType = n2;
        }

        static PublisherKitVideoType fromType(int n) {
            for (PublisherKitVideoType publisherKitVideoType : PublisherKitVideoType.values()) {
                if (publisherKitVideoType.getVideoType() != n) continue;
                return publisherKitVideoType;
            }
            throw new IllegalArgumentException("unknown type " + n);
        }

        static {
            PublisherKitVideoType publisherKitVideoType;
            PublisherKitVideoTypeCamera = new PublisherKitVideoType(1);
            PublisherKitVideoType publisherKitVideoType2 = publisherKitVideoType;
            PublisherKitVideoTypeScreen = new PublisherKitVideoType(2);
            $VALUES = new PublisherKitVideoType[]{PublisherKitVideoTypeCamera, publisherKitVideoType2};
        }

        public int getVideoType() {
            return this.videoType;
        }
    }
}

