/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.BaseVideoRenderer;
import com.opentok.android.Camera2VideoCapturer;
import com.opentok.android.OpentokError;
import com.opentok.android.OtLog;
import com.opentok.android.PublisherKit;
import com.opentok.android.VideoCaptureFactory;
import com.opentok.android.VideoRenderFactory;

public class Publisher
extends PublisherKit {
    private final OtLog.LogToken log;
    protected CameraCaptureFrameRate cameraFrameRate;
    protected CameraCaptureResolution cameraResolution;
    protected CameraListener cameraListener;

    @Deprecated
    public Publisher(Context context) {
        this(context, null, true, 0, true, null, null, null, null);
    }

    @Deprecated
    public Publisher(Context context, String string) {
        this(context, string, true, 0, true, null, null, null, null);
    }

    @Deprecated
    public Publisher(Context context, String string, BaseVideoCapturer baseVideoCapturer) {
        this(context, string, true, 0, true, baseVideoCapturer, null, null, null);
    }

    @Deprecated
    public Publisher(Context context, String string, boolean bl, boolean bl2) {
        this(context, string, bl, 0, bl2, null, null, null, null);
    }

    @Deprecated
    public Publisher(Context context, String string, CameraCaptureResolution cameraCaptureResolution, CameraCaptureFrameRate cameraCaptureFrameRate) {
        this(context, string, true, 0, true, null, cameraCaptureResolution, cameraCaptureFrameRate, null);
    }

    @Deprecated
    protected Publisher(Context context, String string, boolean bl, boolean bl2, BaseVideoCapturer baseVideoCapturer, CameraCaptureResolution cameraCaptureResolution, CameraCaptureFrameRate cameraCaptureFrameRate, BaseVideoRenderer baseVideoRenderer) {
        this(context, string, bl, 0, bl2, baseVideoCapturer, cameraCaptureResolution, cameraCaptureFrameRate, baseVideoRenderer);
    }

    protected Publisher(Context context, String string, boolean bl, int n, boolean bl2, BaseVideoCapturer baseVideoCapturer, CameraCaptureResolution cameraCaptureResolution, CameraCaptureFrameRate cameraCaptureFrameRate, BaseVideoRenderer baseVideoRenderer) {
        if (baseVideoCapturer == null && context != null) {
            if (cameraCaptureResolution == null) {
                cameraCaptureResolution = CameraCaptureResolution.defaultResolution();
            }
            if (cameraCaptureFrameRate == null) {
                cameraCaptureFrameRate = CameraCaptureFrameRate.defaultFrameRate();
            }
            baseVideoCapturer = VideoCaptureFactory.constructCapturer(context, cameraCaptureResolution, cameraCaptureFrameRate);
        }
        if (baseVideoRenderer == null && context != null) {
            baseVideoRenderer = VideoRenderFactory.constructRenderer(context);
        }
        Publisher publisher = this;
        super(context, string, bl, n, bl2, baseVideoCapturer, baseVideoRenderer);
        publisher.log = new OtLog.LogToken(this);
        publisher.getCapturer().setPublisherKit(this);
    }

    public void setCameraListener(CameraListener cameraListener) {
        this.cameraListener = cameraListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void setCameraId(int n) {
        Object object = this.getCapturer();
        if (object == null) {
            Publisher publisher = this;
            publisher.log.e("setCameraId() Capturer is not initialized yet.", new Object[0]);
            publisher.onCameraError(new OpentokError(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.VideoCaptureFailed.getErrorCode(), "setCameraId() Capturer is not initialized yet."));
            return;
        }
        try {
            object = (BaseVideoCapturer.CaptureSwitch)object;
            if (object == null) {
                Publisher publisher = this;
                String string = "setCameraId() captureSwitch object is null";
                publisher.log.e(string, new Object[0]);
                publisher.onCameraError(new OpentokError(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.VideoCaptureFailed.getErrorCode(), string));
                return;
            }
            Publisher publisher = this;
            object.swapCamera(n);
            publisher.onPublisherCameraPositionChanged(publisher, n);
            return;
        }
        catch (ClassCastException classCastException) {
            this.log.e("setCameraId() BaseVideoCapturer.CaptureSwitch interface not implemented", new Object[0]);
            this.onCameraError(classCastException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cycleCamera() {
        Object object = this.getCapturer();
        if (object == null) {
            Publisher publisher = this;
            publisher.log.e("cycleCamera() Capturer is not initialized yet.", new Object[0]);
            publisher.onCameraError(new OpentokError(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.VideoCaptureFailed.getErrorCode(), "cycleCamera() Capturer is not initialized yet."));
            return;
        }
        try {
            object = (BaseVideoCapturer.CaptureSwitch)object;
            if (object == null) {
                Publisher publisher = this;
                object = "cycleCamera() captureSwitch object is null";
                publisher.log.e((String)object, new Object[0]);
                publisher.onCameraError(new OpentokError(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.VideoCaptureFailed.getErrorCode(), (String)object));
                return;
            }
            Publisher publisher = this;
            Object object2 = object;
            object2.cycleCamera();
            publisher.onPublisherCameraPositionChanged(publisher, object2.getCameraIndex());
            return;
        }
        catch (RuntimeException runtimeException) {
            this.log.e(runtimeException.getMessage(), new Object[0]);
            this.onCameraError(runtimeException);
            return;
        }
        catch (Camera2VideoCapturer.Camera2Exception camera2Exception) {
            this.log.e(camera2Exception.getMessage(), new Object[0]);
            this.onCameraError(camera2Exception);
            return;
        }
        catch (ClassCastException classCastException) {
            this.log.e("cycleCamera() BaseVideoCapturer.CaptureSwitch interface not implemented", new Object[0]);
            this.onCameraError(classCastException);
        }
    }

    @Deprecated
    public void swapCamera() {
        if (this.getCapturer() == null) {
            Publisher publisher = this;
            publisher.log.e("swapCamera() Capturer is not initialized yet.", new Object[0]);
            publisher.onCameraError(new OpentokError(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.VideoCaptureFailed.getErrorCode(), "swapCamera() Capturer is not initialized yet."));
            return;
        }
        this.cycleCamera();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public int getCameraId() {
        int n = -1;
        Object object = this.getCapturer();
        if (object == null) {
            this.log.e("getCameraId() Capturer is not initialized yet.", new Object[0]);
            return n;
        }
        object = (BaseVideoCapturer.CaptureSwitch)object;
        if (object != null) return object.getCameraIndex();
        int n2 = n;
        OtLog.LogToken logToken = this.log;
        try {
            logToken.e("getCameraId() captureSwitch object is null", new Object[0]);
            return n2;
        }
        catch (ClassCastException classCastException) {
            this.log.e("getCameraId() BaseVideoCapturer.CaptureSwitch interface not implemented", new Object[0]);
        }
        return n;
    }

    void onPublisherCameraPositionChanged(Publisher objectArray, int n) {
        Publisher publisher = this;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = n;
        publisher.log.d("onPublisherCameraPositionChanged() Publisher has changed the camera position to: %d", objectArray);
        publisher.handler.post(() -> this.onCameraChanged(n));
    }

    protected void onCameraChanged(int n) {
        CameraListener cameraListener = this.cameraListener;
        if (cameraListener != null) {
            cameraListener.onCameraChanged(this, n);
        }
    }

    void onCameraError(Exception exception) {
        this.onCameraError(new OpentokError(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.CameraFailed.getErrorCode(), exception));
    }

    protected void onCameraError(OpentokError opentokError) {
        Publisher publisher = this;
        publisher.log.d("onCameraError() Camera device has failed: " + opentokError.errorMessage, new Object[0]);
        if (publisher.cameraListener != null) {
            this.handler.post(() -> {
                CameraListener cameraListener = this.cameraListener;
                if (cameraListener != null) {
                    cameraListener.onCameraError(this, opentokError);
                }
            });
        }
    }

    @Deprecated
    public void startPreview() {
    }

    public static class Builder
    extends PublisherKit.Builder {
        CameraCaptureResolution resolution = null;
        CameraCaptureFrameRate frameRate = null;

        public Builder(Context context) {
            super(context);
        }

        public Builder resolution(CameraCaptureResolution cameraCaptureResolution) {
            this.resolution = cameraCaptureResolution;
            return this;
        }

        public Builder frameRate(CameraCaptureFrameRate cameraCaptureFrameRate) {
            this.frameRate = cameraCaptureFrameRate;
            return this;
        }

        @Override
        public Builder name(String string) {
            this.name = string;
            return this;
        }

        @Override
        public Builder audioTrack(boolean bl) {
            this.audioTrack = bl;
            return this;
        }

        @Override
        public Builder videoTrack(boolean bl) {
            this.videoTrack = bl;
            return this;
        }

        @Override
        public Builder capturer(BaseVideoCapturer baseVideoCapturer) {
            this.capturer = baseVideoCapturer;
            return this;
        }

        @Override
        public Builder renderer(BaseVideoRenderer baseVideoRenderer) {
            this.renderer = baseVideoRenderer;
            return this;
        }

        @Override
        public Builder audioBitrate(int n) {
            return (Builder)super.audioBitrate(n);
        }

        @Override
        public Publisher build() {
            Builder builder = builder2;
            Builder builder2 = builder.context;
            String string = builder.name;
            boolean bl = builder.audioTrack;
            int n = builder.audioBitrate;
            boolean bl2 = builder.videoTrack;
            BaseVideoCapturer baseVideoCapturer = builder.capturer;
            CameraCaptureResolution cameraCaptureResolution = builder.resolution;
            CameraCaptureFrameRate cameraCaptureFrameRate = builder.frameRate;
            BaseVideoRenderer baseVideoRenderer = builder.renderer;
            return new Publisher((Context)builder2, string, bl, n, bl2, baseVideoCapturer, cameraCaptureResolution, cameraCaptureFrameRate, baseVideoRenderer);
        }
    }

    public static interface CameraListener {
        public void onCameraChanged(Publisher var1, int var2);

        public void onCameraError(Publisher var1, OpentokError var2);
    }

    public static final class CameraCaptureFrameRate
    extends Enum<CameraCaptureFrameRate> {
        public static final /* enum */ CameraCaptureFrameRate FPS_30;
        public static final /* enum */ CameraCaptureFrameRate FPS_15;
        public static final /* enum */ CameraCaptureFrameRate FPS_7;
        public static final /* enum */ CameraCaptureFrameRate FPS_1;
        private static final /* synthetic */ CameraCaptureFrameRate[] $VALUES;
        private int captureFramerate;

        public static CameraCaptureFrameRate[] values() {
            return (CameraCaptureFrameRate[])$VALUES.clone();
        }

        public static CameraCaptureFrameRate valueOf(String string) {
            return Enum.valueOf(CameraCaptureFrameRate.class, string);
        }

        private CameraCaptureFrameRate(int n2) {
            this.captureFramerate = n2;
        }

        static CameraCaptureFrameRate fromFramerate(int n) {
            for (CameraCaptureFrameRate cameraCaptureFrameRate : CameraCaptureFrameRate.values()) {
                if (cameraCaptureFrameRate.getCaptureFrameRate() != n) continue;
                return cameraCaptureFrameRate;
            }
            throw new IllegalArgumentException("unknown capture framerate " + n);
        }

        static CameraCaptureFrameRate defaultFrameRate() {
            return FPS_30;
        }

        static {
            CameraCaptureFrameRate cameraCaptureFrameRate;
            FPS_30 = new CameraCaptureFrameRate(0);
            FPS_15 = new CameraCaptureFrameRate(1);
            FPS_7 = new CameraCaptureFrameRate(2);
            CameraCaptureFrameRate cameraCaptureFrameRate2 = cameraCaptureFrameRate;
            FPS_1 = new CameraCaptureFrameRate(3);
            $VALUES = new CameraCaptureFrameRate[]{FPS_30, FPS_15, FPS_7, cameraCaptureFrameRate2};
        }

        int getCaptureFrameRate() {
            return this.captureFramerate;
        }
    }

    public static final class CameraCaptureResolution
    extends Enum<CameraCaptureResolution> {
        public static final /* enum */ CameraCaptureResolution LOW;
        public static final /* enum */ CameraCaptureResolution MEDIUM;
        public static final /* enum */ CameraCaptureResolution HIGH;
        private static final /* synthetic */ CameraCaptureResolution[] $VALUES;
        private int captureResolution;

        public static CameraCaptureResolution[] values() {
            return (CameraCaptureResolution[])$VALUES.clone();
        }

        public static CameraCaptureResolution valueOf(String string) {
            return Enum.valueOf(CameraCaptureResolution.class, string);
        }

        private CameraCaptureResolution(int n2) {
            this.captureResolution = n2;
        }

        static CameraCaptureResolution fromResolution(int n) {
            for (CameraCaptureResolution cameraCaptureResolution : CameraCaptureResolution.values()) {
                if (cameraCaptureResolution.getCaptureResolution() != n) continue;
                return cameraCaptureResolution;
            }
            throw new IllegalArgumentException("unknown capture resolution " + n);
        }

        static CameraCaptureResolution defaultResolution() {
            return MEDIUM;
        }

        static {
            CameraCaptureResolution cameraCaptureResolution;
            LOW = new CameraCaptureResolution(0);
            MEDIUM = new CameraCaptureResolution(1);
            CameraCaptureResolution cameraCaptureResolution2 = cameraCaptureResolution;
            HIGH = new CameraCaptureResolution(2);
            $VALUES = new CameraCaptureResolution[]{LOW, MEDIUM, cameraCaptureResolution2};
        }

        int getCaptureResolution() {
            return this.captureResolution;
        }
    }
}

