/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.util.Pair;
import android.util.SparseArray;
import android.view.Surface;
import androidx.annotation.Keep;
import com.opentok.android.MediaCodecVideoEncoder;
import com.opentok.android.OtLog;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.SurfaceTextureHelper61;
import org.otwebrtc.ThreadUtils;

@Keep
class MediaCodecVideoDecoder {
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final OtLog.LogToken log;
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance;
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwDecoderDisabledTypes;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final SupportedDecoderRecord[] VP8_SUPPORT;
    private static final SupportedDecoderRecord[] VP9_SUPPORT;
    private static final SupportedDecoderRecord[] H264_SUPPORT;
    private static final SparseArray<Pair<String, SupportedDecoderRecord[]>> SupportedDecoderTbl;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList;
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs;
    private boolean useSurface;
    private TextureListener textureListener;
    private int droppedFrames;
    private Surface surface;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers;

    MediaCodecVideoDecoder() {
        LinkedList linkedList;
        LinkedList linkedList2;
        Object object = linkedList2;
        linkedList2 = new LinkedList();
        v1.decodeStartTimeMs = object;
        v1.surface = null;
        object = linkedList;
        linkedList = new LinkedList();
        v1.dequeuedSurfaceOutputBuffers = object;
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        log.d("Set error callback", new Object[0]);
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        log.w("VP8 decoding is disabled by application.", new Object[0]);
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        log.w("VP9 decoding is disabled by application.", new Object[0]);
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        log.w("H.264 decoding is disabled by application.", new Object[0]);
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, VP8_SUPPORT).length > 0;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, VP9_SUPPORT).length > 0;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, H264_SUPPORT).length > 0;
    }

    public static boolean isH264HighProfileHwSupported() {
        DecoderProperties[] decoderPropertiesArray = MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, H264_SUPPORT);
        return decoderPropertiesArray.length > 0 && decoderPropertiesArray[0].meta.containsKey("HighProfile") && Build.VERSION.SDK_INT >= decoderPropertiesArray[0].meta.get("HighProfile");
    }

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            log.d("MediaCodecVideoDecoder stacks trace:", new Object[0]);
            int n = ((StackTraceElement[])object).length;
            for (int i2 = 0; i2 < n; ++i2) {
                log.d(object[i2].toString(), new Object[0]);
            }
        }
    }

    private static MediaCodecInfo[] getCodecList() {
        Vector<MediaCodecInfo> vector;
        if (Build.VERSION.SDK_INT < 19) {
            return new MediaCodecInfo[0];
        }
        Vector<MediaCodecInfo> vector2 = vector;
        vector = new Vector<MediaCodecInfo>();
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            vector2.add(mediaCodecInfo);
        }
        Vector<MediaCodecInfo> vector3 = vector2;
        return vector3.toArray(new MediaCodecInfo[vector3.size()]);
    }

    private static DecoderProperties[] findDecoder(String string, SupportedDecoderRecord[] objectArray) {
        Vector vector;
        log.d("Trying to find HW decoder for mime " + string, new Object[0]);
        Object object = vector;
        vector = new Vector();
        block15: for (MediaCodecInfo mediaCodecInfo : MediaCodecVideoDecoder.getCodecList()) {
            if (!Arrays.asList(mediaCodecInfo.getSupportedTypes()).contains(string)) continue;
            log.d("Found candidate decoder " + mediaCodecInfo.getName(), new Object[0]);
            Object[] objectArray2 = MediaCodecVideoDecoder.createIntList(mediaCodecInfo.getCapabilitiesForType((String)string).colorFormats);
            int n = objectArray.length;
            block16: for (int i2 = 0; i2 < n; ++i2) {
                DecoderProperties decoderProperties;
                Pair pair;
                int n2;
                Object object2 = objectArray[i2];
                if (Build.VERSION.SDK_INT < ((SupportedDecoderRecord)object2).supportedVersion) continue;
                if (!mediaCodecInfo.getName().startsWith(((SupportedDecoderRecord)object2).prefix)) continue;
                Object object3 = supportedColorList.iterator();
                while (true) {
                    if (!object3.hasNext()) continue block16;
                    Object[] objectArray3 = objectArray2;
                    n2 = object3.next();
                    if (!objectArray3.contains(n2)) continue;
                    break;
                }
                Object object4 = object;
                log.d("Found target decoder " + mediaCodecInfo.getName() + ". Color: 0x" + Integer.toHexString(n2), new Object[0]);
                Pair pair2 = pair;
                Pair pair3 = pair;
                Object object5 = object2;
                object3 = decoderProperties;
                Object object6 = object2;
                object2 = mediaCodecInfo.getName();
                Map<String, Integer> map = ((SupportedDecoderRecord)object6).meta;
                try {
                    decoderProperties = new DecoderProperties((String)object2, n2, map);
                    pair2(object3, (Object)((SupportedDecoderRecord)object5).priority);
                    object4.add(pair3);
                }
                catch (Exception exception) {
                    Object[] objectArray4 = new Object[1];
                    objectArray2 = objectArray4;
                    objectArray4[0] = exception;
                    log.e("general error", objectArray2);
                    exception.printStackTrace();
                    continue block15;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Object[] objectArray5 = new Object[1];
                    objectArray2 = objectArray5;
                    objectArray5[0] = illegalArgumentException;
                    log.e("Cannot retreive decoder capabilities", objectArray2);
                    continue block15;
                }
                continue;
            }
        }
        Vector vector2 = object;
        Collections.sort(vector2, new Comparator<Pair<DecoderProperties, SupportedDecoderRecord.Priority>>(){

            @Override
            public int compare(Pair<DecoderProperties, SupportedDecoderRecord.Priority> pair, Pair<DecoderProperties, SupportedDecoderRecord.Priority> pair2) {
                return ((SupportedDecoderRecord.Priority)((Object)pair.second)).ordinal() - ((SupportedDecoderRecord.Priority)((Object)pair2.second)).ordinal();
            }
        });
        int n = 0;
        objectArray = new DecoderProperties[vector2.size()];
        object = vector2.iterator();
        while (object.hasNext()) {
            objectArray[n++] = (DecoderProperties)((Pair)object.next()).first;
        }
        return objectArray;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initDecode(VideoCodecType videoCodecType, int n, int n2, SurfaceTextureHelper61 surfaceTextureHelper61) {
        if (this.mediaCodecThread != null) throw new RuntimeException("initDecode: Forgot to release()?");
        boolean bl = surfaceTextureHelper61 != null;
        this.useSurface = bl;
        Pair pair = (Pair)SupportedDecoderTbl.get(videoCodecType.ordinal());
        DecoderProperties[] decoderPropertiesArray = MediaCodecVideoDecoder.findDecoder((String)pair.first, (SupportedDecoderRecord[])pair.second);
        if (decoderPropertiesArray == null) throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        if (decoderPropertiesArray.length == 0) throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        log.d("Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n + " x " + n2 + ". Color: 0x" + Integer.toHexString(decoderPropertiesArray[0].colorFormat) + ". Use Surface: " + this.useSurface, new Object[0]);
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        this.width = n;
        this.height = n2;
        this.stride = n;
        this.sliceHeight = n2;
        videoCodecType = MediaFormat.createVideoFormat((String)((String)pair.first), (int)n, (int)n2);
        n = 0;
        n2 = decoderPropertiesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block6: {
                boolean bl2;
                boolean bl3;
                DecoderProperties decoderProperties = decoderPropertiesArray[n3];
                try {
                    if (this.useSurface) {
                        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
                        mediaCodecVideoDecoder.textureListener = new TextureListener(surfaceTextureHelper61);
                        mediaCodecVideoDecoder.surface = new Surface(surfaceTextureHelper61.getSurfaceTexture());
                    } else {
                        String string = "color-format";
                        videoCodecType.setInteger(string, decoderProperties.colorFormat);
                    }
                    log.d("  Format: " + (Object)((Object)videoCodecType), new Object[0]);
                    bl3 = true;
                    bl2 = this.initDecoder(decoderProperties, (MediaFormat)videoCodecType);
                }
                catch (Exception exception) {}
                n = bl2 ? 1 : 0;
                if (bl3 != bl2) break block6;
                log.d("using decoder: " + decoderProperties.codecName, new Object[0]);
                return n != 0;
            }
            ++n3;
        }
        return n != 0;
    }

    private boolean initDecoder(DecoderProperties objectArray, MediaFormat mediaFormat) {
        MediaCodec mediaCodec;
        block6: {
            try {
                mediaCodec = MediaCodecVideoEncoder.createByCodecName(objectArray.codecName);
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = illegalStateException;
                log.e("initDecode failed", objectArray);
                return false;
            }
            this.mediaCodec = mediaCodec;
            if (mediaCodec != null) break block6;
            OtLog.LogToken logToken = log;
            logToken.e("Can not create media decoder", new Object[0]);
            return false;
        }
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodec.configure(mediaFormat, this.surface, null, 0);
        this.mediaCodec.start();
        mediaCodecVideoDecoder.colorFormat = objectArray.colorFormat;
        mediaCodecVideoDecoder.outputBuffers = mediaCodecVideoDecoder.mediaCodec.getOutputBuffers();
        mediaCodecVideoDecoder.inputBuffers = mediaCodecVideoDecoder.mediaCodec.getInputBuffers();
        mediaCodecVideoDecoder.decodeStartTimeMs.clear();
        mediaCodecVideoDecoder.hasDecodedFirstFrame = false;
        mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.clear();
        mediaCodecVideoDecoder.droppedFrames = 0;
        log.d("Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length, new Object[0]);
        return true;
    }

    private void reset(int n, int n2) {
        if (this.mediaCodecThread != null && this.mediaCodec != null) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            log.d("Java reset: " + n + " x " + n2, new Object[0]);
            this.mediaCodec.flush();
            this.width = n;
            mediaCodecVideoDecoder.height = n2;
            mediaCodecVideoDecoder.decodeStartTimeMs.clear();
            mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.clear();
            mediaCodecVideoDecoder.hasDecodedFirstFrame = false;
            mediaCodecVideoDecoder.droppedFrames = 0;
            return;
        }
        throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
    }

    private void release() {
        Runnable runnable;
        CountDownLatch countDownLatch;
        log.d("Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames, new Object[0]);
        this.checkOnMediaCodecThread();
        final CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                5 v0 = this;
                5 v1 = v0;
                5 v2 = v0;
                OtLog.LogToken logToken = log;
                logToken.d("Java releaseDecoder on release thread", new Object[0]);
                v1.MediaCodecVideoDecoder.this.mediaCodec.stop();
                v2.MediaCodecVideoDecoder.this.mediaCodec.release();
                OtLog.LogToken logToken2 = log;
                try {
                    logToken2.d("Java releaseDecoder on release thread done", new Object[0]);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = exception;
                    log.e("Media decoder release failed", objectArray2);
                }
                countDownLatch2.countDown();
            }
        };
        new Thread(runnable2).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            log.e("Media decoder release timeout", new Object[0]);
            ++codecErrors;
            if (errorCallback != null) {
                log.e("Invoke codec error callback. Errors: " + codecErrors, new Object[0]);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (this.useSurface) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            mediaCodecVideoDecoder.surface.release();
            mediaCodecVideoDecoder.surface = null;
            mediaCodecVideoDecoder.textureListener.release();
        }
        log.d("Java releaseDecoder done", new Object[0]);
    }

    private int dequeueInputBuffer() {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        try {
            return mediaCodecVideoDecoder.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("dequeueIntputBuffer failed", objectArray2);
            return -2;
        }
    }

    private boolean queueInputBuffer(int n, int n2, long l, long l2, long l3) {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        try {
            mediaCodecVideoDecoder.inputBuffers[n].position(0);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("decode failed", objectArray2);
            return false;
        }
        mediaCodecVideoDecoder.inputBuffers[n].limit(n2);
        mediaCodecVideoDecoder.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), l2, l3));
        mediaCodecVideoDecoder.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DecodedOutputBuffer dequeueOutputBuffer(int n) {
        long l;
        TimeStamps timeStamps;
        int n2;
        MediaCodec.BufferInfo bufferInfo;
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        if (mediaCodecVideoDecoder.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo2, TimeUnit.MILLISECONDS.toMicros(n));
            switch (n2) {
                default: {
                    this.hasDecodedFirstFrame = true;
                    timeStamps = this.decodeStartTimeMs.remove();
                    l = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
                    if (l <= 200L) break block5;
                    log.e("Very high decode time: " + l + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.", new Object[0]);
                    l = 200L;
                    break block5;
                }
                case -1: {
                    return null;
                }
                case -2: {
                    int n3;
                    int n4;
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    log.d("Decoder format changed: " + mediaFormat.toString(), new Object[0]);
                    if (mediaFormat.containsKey(FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(FORMAT_KEY_CROP_TOP)) {
                        MediaFormat mediaFormat2 = mediaFormat;
                        n4 = mediaFormat2.getInteger(FORMAT_KEY_CROP_RIGHT) + 1 - mediaFormat.getInteger(FORMAT_KEY_CROP_LEFT);
                        n3 = mediaFormat2.getInteger(FORMAT_KEY_CROP_BOTTOM) + 1 - mediaFormat.getInteger(FORMAT_KEY_CROP_TOP);
                    } else {
                        MediaFormat mediaFormat3 = mediaFormat;
                        n4 = mediaFormat3.getInteger("width");
                        n3 = mediaFormat3.getInteger("height");
                    }
                    if (this.hasDecodedFirstFrame && (n4 != this.width || n3 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n4 + "*" + n3);
                    }
                    this.width = n4;
                    this.height = n3;
                    if (!this.useSurface && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        log.d("Color: 0x" + Integer.toHexString(this.colorFormat), new Object[0]);
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_STRIDE)) {
                        this.stride = mediaFormat.getInteger(FORMAT_KEY_STRIDE);
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = mediaFormat.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
                    log.d("Frame stride and slice height: " + this.stride + " x " + this.sliceHeight, new Object[0]);
                    mediaCodecVideoDecoder2.stride = Math.max(mediaCodecVideoDecoder2.width, this.stride);
                    mediaCodecVideoDecoder2.sliceHeight = Math.max(mediaCodecVideoDecoder2.height, this.sliceHeight);
                    continue block5;
                }
                case -3: {
                    MediaCodecVideoDecoder mediaCodecVideoDecoder3 = this;
                    mediaCodecVideoDecoder3.outputBuffers = mediaCodecVideoDecoder3.mediaCodec.getOutputBuffers();
                    log.d("Decoder output buffers changed: " + this.outputBuffers.length, new Object[0]);
                    if (mediaCodecVideoDecoder3.hasDecodedFirstFrame) throw new RuntimeException("Unexpected output buffer change event.");
                    continue block5;
                }
            }
            break;
        }
        TimeStamps timeStamps2 = timeStamps;
        MediaCodec.BufferInfo bufferInfo3 = bufferInfo2;
        int n5 = bufferInfo3.offset;
        int n6 = bufferInfo3.size;
        long l2 = TimeUnit.MICROSECONDS.toMillis(bufferInfo2.presentationTimeUs);
        long l3 = timeStamps2.timeStampMs;
        long l4 = timeStamps2.ntpTimeStampMs;
        long l5 = SystemClock.elapsedRealtime();
        return new DecodedOutputBuffer(n2, n5, n6, l2, l3, l4, l, l5);
    }

    private DecodedTextureBuffer dequeueTextureBuffer(int n) {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        if (mediaCodecVideoDecoder.useSurface) {
            Object object = this.dequeueOutputBuffer(n);
            if (object != null) {
                this.dequeuedSurfaceOutputBuffers.add((DecodedOutputBuffer)object);
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
            mediaCodecVideoDecoder2.MaybeRenderDecodedTextureBuffer();
            object = mediaCodecVideoDecoder2.textureListener.dequeueTextureBuffer(n);
            if (object != null) {
                this.MaybeRenderDecodedTextureBuffer();
                return object;
            }
            if (this.dequeuedSurfaceOutputBuffers.size() < Math.min(3, this.outputBuffers.length) && (n <= 0 || this.dequeuedSurfaceOutputBuffers.isEmpty())) {
                return null;
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder3 = this;
            ++mediaCodecVideoDecoder3.droppedFrames;
            DecodedOutputBuffer decodedOutputBuffer = mediaCodecVideoDecoder3.dequeuedSurfaceOutputBuffers.remove();
            if (n > 0) {
                log.w("Draining decoder. Dropping frame with TS: " + decodedOutputBuffer.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames, new Object[0]);
            } else {
                log.w("Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + decodedOutputBuffer.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames, new Object[0]);
            }
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, false);
            DecodedOutputBuffer decodedOutputBuffer2 = decodedOutputBuffer;
            long l = decodedOutputBuffer2.presentationTimeStampMs;
            long l2 = decodedOutputBuffer2.timeStampMs;
            long l3 = decodedOutputBuffer2.ntpTimeStampMs;
            long l4 = decodedOutputBuffer2.decodeTimeMs;
            long l5 = SystemClock.elapsedRealtime() - decodedOutputBuffer.endDecodeTimeMs;
            return new DecodedTextureBuffer(0, null, l, l2, l3, l4, l5);
        }
        throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (!((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).dequeuedSurfaceOutputBuffers.isEmpty() && !((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).textureListener.isWaitingForTexture()) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = decodedOutputBuffer;
            DecodedOutputBuffer decodedOutputBuffer = mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.remove();
            mediaCodecVideoDecoder.textureListener.addBufferToRender(decodedOutputBuffer);
            mediaCodecVideoDecoder.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
            return;
        }
    }

    private void returnDecodedOutputBuffer(int n) {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        if (!mediaCodecVideoDecoder.useSurface) {
            this.mediaCodec.releaseOutputBuffer(n, false);
            return;
        }
        throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
    }

    private static List<Integer> createIntList(int[] nArray) {
        Vector<Integer> vector;
        Vector<Integer> vector2 = vector;
        vector = new Vector<Integer>(nArray.length);
        int n = nArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            vector2.add(nArray[i2]);
        }
        return vector2;
    }

    static {
        SupportedDecoderRecord supportedDecoderRecord;
        SupportedDecoderRecord supportedDecoderRecord2;
        SupportedDecoderRecord supportedDecoderRecord3;
        HashMap<String, Integer> hashMap;
        SupportedDecoderRecord supportedDecoderRecord4;
        SupportedDecoderRecord supportedDecoderRecord5;
        HashMap<String, Integer> hashMap2;
        SupportedDecoderRecord supportedDecoderRecord6;
        SupportedDecoderRecord supportedDecoderRecord7;
        SupportedDecoderRecord supportedDecoderRecord8;
        log = OtLog.LogToken("[MediaCodecDecoder]");
        runningInstance = null;
        errorCallback = null;
        codecErrors = 0;
        hwDecoderDisabledTypes = new HashSet<String>();
        VP8_SUPPORT = new SupportedDecoderRecord[0];
        SupportedDecoderRecord[] supportedDecoderRecordArray = new SupportedDecoderRecord[2];
        SupportedDecoderRecord supportedDecoderRecord9 = supportedDecoderRecord8;
        SupportedDecoderRecord.Priority priority = SupportedDecoderRecord.Priority.HARDWARE;
        supportedDecoderRecord8 = new SupportedDecoderRecord("OMX.qcom.", 19, priority, null);
        supportedDecoderRecordArray[0] = supportedDecoderRecord9;
        supportedDecoderRecord9 = supportedDecoderRecord7;
        priority = SupportedDecoderRecord.Priority.HARDWARE;
        supportedDecoderRecord7 = new SupportedDecoderRecord("OMX.Exynos.", 19, priority, null);
        supportedDecoderRecordArray[1] = supportedDecoderRecord9;
        VP9_SUPPORT = supportedDecoderRecordArray;
        SupportedDecoderRecord[] supportedDecoderRecordArray2 = new SupportedDecoderRecord[6];
        supportedDecoderRecord9 = supportedDecoderRecord6;
        priority = SupportedDecoderRecord.Priority.HARDWARE;
        HashMap<String, Integer> hashMap3 = hashMap2;
        hashMap2 = new HashMap<String, Integer>(){
            {
                1 v0 = this;
                v0.put("HighProfile", 21);
            }
        };
        supportedDecoderRecord6 = new SupportedDecoderRecord("OMX.qcom.", 19, priority, (Map<String, Integer>)hashMap3);
        supportedDecoderRecordArray2[0] = supportedDecoderRecord9;
        supportedDecoderRecord9 = supportedDecoderRecord5;
        priority = SupportedDecoderRecord.Priority.HARDWARE;
        supportedDecoderRecord5 = new SupportedDecoderRecord("OMX.Intel.", 19, priority, null);
        supportedDecoderRecordArray2[1] = supportedDecoderRecord9;
        supportedDecoderRecord9 = supportedDecoderRecord4;
        priority = SupportedDecoderRecord.Priority.HARDWARE;
        hashMap3 = hashMap;
        hashMap = new HashMap<String, Integer>(){
            {
                2 v0 = this;
                v0.put("HighProfile", 23);
            }
        };
        supportedDecoderRecord4 = new SupportedDecoderRecord("OMX.Exynos.", 19, priority, (Map<String, Integer>)hashMap3);
        supportedDecoderRecordArray2[2] = supportedDecoderRecord9;
        supportedDecoderRecord9 = supportedDecoderRecord3;
        priority = SupportedDecoderRecord.Priority.HARDWARE;
        supportedDecoderRecord3 = new SupportedDecoderRecord("OMX.IMG.", 19, priority, null);
        supportedDecoderRecordArray2[3] = supportedDecoderRecord9;
        supportedDecoderRecord9 = supportedDecoderRecord2;
        priority = SupportedDecoderRecord.Priority.HARDWARE;
        supportedDecoderRecord2 = new SupportedDecoderRecord("OMX.MTK.", 19, priority, null);
        supportedDecoderRecordArray2[4] = supportedDecoderRecord9;
        supportedDecoderRecord9 = supportedDecoderRecord;
        priority = SupportedDecoderRecord.Priority.SOFTWARE;
        supportedDecoderRecord = new SupportedDecoderRecord("OMX.google.h264.", 23, priority, null);
        supportedDecoderRecordArray2[5] = supportedDecoderRecord9;
        H264_SUPPORT = supportedDecoderRecordArray2;
        SupportedDecoderTbl = new SparseArray<Pair<String, SupportedDecoderRecord[]>>(){
            {
                3 v0 = this;
                v0.append(VideoCodecType.VIDEO_CODEC_VP8.ordinal(), new Pair((Object)MediaCodecVideoDecoder.VP8_MIME_TYPE, (Object)VP8_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_VP9.ordinal(), new Pair((Object)MediaCodecVideoDecoder.VP9_MIME_TYPE, (Object)VP9_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_H264.ordinal(), new Pair((Object)MediaCodecVideoDecoder.H264_MIME_TYPE, (Object)H264_SUPPORT));
            }
        };
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    private static class TextureListener
    implements SurfaceTextureHelper61.OnTextureFrameAvailableListener {
        private final SurfaceTextureHelper61 surfaceTextureHelper;
        private final Object newFrameLock;
        private DecodedOutputBuffer bufferToRender;
        private DecodedTextureBuffer renderedBuffer;

        public TextureListener(SurfaceTextureHelper61 surfaceTextureHelper61) {
            Object object;
            Object object2 = object;
            object = new Object();
            this.newFrameLock = object2;
            this.surfaceTextureHelper = surfaceTextureHelper61;
            surfaceTextureHelper61.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender == null) {
                this.bufferToRender = decodedOutputBuffer;
                return;
            }
            log.e("Unexpected addBufferToRender() called while waiting for a texture.", new Object[0]);
            throw new IllegalStateException("Waiting for a texture.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            TextureListener textureListener = object;
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                boolean bl = textureListener.bufferToRender != null;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onTextureFrameAvailable(int n, float[] fArray, long l) {
            TextureListener textureListener = this;
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                if (textureListener.renderedBuffer == null) {
                    DecodedTextureBuffer decodedTextureBuffer;
                    TextureListener textureListener2 = this;
                    TextureListener textureListener3 = this;
                    long l2 = textureListener3.bufferToRender.presentationTimeStampMs;
                    long l3 = textureListener3.bufferToRender.timeStampMs;
                    long l4 = textureListener3.bufferToRender.ntpTimeStampMs;
                    long l5 = textureListener3.bufferToRender.decodeTimeMs;
                    decodedTextureBuffer(n, fArray, l2, l3, l4, l5, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                    textureListener2.renderedBuffer = decodedTextureBuffer;
                    textureListener2.bufferToRender = null;
                    textureListener2.newFrameLock.notifyAll();
                    return;
                }
                log.e("Unexpected onTextureFrameAvailable() called while already holding a texture.", new Object[0]);
                throw new IllegalStateException("Already holding a texture.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public DecodedTextureBuffer dequeueTextureBuffer(int var1_1) {
            v0 = this;
            var2_2 = v0.newFrameLock;
            synchronized (var2_2) {
                if (v0.renderedBuffer != null || var1_1 <= 0) ** GOTO lbl18
                {
                    catch (Throwable v1) {
                        throw v1;
                    }
                }
                if (!this.isWaitingForTexture()) ** GOTO lbl18
                v2 = this.newFrameLock;
                try {
                    v2.wait(var1_1);
                    ** GOTO lbl18
                }
                catch (InterruptedException v3) {
                    Thread.currentThread().interrupt();
lbl18:
                    // 4 sources

                    this.renderedBuffer = null;
                    return this.renderedBuffer;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            TextureListener textureListener = this;
            textureListener.surfaceTextureHelper.stopListening();
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                if (textureListener.renderedBuffer != null) {
                    this.surfaceTextureHelper.returnTextureFrame();
                    this.renderedBuffer = null;
                }
                return;
            }
        }
    }

    private static class DecodedTextureBuffer {
        private final int textureID;
        private final float[] transformMatrix;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        public DecodedTextureBuffer(int n, float[] fArray, long l, long l2, long l3, long l4, long l5) {
            this.textureID = n;
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.frameDelayMs = l5;
        }
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;

        public DecodedOutputBuffer(int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.endDecodeTimeMs = l5;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;

        public TimeStamps(long l, long l2, long l3) {
            this.decodeStartTimeMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final Map<String, Integer> meta;

        public DecoderProperties(String string, int n, Map<String, Integer> map) {
            this.codecName = string;
            this.colorFormat = n;
            this.meta = map;
        }
    }

    private static class SupportedDecoderRecord {
        public final String prefix;
        public final int supportedVersion;
        public final Priority priority;
        public final Map<String, Integer> meta;

        public SupportedDecoderRecord(String string, int n, Priority priority, Map<String, Integer> hashMap) {
            this.prefix = string;
            this.supportedVersion = n;
            this.priority = priority;
            if (hashMap == null) {
                HashMap hashMap2;
                hashMap = hashMap2;
                hashMap2 = new HashMap();
            }
            this.meta = hashMap;
        }

        public static final class Priority
        extends Enum<Priority> {
            public static final /* enum */ Priority HARDWARE;
            public static final /* enum */ Priority SOFTWARE;
            private static final /* synthetic */ Priority[] $VALUES;
            private final int priority;

            public static Priority[] values() {
                return (Priority[])$VALUES.clone();
            }

            public static Priority valueOf(String string) {
                return Enum.valueOf(Priority.class, string);
            }

            private Priority(int n2) {
                this.priority = n2;
            }

            static {
                Priority priority;
                HARDWARE = new Priority(100);
                Priority priority2 = priority;
                SOFTWARE = new Priority(10);
                $VALUES = new Priority[]{HARDWARE, priority2};
            }
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static final class VideoCodecType
    extends Enum<VideoCodecType> {
        public static final /* enum */ VideoCodecType VIDEO_CODEC_GENERIC;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP8;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP9;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_AV1;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H264;
        private static final /* synthetic */ VideoCodecType[] $VALUES;

        public static VideoCodecType[] values() {
            return (VideoCodecType[])$VALUES.clone();
        }

        public static VideoCodecType valueOf(String string) {
            return Enum.valueOf(VideoCodecType.class, string);
        }

        static {
            VideoCodecType videoCodecType;
            VIDEO_CODEC_GENERIC = new VideoCodecType();
            VIDEO_CODEC_VP8 = new VideoCodecType();
            VIDEO_CODEC_VP9 = new VideoCodecType();
            VIDEO_CODEC_AV1 = new VideoCodecType();
            VideoCodecType videoCodecType2 = videoCodecType;
            VIDEO_CODEC_H264 = new VideoCodecType();
            $VALUES = new VideoCodecType[]{VIDEO_CODEC_GENERIC, VIDEO_CODEC_VP8, VIDEO_CODEC_VP9, VIDEO_CODEC_AV1, videoCodecType2};
        }
    }
}

