/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.BindMount;
import com.opentable.db.postgres.embedded.JdbcUrlUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

public class EmbeddedPostgres
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedPostgres.class);
    static final Duration DEFAULT_PG_STARTUP_WAIT = Duration.ofSeconds(60L);
    static final String POSTGRES = "postgres";
    static final String ENV_DOCKER_IMAGE = "PG_FULL_IMAGE";
    static final String ENV_DOCKER_PREFIX = "TESTCONTAINERS_HUB_IMAGE_NAME_PREFIX";
    static final DockerImageName DOCKER_DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"postgres");
    static final String DOCKER_DEFAULT_TAG = "13-alpine";
    private final PostgreSQLContainer<?> postgreDBContainer;
    private final UUID instanceId = UUID.randomUUID();

    EmbeddedPostgres(Map<String, String> postgresConfig, Map<String, String> localeConfig, Map<String, BindMount> bindMounts, Optional<Network> network, Optional<String> networkAlias, DockerImageName image, Duration pgStartupWait, String databaseName) throws IOException {
        LOG.trace("Starting containers with image {}, pgConfig {}, localeConfig {}, bindMounts {}, pgStartupWait {}, dbName {} ", new Object[]{image, postgresConfig, localeConfig, bindMounts, pgStartupWait, databaseName});
        image = image.asCompatibleSubstituteFor(POSTGRES);
        this.postgreDBContainer = (PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(image).withDatabaseName(databaseName).withUsername(POSTGRES).withPassword(POSTGRES).withStartupTimeout(pgStartupWait)).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG))).withEnv("POSTGRES_INITDB_ARGS", String.join((CharSequence)" ", this.createInitOptions(localeConfig)))).withEnv("POSTGRES_HOST_AUTH_METHOD", "trust");
        ArrayList<String> cmd = new ArrayList<String>(Collections.singletonList(POSTGRES));
        cmd.addAll(this.createConfigOptions(postgresConfig));
        this.postgreDBContainer.setCommand(cmd.toArray(new String[0]));
        this.processBindMounts(this.postgreDBContainer, bindMounts);
        network.ifPresent(arg_0 -> this.postgreDBContainer.withNetwork(arg_0));
        networkAlias.ifPresent(xva$0 -> {
            PostgreSQLContainer cfr_ignored_0 = (PostgreSQLContainer)this.postgreDBContainer.withNetworkAliases(new String[]{xva$0});
        });
        this.postgreDBContainer.start();
    }

    private void processBindMounts(PostgreSQLContainer<?> postgreDBContainer, Map<String, BindMount> bindMounts) {
        bindMounts.values().stream().filter(f -> new File(f.getLocalFile()).exists()).forEach(f -> postgreDBContainer.addFileSystemBind(f.getLocalFile(), f.getRemoteFile(), f.getBindMode()));
    }

    private List<String> createConfigOptions(Map<String, String> postgresConfig) {
        ArrayList<String> configOptions = new ArrayList<String>();
        for (Map.Entry<String, String> config : postgresConfig.entrySet()) {
            configOptions.add("-c");
            configOptions.add(config.getKey() + "=" + config.getValue());
        }
        return configOptions;
    }

    private List<String> createInitOptions(Map<String, String> localeConfig) {
        ArrayList<String> localeOptions = new ArrayList<String>();
        for (Map.Entry<String, String> config : localeConfig.entrySet()) {
            localeOptions.add("--" + config.getKey());
            localeOptions.add(config.getValue());
        }
        return localeOptions;
    }

    public DataSource getTemplateDatabase() {
        return this.getDatabase(this.postgreDBContainer.getUsername(), "template1");
    }

    public DataSource getTemplateDatabase(Map<String, String> properties) {
        return this.getDatabase(this.postgreDBContainer.getUsername(), "template1", properties);
    }

    public DataSource getPostgresDatabase() {
        return this.getDatabase(this.postgreDBContainer.getUsername(), this.postgreDBContainer.getDatabaseName());
    }

    public DataSource getPostgresDatabase(Map<String, String> properties) {
        return this.getDatabase(this.postgreDBContainer.getUsername(), this.postgreDBContainer.getDatabaseName(), properties);
    }

    public DataSource getDatabase(String userName, String dbName) {
        return this.getDatabase(userName, dbName, Collections.emptyMap());
    }

    public DataSource getDatabase(String userName, String dbName, Map<String, String> properties) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setURL(this.postgreDBContainer.getJdbcUrl());
        ds.setDatabaseName(dbName);
        ds.setUser(userName);
        ds.setPassword(this.postgreDBContainer.getPassword());
        properties.forEach((propertyKey, propertyValue) -> {
            try {
                ds.setProperty(propertyKey, propertyValue);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        return ds;
    }

    public String getJdbcUrl(String dbName) {
        try {
            return JdbcUrlUtils.replaceDatabase(this.postgreDBContainer.getJdbcUrl(), dbName);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getHost() {
        return this.postgreDBContainer.getContainerIpAddress();
    }

    public int getPort() {
        return this.postgreDBContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue());
    }

    @Override
    public void close() throws IOException {
        this.postgreDBContainer.close();
    }

    public static EmbeddedPostgres start() throws IOException {
        return EmbeddedPostgres.builder().start();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserName() {
        return this.postgreDBContainer.getUsername();
    }

    public String getPassword() {
        return this.postgreDBContainer.getPassword();
    }

    public String toString() {
        return "EmbeddedPG-" + this.instanceId;
    }

    public static class Builder {
        private final Map<String, String> config = new HashMap<String, String>();
        private final Map<String, String> localeConfig = new HashMap<String, String>();
        private final Map<String, BindMount> bindMounts = new HashMap<String, BindMount>();
        private Optional<Network> network = Optional.empty();
        private Duration pgStartupWait = DEFAULT_PG_STARTUP_WAIT;
        private DockerImageName image = this.getDefaultImage();
        private String databaseName = "postgres";
        private Optional<String> networkAlias = Optional.empty();

        DockerImageName getDefaultImage() {
            if (this.getEnvOrProperty(EmbeddedPostgres.ENV_DOCKER_IMAGE) != null) {
                return DockerImageName.parse((String)this.getEnvOrProperty(EmbeddedPostgres.ENV_DOCKER_IMAGE));
            }
            if (this.getEnvOrProperty(EmbeddedPostgres.ENV_DOCKER_PREFIX) != null) {
                return DockerImageName.parse((String)this.insertSlashIfNeeded(this.getEnvOrProperty(EmbeddedPostgres.ENV_DOCKER_PREFIX), EmbeddedPostgres.POSTGRES)).withTag(EmbeddedPostgres.DOCKER_DEFAULT_TAG);
            }
            return DOCKER_DEFAULT_IMAGE_NAME.withTag(EmbeddedPostgres.DOCKER_DEFAULT_TAG);
        }

        String getEnvOrProperty(String key) {
            return Optional.ofNullable(System.getenv(key)).orElse(System.getProperty(key));
        }

        String insertSlashIfNeeded(String prefix, String repo) {
            if (prefix.endsWith("/") || repo.startsWith("/")) {
                return prefix + repo;
            }
            return prefix + "/" + repo;
        }

        Builder() {
            this.config.put("timezone", "UTC");
            this.config.put("synchronous_commit", "off");
            this.config.put("max_connections", "300");
            this.config.put("fsync", "off");
        }

        public Builder setPGStartupWait(Duration pgStartupWait) {
            Objects.requireNonNull(pgStartupWait);
            if (pgStartupWait.isNegative()) {
                throw new IllegalArgumentException("Negative durations are not permitted.");
            }
            this.pgStartupWait = pgStartupWait;
            return this;
        }

        public Builder setServerConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public Builder setBindMount(String localFile, String remoteFile) {
            return this.setBindMount(BindMount.of(localFile, remoteFile, BindMode.READ_ONLY));
        }

        public Builder setBindMount(BindMount bindMount) {
            this.bindMounts.put(bindMount.getLocalFile(), bindMount);
            return this;
        }

        public Builder setNetwork(Network network, String networkAlias) {
            this.network = Optional.ofNullable(network);
            this.networkAlias = Optional.ofNullable(networkAlias);
            return this;
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setLocaleConfig(String key, String value) {
            this.localeConfig.put(key, value);
            return this;
        }

        public Builder setImage(DockerImageName image) {
            this.image = image;
            return this;
        }

        public Builder setTag(String tag) {
            this.image = this.image.withTag(tag);
            return this;
        }

        DockerImageName getImage() {
            return this.image;
        }

        public EmbeddedPostgres start() throws IOException {
            return new EmbeddedPostgres(this.config, this.localeConfig, this.bindMounts, this.network, this.networkAlias, this.image, this.pgStartupWait, this.databaseName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return Objects.equals(this.config, builder.config) && Objects.equals(this.localeConfig, builder.localeConfig) && Objects.equals(this.bindMounts, builder.bindMounts) && Objects.equals(this.network, builder.network) && Objects.equals(this.pgStartupWait, builder.pgStartupWait) && Objects.equals(this.image, builder.image) && Objects.equals(this.databaseName, builder.databaseName) && Objects.equals(this.networkAlias, builder.networkAlias);
        }

        public int hashCode() {
            return Objects.hash(this.config, this.localeConfig, this.bindMounts, this.network, this.pgStartupWait, this.image, this.databaseName, this.networkAlias);
        }
    }
}

