/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.Parameterizable;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.util.Iterator;
import java.util.Map;

public class StaticParametersInterceptor
extends AroundInterceptor {
    private static final long serialVersionUID = -5364822129178790799L;
    private boolean parse;

    public void setParse(String value) {
        this.parse = Boolean.valueOf(value);
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        ActionConfig config = invocation.getProxy().getConfig();
        Object action = invocation.getAction();
        Map parameters = config.getParams();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting static parameters " + parameters));
        }
        if (action instanceof Parameterizable) {
            ((Parameterizable)action).setParams(parameters);
        }
        if (parameters != null) {
            OgnlValueStack stack = ActionContext.getContext().getValueStack();
            Iterator iterator = parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object val = entry.getValue();
                if (this.parse && val instanceof String) {
                    val = TextParseUtil.translateVariables((String)val, stack);
                }
                stack.setValue(entry.getKey().toString(), val);
            }
        }
    }
}

