/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFieldValidator
extends FieldValidatorSupport {
    private String expression;
    private boolean caseSensitive = true;
    private boolean trim = true;

    public void validate(Object object) throws ValidationException {
        Matcher matcher;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null || this.expression == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String str = ((String)value).trim();
        if (str.length() == 0) {
            return;
        }
        Pattern pattern = this.isCaseSensitive() ? Pattern.compile(this.expression) : Pattern.compile(this.expression, 2);
        String compare = (String)value;
        if (this.trim) {
            compare = compare.trim();
        }
        if (!(matcher = pattern.matcher(compare)).matches()) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isTrimed() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

