/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Iterator;
import java.util.Map;

public class AliasInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AliasInterceptor.class);
    private static final String DEFAULT_ALIAS_KEY = "aliases";
    protected String aliasesKey = "aliases";

    public void setAliasesKey(String aliasesKey) {
        this.aliasesKey = aliasesKey;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionConfig config = invocation.getProxy().getConfig();
        ActionContext ac = invocation.getInvocationContext();
        Map<String, String> parameters = config.getParams();
        if (parameters.containsKey(this.aliasesKey)) {
            String aliasExpression = parameters.get(this.aliasesKey);
            ValueStack stack = ac.getValueStack();
            Object obj = stack.findValue(aliasExpression);
            if (obj != null && obj instanceof Map) {
                Map aliases = (Map)obj;
                Iterator i$ = aliases.entrySet().iterator();
                while (i$.hasNext()) {
                    Map contextParameters;
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    String name = entry.getKey().toString();
                    String alias = (String)entry.getValue();
                    Object value = stack.findValue(name);
                    if (null == value && null != (contextParameters = (Map)stack.getContext().get("parameters"))) {
                        value = contextParameters.get(name);
                    }
                    if (null == value) continue;
                    stack.setValue(alias, value);
                }
            } else {
                log.debug("invalid alias expression:" + this.aliasesKey, new String[0]);
            }
        }
        return invocation.invoke();
    }
}

