/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import ognl.DefaultMemberAccess;

public class StaticMemberAccess
extends DefaultMemberAccess {
    private boolean allowStaticMethodAccess;

    public StaticMemberAccess(boolean method) {
        super(false);
        this.allowStaticMethodAccess = method;
    }

    public boolean getAllowStaticMethodAccess() {
        return this.allowStaticMethodAccess;
    }

    public void setAllowStaticMethodAccess(boolean allowStaticMethodAccess) {
        this.allowStaticMethodAccess = allowStaticMethodAccess;
    }

    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        boolean allow = true;
        int modifiers = member.getModifiers();
        if (Modifier.isStatic(modifiers) && member instanceof Method && !this.getAllowStaticMethodAccess()) {
            allow = false;
        }
        if (allow) {
            return super.isAccessible(context, target, member, propertyName);
        }
        return false;
    }
}

