/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.views.xslt.AbstractAdapterNode;
import com.opensymphony.webwork.views.xslt.AdapterFactory;
import com.opensymphony.webwork.views.xslt.AdapterNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ProxyNodeAdapter
extends AbstractAdapterNode {
    private Log log = LogFactory.getLog(this.getClass());

    public ProxyNodeAdapter(AdapterFactory factory, AdapterNode parent, Node value) {
        this.setContext(factory, parent, "document", value);
        this.log.debug((Object)("proxied node is: " + value));
        this.log.debug((Object)("node class is: " + value.getClass()));
        this.log.debug((Object)("node type is: " + value.getNodeType()));
        this.log.debug((Object)("node name is: " + value.getNodeName()));
    }

    protected Node node() {
        return (Node)this.getPropertyValue();
    }

    protected Node wrap(Node node) {
        return this.getAdapterFactory().proxyNode(this, node);
    }

    protected NamedNodeMap wrap(NamedNodeMap nnm) {
        return this.getAdapterFactory().proxyNamedNodeMap(this, nnm);
    }

    public String getNodeName() {
        this.log.trace((Object)"getNodeName");
        return this.node().getNodeName();
    }

    public String getNodeValue() throws DOMException {
        this.log.trace((Object)"getNodeValue");
        return this.node().getNodeValue();
    }

    public short getNodeType() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getNodeType: " + this.getNodeName() + ": " + this.node().getNodeType()));
        }
        return this.node().getNodeType();
    }

    public NamedNodeMap getAttributes() {
        NamedNodeMap nnm = this.wrap(this.node().getAttributes());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getAttributes: " + nnm));
        }
        return nnm;
    }

    public boolean hasChildNodes() {
        this.log.trace((Object)"hasChildNodes");
        return this.node().hasChildNodes();
    }

    public boolean isSupported(String s, String s1) {
        this.log.trace((Object)"isSupported");
        return this.node().isSupported(s, s1);
    }

    public String getNamespaceURI() {
        this.log.trace((Object)"getNamespaceURI");
        return this.node().getNamespaceURI();
    }

    public String getPrefix() {
        this.log.trace((Object)"getPrefix");
        return this.node().getPrefix();
    }

    public String getLocalName() {
        this.log.trace((Object)"getLocalName");
        return this.node().getLocalName();
    }

    public boolean hasAttributes() {
        this.log.trace((Object)"hasAttributes");
        return this.node().hasAttributes();
    }

    public String toString() {
        return "ProxyNode for: " + this.node();
    }
}

