/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.webwork.portlet.context.PortletActionContext;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.webwork.views.util.ResourceUtil;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletFreemarkerResult
extends WebWorkResultSupport {
    protected ActionInvocation invocation;
    protected Configuration configuration;
    protected ObjectWrapper wrapper;
    protected String location;
    private String pContentType = "text/html";

    public void setContentType(String aContentType) {
        this.pContentType = aContentType;
    }

    public String getContentType() {
        return this.pContentType;
    }

    public void doExecute(String location, ActionInvocation invocation) throws IOException, TemplateException, PortletException {
        if (PortletActionContext.isEvent()) {
            this.executeActionResult(location, invocation);
        } else if (PortletActionContext.isRender()) {
            this.executeRenderResult(location, invocation);
        }
    }

    private void executeActionResult(String location, ActionInvocation invocation) {
        ActionResponse res = PortletActionContext.getActionResponse();
        res.setRenderParameter("webwork.portlet.action", "freemarkerDirect");
        res.setRenderParameter("location", location);
        res.setRenderParameter("webwork.portlet.mode", PortletActionContext.getRequest().getPortletMode().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRenderResult(String location, ActionInvocation invocation) throws TemplateException, IOException, TemplateModelException, PortletException {
        TemplateModel model;
        Template template;
        this.prepareServletActionContext();
        this.location = location;
        this.invocation = invocation;
        this.configuration = this.getConfiguration();
        this.wrapper = this.getObjectWrapper();
        HttpServletRequest req = ServletActionContext.getRequest();
        HttpServletResponse res = ServletActionContext.getResponse();
        if (!location.startsWith("/")) {
            ActionContext ctx = invocation.getInvocationContext();
            String base = ResourceUtil.getResourceBase(req);
            location = base + "/" + location;
        }
        if (this.preTemplateProcess(template = this.configuration.getTemplate(location, this.deduceLocale()), model = this.createModel())) {
            try {
                PortletActionContext.getRenderResponse().setContentType(this.pContentType);
                template.process((Object)model, this.getWriter());
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
    }

    private void prepareServletActionContext() throws PortletException, IOException {
        PortletRequestDispatcher disp = PortletActionContext.getPortletConfig().getPortletContext().getNamedDispatcher("preparator");
        disp.include(PortletActionContext.getRenderRequest(), PortletActionContext.getRenderResponse());
    }

    protected Configuration getConfiguration() throws TemplateException {
        return FreemarkerManager.getInstance().getConfiguration(ServletActionContext.getServletContext());
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.configuration.getObjectWrapper();
    }

    protected Writer getWriter() throws IOException {
        return PortletActionContext.getRenderResponse().getWriter();
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        OgnlValueStack stack = ServletActionContext.getContext().getValueStack();
        return FreemarkerManager.getInstance().buildTemplateModel(stack, this.invocation.getAction(), servletContext, request, response, this.wrapper);
    }

    protected Locale deduceLocale() {
        return this.configuration.getLocale();
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        Object attrContentType = template.getCustomAttribute("content_type");
        if (attrContentType != null) {
            ServletActionContext.getResponse().setContentType(attrContentType.toString());
        } else {
            String encoding;
            String contentType = this.getContentType();
            if (contentType == null) {
                contentType = "text/html";
            }
            if ((encoding = template.getEncoding()) != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            ServletActionContext.getResponse().setContentType(contentType);
        }
        return true;
    }
}

