/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.lifecycle;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.xwork.interceptor.component.ComponentConfiguration;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.DefaultComponentManager;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ApplicationLifecycleListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog((Class)ApplicationLifecycleListener.class);

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext application = event.getServletContext();
        ComponentManager container = (ComponentManager)application.getAttribute("DefaultComponentManager");
        if (container != null) {
            container.dispose();
        }
        Introspector.flushCaches();
        LogFactory.releaseAll();
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext application = event.getServletContext();
        DefaultComponentManager container = this.createComponentManager();
        ComponentConfiguration config = this.loadConfiguration();
        if (config != null) {
            config.configure((ComponentManager)container, "application");
            application.setAttribute("DefaultComponentManager", (Object)container);
            application.setAttribute("ComponentConfiguration", (Object)config);
        }
    }

    protected DefaultComponentManager createComponentManager() {
        return new DefaultComponentManager();
    }

    private ComponentConfiguration loadConfiguration() {
        ComponentConfiguration config = new ComponentConfiguration();
        InputStream configXml = Thread.currentThread().getContextClassLoader().getResourceAsStream("components.xml");
        if (configXml == null) {
            String message = "Unable to find the file components.xml in the classpath, XWork IoC *not* initialized.";
            log.warn((Object)"Unable to find the file components.xml in the classpath, XWork IoC *not* initialized.");
            return null;
        }
        try {
            config.loadFromXml(configXml);
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new WebWorkException("Unable to load component configuration");
        }
        catch (SAXException sae) {
            log.error((Object)sae);
            throw new WebWorkException("Unable to load component configuration");
        }
        return config;
    }
}

