/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.config;

import com.opensymphony.webwork.config.DefaultConfiguration;
import com.opensymphony.xwork.ObjectFactory;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    static Configuration configurationImpl;
    static Configuration defaultImpl;
    static Locale locale;
    private static final Log LOG;

    public static void setConfiguration(Configuration config) throws IllegalStateException {
        configurationImpl = config;
        locale = null;
    }

    public static Configuration getConfiguration() {
        return configurationImpl == null ? Configuration.getDefaultConfiguration() : configurationImpl;
    }

    public static Locale getLocale() {
        if (locale == null) {
            try {
                StringTokenizer localeTokens = new StringTokenizer(Configuration.getString("webwork.locale"), "_");
                String lang = null;
                String country = null;
                if (localeTokens.hasMoreTokens()) {
                    lang = localeTokens.nextToken();
                }
                if (localeTokens.hasMoreTokens()) {
                    country = localeTokens.nextToken();
                }
                locale = new Locale(lang, country);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Setting locale to the default locale");
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    public static boolean isSet(String name) {
        return Configuration.getConfiguration().isSetImpl(name);
    }

    public static String getString(String name) throws IllegalArgumentException {
        String val = Configuration.get(name).toString();
        return val;
    }

    public static Object get(String name) throws IllegalArgumentException {
        Object val = Configuration.getConfiguration().getImpl(name);
        return val;
    }

    public static Iterator list() {
        return Configuration.getConfiguration().listImpl();
    }

    public boolean isSetImpl(String name) {
        return false;
    }

    public static void set(String name, Object value) throws IllegalArgumentException, UnsupportedOperationException {
        Configuration.getConfiguration().setImpl(name, value);
    }

    public void setImpl(String name, Object value) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration does not support updating a setting");
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        return null;
    }

    public Iterator listImpl() {
        throw new UnsupportedOperationException("This configuration does not support listing the settings");
    }

    private static Configuration getDefaultConfiguration() {
        if (defaultImpl == null) {
            defaultImpl = new DefaultConfiguration();
            try {
                String className = Configuration.getString("webwork.configuration");
                if (!className.equals(defaultImpl.getClass().getName())) {
                    try {
                        defaultImpl = (Configuration)ObjectFactory.getObjectFactory().buildBean(Thread.currentThread().getContextClassLoader().loadClass(className), null);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not instantiate configuration", (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultImpl;
    }

    public static void reset() {
        defaultImpl = null;
        configurationImpl = null;
    }

    static {
        LOG = LogFactory.getLog((Class)Configuration.class);
    }
}

