/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.views.xslt.AdapterNode;
import com.opensymphony.webwork.views.xslt.ArrayAdapter;
import com.opensymphony.webwork.views.xslt.BeanAdapter;
import com.opensymphony.webwork.views.xslt.CollectionAdapter;
import com.opensymphony.webwork.views.xslt.MapAdapter;
import com.opensymphony.webwork.views.xslt.ProxyAttrAdapter;
import com.opensymphony.webwork.views.xslt.ProxyElementAdapter;
import com.opensymphony.webwork.views.xslt.ProxyNamedNodeMap;
import com.opensymphony.webwork.views.xslt.ProxyTextNodeAdapter;
import com.opensymphony.webwork.views.xslt.SimpleAdapterDocument;
import com.opensymphony.webwork.views.xslt.StringAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AdapterFactory {
    private Log log = LogFactory.getLog(this.getClass());
    private Map adapterTypes = new HashMap();

    public void registerAdapterType(Class type, Class adapterType) {
        this.adapterTypes.put(type, adapterType);
    }

    public Document adaptDocument(String propertyName, Object propertyValue) throws IllegalAccessException, InstantiationException {
        return new SimpleAdapterDocument(this, null, propertyName, propertyValue);
    }

    public Node adaptNode(AdapterNode parent, String propertyName, Object value) {
        Class adapterClass = this.getAdapterForValue(value);
        if (adapterClass != null) {
            return this.constructAdapterInstance(adapterClass, parent, propertyName, value);
        }
        if (value instanceof Document) {
            value = ((Document)value).getDocumentElement();
        }
        if (value instanceof Node) {
            return this.proxyNode(parent, (Node)value);
        }
        Class<?> valueType = value.getClass();
        adapterClass = valueType.isArray() ? ArrayAdapter.class : (value instanceof String || value instanceof Number || valueType.isPrimitive() ? StringAdapter.class : (value instanceof Collection ? CollectionAdapter.class : (value instanceof Map ? MapAdapter.class : BeanAdapter.class)));
        return this.constructAdapterInstance(adapterClass, parent, propertyName, value);
    }

    public Node proxyNode(AdapterNode parent, Node node) {
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return new ProxyElementAdapter(this, parent, (Element)node);
        }
        if (node.getNodeType() == 3) {
            return new ProxyTextNodeAdapter(this, parent, (Text)node);
        }
        if (node.getNodeType() == 2) {
            return new ProxyAttrAdapter(this, parent, (Attr)node);
        }
        return null;
    }

    public NamedNodeMap proxyNamedNodeMap(AdapterNode parent, NamedNodeMap nnm) {
        return new ProxyNamedNodeMap(this, parent, nnm);
    }

    private Node constructAdapterInstance(Class adapterClass, AdapterNode parent, String propertyName, Object propertyValue) {
        try {
            adapterClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            throw new WebWorkException("Adapter class: " + adapterClass + " does not have a no-args consructor.");
        }
        try {
            AdapterNode adapterNode = (AdapterNode)adapterClass.newInstance();
            adapterNode.setAdapterFactory(this);
            adapterNode.setParent(parent);
            adapterNode.setPropertyName(propertyName);
            adapterNode.setPropertyValue(propertyValue);
            return adapterNode;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new WebWorkException("Cannot adapt " + propertyValue + " (" + propertyName + ") :" + e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new WebWorkException("Cannot adapt " + propertyValue + " (" + propertyName + ") :" + e.getMessage());
        }
    }

    public Node adaptNullValue(BeanAdapter parent, String propertyName) {
        return new StringAdapter(this, parent, propertyName, "null");
    }

    public Class getAdapterForValue(Object value) {
        return (Class)this.adapterTypes.get(value.getClass());
    }
}

