/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader.monitor;

import com.opensymphony.webwork.util.classloader.monitor.FilesystemAlterationListener;
import com.opensymphony.webwork.util.classloader.utils.ThreadUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilesystemAlterationMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)FilesystemAlterationMonitor.class);
    private Map listeners = new MultiHashMap();
    private Map directories = new MultiHashMap();
    private Map entries = new HashMap();
    private final Object mutexListeners = new Object();
    private final Object mutexRunning = new Object();
    private long delay = 3000L;
    private boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutexRunning;
        synchronized (object) {
            this.running = false;
        }
    }

    public void setInterval(long pDelay) {
        this.delay = pDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FilesystemAlterationListener listener, File directory) {
        Object object = this.mutexListeners;
        synchronized (object) {
            MultiHashMap newListeners = new MultiHashMap(this.listeners);
            newListeners.put((Object)listener, (Object)directory);
            this.listeners = newListeners;
            MultiHashMap newDirectories = new MultiHashMap(this.directories);
            newDirectories.put((Object)directory, (Object)listener);
            this.directories = newDirectories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FilesystemAlterationListener listener) {
        Object object = this.mutexListeners;
        synchronized (object) {
            MultiHashMap newListeners = new MultiHashMap(this.listeners);
            Collection d = (Collection)newListeners.remove((Object)listener);
            this.listeners = newListeners;
            if (d != null) {
                MultiHashMap newDirectories = new MultiHashMap(this.directories);
                Iterator it = d.iterator();
                while (it.hasNext()) {
                    newDirectories.remove(it.next());
                    this.entries.remove(d);
                }
                this.directories = newDirectories;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStart(File root) {
        Map directories;
        log.debug((Object)("start checking " + root));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                listener.onStart(root);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStop(File root) {
        Map directories;
        log.debug((Object)("stop checking " + root));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                listener.onStop(root);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreate(File root, Entry entry) {
        Map directories;
        log.debug((Object)("created " + (entry.isDirectory() ? "dir " : "file ") + entry));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            if (entry.isDirectory()) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onCreateDirectory(entry.getFile());
                }
            } else {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onCreateFile(entry.getFile());
                }
            }
        }
        entry.markNotChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChange(File root, Entry entry) {
        Map directories;
        log.debug((Object)("changed " + (entry.isDirectory() ? "dir " : "file ") + entry));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            if (entry.isDirectory()) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onChangeDirectory(entry.getFile());
                }
            } else {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onChangeFile(entry.getFile());
                }
            }
        }
        entry.markNotChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDelete(File root, Entry entry) {
        Map directories;
        log.debug((Object)("deleted " + (entry.isDirectory() ? "dir " : "file ") + entry));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            if (entry.isDirectory()) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onDeleteDirectory(entry.getFile());
                }
            } else {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onDeleteFile(entry.getFile());
                }
            }
        }
        entry.markNotChanged();
    }

    private void check(File root, Entry entry, boolean create) {
        if (entry.isDirectory()) {
            Entry[] currentChilds = entry.getChilds();
            if (entry.hasChanged() || create) {
                Entry child;
                int i;
                if (!create) {
                    this.onChange(root, entry);
                    for (int i2 = 0; i2 < currentChilds.length; ++i2) {
                        Entry child2 = currentChilds[i2];
                        if (!child2.isDelected()) continue;
                        entry.delete(child2);
                        currentChilds[i2] = null;
                    }
                }
                Entry[] newChilds = entry.getNonChilds();
                for (i = 0; i < newChilds.length; ++i) {
                    child = newChilds[i];
                    entry.add(child);
                }
                if (!create) {
                    for (i = 0; i < currentChilds.length; ++i) {
                        child = currentChilds[i];
                        if (child == null) continue;
                        this.check(root, child, false);
                    }
                }
                for (i = 0; i < newChilds.length; ++i) {
                    child = newChilds[i];
                    this.check(root, child, true);
                }
            } else {
                for (int i = 0; i < currentChilds.length; ++i) {
                    Entry child = currentChilds[i];
                    this.check(root, child, false);
                }
            }
        } else if (entry.isDelected()) {
            this.onDelete(root, entry);
        } else if (entry.hasChanged()) {
            this.onChange(root, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info((Object)"fam running");
        while (true) {
            Object object = this.mutexRunning;
            synchronized (object) {
                if (!this.running) {
                    break;
                }
            }
            this.doRun();
            ThreadUtils.sleep(this.delay);
        }
        log.info((Object)"fam exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        Map directories;
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Iterator it = directories.keySet().iterator();
        while (it.hasNext()) {
            Entry root;
            File directory = (File)it.next();
            if (!directory.exists()) continue;
            this.onStart(directory);
            Object object2 = this.mutexListeners;
            synchronized (object2) {
                root = (Entry)this.entries.get(directory);
                if (root == null) {
                    root = new Entry(directory, directory);
                    this.entries.put(directory, root);
                }
            }
            this.check(directory, root, false);
            this.onStop(directory);
        }
    }

    public class Entry {
        private final File root;
        private final File file;
        private long lastModified;
        private Set paths = new HashSet();
        private Set childs = new HashSet();
        private final boolean isDirectory;

        public Entry(File pRoot, File pFile) {
            this.root = pRoot;
            this.file = pFile;
            this.lastModified = -1L;
            this.isDirectory = this.file.isDirectory();
        }

        public boolean hasChanged() {
            long modified = this.file.lastModified();
            return modified != this.lastModified;
        }

        public boolean isDelected() {
            return !this.file.exists();
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public Entry[] getChilds() {
            Entry[] r = new Entry[this.childs.size()];
            this.childs.toArray(r);
            return r;
        }

        private FileFilter getFileFilter() {
            return new FileFilter(){

                public boolean accept(File pathname) {
                    String p = pathname.getAbsolutePath();
                    return !Entry.this.paths.contains(p);
                }
            };
        }

        public Entry[] getNonChilds() {
            File[] newFiles = this.file.listFiles(this.getFileFilter());
            Entry[] r = new Entry[newFiles.length];
            for (int i = 0; i < newFiles.length; ++i) {
                r[i] = new Entry(this.root, newFiles[i]);
            }
            return r;
        }

        public void add(Entry entry) {
            this.childs.add(entry);
            this.paths.add(entry.toString());
            FilesystemAlterationMonitor.this.onCreate(this.root, entry);
        }

        private void deleteChilds() {
            Entry[] childs = this.getChilds();
            for (int i = 0; i < childs.length; ++i) {
                Entry child = childs[i];
                this.delete(child);
            }
        }

        public void delete(Entry entry) {
            this.childs.remove(entry);
            this.paths.remove(entry.toString());
            entry.deleteChilds();
            FilesystemAlterationMonitor.this.onDelete(this.root, entry);
        }

        public File getFile() {
            return this.file;
        }

        public void markNotChanged() {
            this.lastModified = this.file.lastModified();
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }
}

