/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor.debugging;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.debugging.PrettyPrintWriter;
import com.opensymphony.webwork.views.freemarker.FreemarkerResult;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebuggingInterceptor
implements Interceptor {
    private static final long serialVersionUID = -3097324155953078783L;
    private static final Log log = LogFactory.getLog((Class)DebuggingInterceptor.class);
    private String[] ignorePrefixes = new String[]{"com.opensymphony.webwork.", "com.opensymphony.xwork.", "xwork."};
    private String[] _ignoreKeys = new String[]{"application", "session", "parameters", "request"};
    private HashSet ignoreKeys = new HashSet<String>(Arrays.asList(this._ignoreKeys));
    private static final String XML_MODE = "xml";
    private static final String CONSOLE_MODE = "console";
    private static final String COMMAND_MODE = "command";
    private static final String SESSION_KEY = "com.opensymphony.webwork.interceptor.debugging.VALUE_STACK";
    private static final String DEBUG_PARAM = "debug";
    private static final String EXPRESSION_PARAM = "expression";

    public void init() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation inv) throws Exception {
        boolean devMode = (Boolean)ActionContext.getContext().get((Object)"__devMode");
        boolean cont = true;
        if (devMode) {
            ActionContext ctx = ActionContext.getContext();
            String type = this.getParameter(DEBUG_PARAM);
            ctx.getParameters().remove(DEBUG_PARAM);
            if (XML_MODE.equals(type)) {
                inv.addPreResultListener(new PreResultListener(){

                    public void beforeResult(ActionInvocation inv, String result) {
                        DebuggingInterceptor.this.printContext();
                    }
                });
            } else if (CONSOLE_MODE.equals(type)) {
                inv.addPreResultListener(new PreResultListener(){

                    public void beforeResult(ActionInvocation inv, String actionResult) {
                        StringWriter writer = new StringWriter();
                        DebuggingInterceptor.this.printContext(new PrettyPrintWriter(writer));
                        String xml = writer.toString();
                        xml = xml.replaceAll("&", "&amp;");
                        xml = xml.replaceAll(">", "&gt;");
                        xml = xml.replaceAll("<", "&lt;");
                        ActionContext.getContext().put((Object)"debugXML", (Object)xml);
                        FreemarkerResult result = new FreemarkerResult();
                        result.setContentType("text/html");
                        result.setLocation("/com/opensymphony/webwork/interceptor/debugging/console.ftl");
                        result.setParse(false);
                        try {
                            result.execute(inv);
                        }
                        catch (Exception ex) {
                            log.error((Object)"Unable to create debugging console", (Throwable)ex);
                        }
                    }
                });
            } else if (COMMAND_MODE.equals(type)) {
                OgnlValueStack stack = (OgnlValueStack)ctx.getSession().get(SESSION_KEY);
                String cmd = this.getParameter(EXPRESSION_PARAM);
                HttpServletResponse res = ServletActionContext.getResponse();
                res.setContentType("text/plain");
                try {
                    PrintWriter writer = ServletActionContext.getResponse().getWriter();
                    writer.print(stack.findValue(cmd));
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                cont = false;
            }
        }
        if (cont) {
            try {
                String string = inv.invoke();
                return string;
            }
            finally {
                if (devMode) {
                    ActionContext ctx = ActionContext.getContext();
                    ctx.getSession().put(SESSION_KEY, ctx.get((Object)"com.opensymphony.xwork.util.OgnlValueStack.ValueStack"));
                }
            }
        }
        return null;
    }

    private String getParameter(String key) {
        String[] arr = (String[])ActionContext.getContext().getParameters().get(key);
        if (arr != null && arr.length > 0) {
            return arr[0];
        }
        return null;
    }

    protected void printContext() {
        HttpServletResponse res = ServletActionContext.getResponse();
        res.setContentType("text/xml");
        try {
            PrettyPrintWriter writer = new PrettyPrintWriter(ServletActionContext.getResponse().getWriter());
            this.printContext(writer);
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void printContext(PrettyPrintWriter writer) {
        ActionContext ctx = ActionContext.getContext();
        writer.startNode(DEBUG_PARAM);
        this.serializeIt(ctx.getParameters(), "parameters", writer, new ArrayList());
        writer.startNode("context");
        Map ctxMap = ctx.getContextMap();
        Iterator iterator = ctxMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            boolean print = !this.ignoreKeys.contains(key);
            for (int i = 0; i < this.ignorePrefixes.length; ++i) {
                if (!key.startsWith(this.ignorePrefixes[i])) continue;
                print = false;
                break;
            }
            if (!print) continue;
            this.serializeIt(ctxMap.get(key), key, writer, new ArrayList());
        }
        writer.endNode();
        this.serializeIt(ctx.getSession(), "request", writer, new ArrayList());
        this.serializeIt(ctx.getSession(), "session", writer, new ArrayList());
        OgnlValueStack stack = (OgnlValueStack)ctx.get((Object)"com.opensymphony.xwork.util.OgnlValueStack.ValueStack");
        this.serializeIt(stack.getRoot(), "valueStack", writer, new ArrayList());
        writer.endNode();
    }

    protected void serializeIt(Object bean, String name, PrettyPrintWriter writer, List stack) {
        writer.flush();
        if (bean != null && stack.contains(bean)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Circular reference detected, not serializing object: " + name));
            }
            return;
        }
        if (bean != null) {
            stack.add(bean);
        }
        if (bean == null) {
            return;
        }
        String clsName = bean.getClass().getName();
        writer.startNode(name);
        if (bean instanceof Collection) {
            Collection col = (Collection)bean;
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                this.serializeIt(iterator.next(), "value", writer, stack);
            }
        } else if (bean instanceof Map) {
            Map map = (Map)bean;
            Iterator mapIterator = map.keySet().iterator();
            while (mapIterator.hasNext()) {
                Object key = mapIterator.next();
                Object value = map.get(key);
                this.serializeIt(value, key.toString(), writer, stack);
            }
        } else if (bean.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(bean); ++i) {
                this.serializeIt(Array.get(bean, i), "arrayitem", writer, stack);
            }
        } else if (!(clsName != null && clsName.startsWith("org.opensymphony.webwork") || clsName != null && clsName.startsWith("com.opensymphony.xwork"))) {
            if (clsName.startsWith("java.lang")) {
                writer.setValue(bean.toString());
            } else {
                try {
                    BeanInfo info = Introspector.getBeanInfo(bean.getClass());
                    PropertyDescriptor[] props = info.getPropertyDescriptors();
                    for (int i = 0; i < props.length; ++i) {
                        String n = props[i].getName();
                        Method m = props[i].getReadMethod();
                        if (m == null) continue;
                        this.serializeIt(m.invoke(bean, null), n, writer, stack);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        writer.endNode();
        stack.remove(bean);
    }
}

