/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionMap
extends AbstractMap
implements Serializable {
    protected HttpSession session;
    protected Set entries;
    protected HttpServletRequest request;

    public SessionMap(HttpServletRequest request) {
        this.request = request;
        this.session = request.getSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.session == null) {
            return;
        }
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            this.session.invalidate();
            this.session = null;
            this.entries = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.session == null) {
            return;
        }
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            this.entries = null;
            Enumeration attributeNamesEnum = this.session.getAttributeNames();
            while (attributeNamesEnum.hasMoreElements()) {
                this.session.removeAttribute((String)attributeNamesEnum.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        if (this.session == null) {
            return Collections.EMPTY_SET;
        }
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            if (this.entries == null) {
                this.entries = new HashSet();
                Enumeration enumeration = this.session.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    final String key = enumeration.nextElement().toString();
                    final Object value = this.session.getAttribute(key);
                    this.entries.add(new Map.Entry(){

                        public boolean equals(Object obj) {
                            Map.Entry entry = (Map.Entry)obj;
                            return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                        }

                        public int hashCode() {
                            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                        }

                        public Object getKey() {
                            return key;
                        }

                        public Object getValue() {
                            return value;
                        }

                        public Object setValue(Object obj) {
                            SessionMap.this.session.setAttribute(key.toString(), obj);
                            return value;
                        }
                    });
                }
            }
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (this.session == null) {
            return null;
        }
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            return this.session.getAttribute(key.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        SessionMap sessionMap = this;
        synchronized (sessionMap) {
            if (this.session == null) {
                this.session = this.request.getSession(true);
            }
        }
        sessionMap = this.session;
        synchronized (sessionMap) {
            this.entries = null;
            this.session.setAttribute(key.toString(), value);
            return this.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        if (this.session == null) {
            return null;
        }
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            this.entries = null;
            Object value = this.get(key);
            this.session.removeAttribute(key.toString());
            return value;
        }
    }
}

