/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapperFactory;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletDispatcher
extends HttpServlet
implements WebWorkStatics {
    protected static final Log LOG = LogFactory.getLog((Class)ServletDispatcher.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        DispatcherUtils.initialize(this.getServletContext());
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        DispatcherUtils du = DispatcherUtils.getInstance();
        du.prepare(request, response);
        try {
            request = du.wrapRequest(request, this.getServletContext());
        }
        catch (IOException e) {
            String message = "Could not wrap servlet request with MultipartRequestWrapper!";
            LOG.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        ActionMapping mapping = ActionMapperFactory.getMapper().getMapping(request);
        if (mapping == null) {
            try {
                response.sendError(404);
            }
            catch (IOException e) {
                LOG.error((Object)"Could not send 404 after not finding any ActionMapping", (Throwable)e);
            }
            return;
        }
        du.serviceAction(request, response, this.getServletContext(), mapping);
    }
}

