/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.table.renderer;

import com.opensymphony.webwork.components.table.WebTable;
import com.opensymphony.webwork.components.table.renderer.AbstractCellRenderer;
import java.text.DecimalFormat;

public class NumericCellRenderer
extends AbstractCellRenderer {
    DecimalFormat _formater = new DecimalFormat();
    String _formatString = null;
    String _negativeColor = null;
    String _positiveColor = null;

    public String getCellValue(WebTable table, Object data, int row, int col) {
        StringBuffer retVal = new StringBuffer(128);
        if (data == null) {
            return "";
        }
        if (data instanceof Number) {
            double cellValue = ((Number)data).doubleValue();
            if (cellValue >= 0.0) {
                this.processNumber(retVal, this._positiveColor, cellValue);
            } else {
                this.processNumber(retVal, this._negativeColor, cellValue);
            }
            return retVal.toString();
        }
        return data.toString();
    }

    public void setFormatString(String format) {
        this._formatString = format;
        this._formater.applyPattern(this._formatString);
    }

    public void setNegativeColor(String color) {
        this._negativeColor = color;
    }

    public void setPositiveColor(String color) {
        this._positiveColor = color;
    }

    protected void processNumber(StringBuffer buf, String color, double cellValue) {
        if (color != null) {
            buf.append(" <font color='").append(color).append("'>");
        }
        buf.append(this._formater.format(cellValue));
        if (color != null) {
            buf.append("</font>");
        }
    }
}

