/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Date
extends Component {
    private static final Log LOG = LogFactory.getLog((Class)Date.class);
    public static final String DATETAG_PROPERTY = "webwork.date.format";
    public static final String DATETAG_PROPERTY_PAST = "webwork.date.format.past";
    private static final String DATETAG_DEFAULT_PAST = "{0} ago";
    public static final String DATETAG_PROPERTY_FUTURE = "webwork.date.format.future";
    private static final String DATETAG_DEFAULT_FUTURE = "in {0}";
    public static final String DATETAG_PROPERTY_SECONDS = "webwork.date.format.seconds";
    private static final String DATETAG_DEFAULT_SECONDS = "an instant";
    public static final String DATETAG_PROPERTY_MINUTES = "webwork.date.format.minutes";
    private static final String DATETAG_DEFAULT_MINUTES = "{0,choice,1#one minute|1<{0} minutes}";
    public static final String DATETAG_PROPERTY_HOURS = "webwork.date.format.hours";
    private static final String DATETAG_DEFAULT_HOURS = "{0,choice,1#one hour|1<{0} hours}{1,choice,0#|1#, one minute|1<, {1} minutes}";
    public static final String DATETAG_PROPERTY_DAYS = "webwork.date.format.days";
    private static final String DATETAG_DEFAULT_DAYS = "{0,choice,1#one day|1<{0} days}{1,choice,0#|1#, one hour|1<, {1} hours}";
    public static final String DATETAG_PROPERTY_YEARS = "webwork.date.format.years";
    private static final String DATETAG_DEFAULT_YEARS = "{0,choice,1#one year|1<{0} years}{1,choice,0#|1#, one day|1<, {1} days}";
    private String name;
    private String format;
    private boolean nice;

    public Date(OgnlValueStack stack) {
        super(stack);
    }

    private TextProvider findProviderInStack() {
        Iterator iterator = this.getStack().getRoot().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof TextProvider)) continue;
            return (TextProvider)o;
        }
        return null;
    }

    public String formatTime(TextProvider tp, java.util.Date date) {
        java.util.Date now = new java.util.Date();
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        long secs = Math.abs((now.getTime() - date.getTime()) / 1000L);
        long mins = secs / 60L;
        long sec = secs % 60L;
        int min = (int)mins % 60;
        long hours = mins / 60L;
        int hour = (int)hours % 24;
        int days = (int)hours / 24;
        int day = days % 365;
        int years = days / 365;
        if (years > 0) {
            args.add(new Long(years));
            args.add(new Long(day));
            args.add(sb);
            args.add(null);
            sb.append(tp.getText(DATETAG_PROPERTY_YEARS, DATETAG_DEFAULT_YEARS, args));
        } else if (day > 0) {
            args.add(new Long(day));
            args.add(new Long(hour));
            args.add(sb);
            args.add(null);
            sb.append(tp.getText(DATETAG_PROPERTY_DAYS, DATETAG_DEFAULT_DAYS, args));
        } else if (hour > 0) {
            args.add(new Long(hour));
            args.add(new Long(min));
            args.add(sb);
            args.add(null);
            sb.append(tp.getText(DATETAG_PROPERTY_HOURS, DATETAG_DEFAULT_HOURS, args));
        } else if (min > 0) {
            args.add(new Long(min));
            args.add(new Long(sec));
            args.add(sb);
            args.add(null);
            sb.append(tp.getText(DATETAG_PROPERTY_MINUTES, DATETAG_DEFAULT_MINUTES, args));
        } else {
            args.add(new Long(sec));
            args.add(sb);
            args.add(null);
            sb.append(tp.getText(DATETAG_PROPERTY_SECONDS, DATETAG_DEFAULT_SECONDS, args));
        }
        args.clear();
        args.add(sb.toString());
        if (date.before(now)) {
            return tp.getText(DATETAG_PROPERTY_PAST, DATETAG_DEFAULT_PAST, args);
        }
        return tp.getText(DATETAG_PROPERTY_FUTURE, DATETAG_DEFAULT_FUTURE, args);
    }

    public boolean end(Writer writer, String body) {
        TextProvider tp;
        String msg = null;
        OgnlValueStack stack = this.getStack();
        java.util.Date date = null;
        try {
            date = (java.util.Date)this.findValue(this.name);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not convert object with key '" + this.name + "' to a java.util.Date instance"));
            msg = "";
        }
        if (this.format != null) {
            this.format = this.findString(this.format);
        }
        if (date != null && (tp = this.findProviderInStack()) != null) {
            if (this.nice) {
                msg = this.formatTime(tp, date);
            } else if (this.format == null) {
                String globalFormat = null;
                globalFormat = tp.getText(DATETAG_PROPERTY);
                msg = globalFormat != null && !DATETAG_PROPERTY.equals(globalFormat) ? new SimpleDateFormat(globalFormat, ActionContext.getContext().getLocale()).format(date) : DateFormat.getDateTimeInstance(2, 2, ActionContext.getContext().getLocale()).format(date);
            } else {
                msg = new SimpleDateFormat(this.format, ActionContext.getContext().getLocale()).format(date);
            }
            if (msg != null) {
                try {
                    if (this.getId() == null) {
                        writer.write(msg);
                    } else {
                        stack.getContext().put(this.getId(), msg);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Could not write out Date tag", (Throwable)e);
                }
            }
        }
        return super.end(writer, "");
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setNice(boolean nice) {
        this.nice = nice;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isNice() {
        return this.nice;
    }
}

