/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRunGoalsPhase
extends AbstractReleasePhase {
    private Map<String, MavenExecutor> mavenExecutors;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, File workingDirectory, String additionalArguments) throws ReleaseExecutionException {
        return this.execute(releaseDescriptor, new DefaultReleaseEnvironment(), workingDirectory, additionalArguments);
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, File workingDirectory, String additionalArguments) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        try {
            String goals = this.getGoals(releaseDescriptor);
            if (!StringUtils.isEmpty(goals)) {
                this.logInfo(result, "Executing goals '" + goals + "'...");
                MavenExecutor mavenExecutor = this.mavenExecutors.get(releaseEnvironment.getMavenExecutorId());
                if (mavenExecutor == null) {
                    throw new ReleaseExecutionException("Cannot find Maven executor with id: " + releaseEnvironment.getMavenExecutorId());
                }
                mavenExecutor.executeGoals(this.determineWorkingDirectory(workingDirectory, releaseDescriptor.getScmRelativePathProjectDirectory()), goals, releaseEnvironment, releaseDescriptor.isInteractive(), additionalArguments, releaseDescriptor.getPomFileName(), result);
            }
        }
        catch (MavenExecutorException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
        result.setResultCode(0);
        return result;
    }

    public void setMavenExecutor(MavenExecutor mavenExecutor) {
        this.setMavenExecutor("forked-path", mavenExecutor);
    }

    public void setMavenExecutor(String id, MavenExecutor executor) {
        if (this.mavenExecutors == null) {
            this.mavenExecutors = new HashMap<String, MavenExecutor>();
        }
        this.mavenExecutors.put(id, executor);
    }

    protected abstract String getGoals(ReleaseDescriptor var1);

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        File workingDirectory = checkoutDirectory;
        if (StringUtils.isNotEmpty(relativePathProjectDirectory)) {
            workingDirectory = new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return workingDirectory;
    }
}

