/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plugins.variable.updater.PomReader;
import com.atlassian.bamboo.plugins.variable.updater.VersionAdvancer;
import com.atlassian.bamboo.plugins.variable.updater.message.UpdatePlanVariableMessage;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessage;
import com.atlassian.bamboo.v2.build.agent.remote.sender.BambooAgentMessageSender;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class VariableUpdater {
    private final String buildDirectory;
    private final Map<String, String> customVariables;
    private final ResultKey resultKey;

    public VariableUpdater(ResultKey buildResultKey, String buildDirectory, Map<String, String> customVariables) {
        this.buildDirectory = buildDirectory;
        this.customVariables = customVariables;
        this.resultKey = buildResultKey;
    }

    static List<VariableDefinition> retrievePlanGlobalVariables(VariableDefinitionManager variableDefinitionManager, PlanManager planManager, String topLevelPlanKey, String variableName, boolean includeGlobals, boolean useBranchVariables) {
        ArrayList variablesToChange = Lists.newArrayList();
        try {
            Plan planByKey = planManager.getPlanByKey(PlanKeys.getPlanKey((String)topLevelPlanKey));
            boolean isBranch = planByKey.hasMaster();
            if (isBranch && !useBranchVariables) {
                planByKey = planByKey.getMaster();
            }
            CollectionUtils.addIgnoreNull((Collection)variablesToChange, (Object)variableDefinitionManager.getPlanVariableByKey((PlanIdentifier)planByKey, variableName));
            if (variablesToChange.isEmpty() && isBranch && useBranchVariables) {
                CollectionUtils.addIgnoreNull((Collection)variablesToChange, (Object)variableDefinitionManager.getPlanVariableByKey((PlanIdentifier)planByKey.getMaster(), variableName));
            }
        }
        catch (IllegalArgumentException e) {
            return Lists.newArrayList();
        }
        if (includeGlobals) {
            CollectionUtils.addIgnoreNull((Collection)variablesToChange, (Object)variableDefinitionManager.getGlobalVariableByKey(variableName));
        }
        return variablesToChange;
    }

    static List<VariableDefinition> retrieveDeploymentGlobalVariables(VariableDefinitionManager variableDefinitionManager, String deploymentEnvironmentId, final String variableName, boolean includeGlobals) {
        Long deploymentId;
        try {
            deploymentId = Long.parseLong(deploymentEnvironmentId);
        }
        catch (NumberFormatException e) {
            return Lists.newArrayList();
        }
        ArrayList variablesToChange = Lists.newArrayList();
        if (includeGlobals) {
            CollectionUtils.addIgnoreNull((Collection)variablesToChange, (Object)variableDefinitionManager.getGlobalVariableByKey(variableName));
        }
        List envVariables = variableDefinitionManager.getDeploymentEnvironmentVariables(deploymentId.longValue());
        Iterables.addAll((Collection)variablesToChange, (Iterable)Iterables.filter((Iterable)envVariables, (Predicate)new Predicate<VariableDefinition>(){

            public boolean apply(@Nullable VariableDefinition variableDefinition) {
                return variableName.equals(variableDefinition.getKey());
            }
        }));
        return variablesToChange;
    }

    void savePlanVariable(String planKey, String variableName, boolean includeGlobals, String newValue, boolean isRunningRemote, BuildLogger buildLogger, boolean useBranchVariables) {
        if (!isRunningRemote) {
            VariableUpdater.savePlanVariableServerSide(this.resultKey, planKey, variableName, newValue, includeGlobals, useBranchVariables);
        } else {
            BambooAgentMessageSender bambooAgentMessageSender = (BambooAgentMessageSender)ContainerManager.getComponent((String)"bambooAgentMessageSender");
            bambooAgentMessageSender.send((BambooAgentMessage)new UpdatePlanVariableMessage(this.resultKey, planKey, variableName, newValue, includeGlobals, useBranchVariables));
        }
    }

    public static void savePlanVariableServerSide(ResultKey resultKey, String planKeyOrEnvironmentId, String variableName, String newValue, boolean includeGlobals, boolean useBranchVariables) {
        VariableDefinitionManager variableDefinitionManager = (VariableDefinitionManager)ContainerManager.getComponent((String)"variableDefinitionManager", VariableDefinitionManager.class);
        BuildLoggerManager buildLoggerManager = (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
        PlanManager planManager = (PlanManager)ContainerManager.getComponent((String)"planManager");
        BuildLogger buildLogger = buildLoggerManager.getLogger(resultKey);
        List<VariableDefinition> planVariablesToChange = VariableUpdater.retrievePlanGlobalVariables(variableDefinitionManager, planManager, planKeyOrEnvironmentId, variableName, includeGlobals, useBranchVariables);
        planVariablesToChange.addAll(VariableUpdater.retrieveDeploymentGlobalVariables(variableDefinitionManager, planKeyOrEnvironmentId, variableName, includeGlobals));
        for (VariableDefinition variableDefinition : planVariablesToChange) {
            if (!variableDefinition.getValue().equals(newValue)) {
                variableDefinition.setValue(newValue);
                variableDefinitionManager.saveVariableDefinition(variableDefinition);
                buildLogger.addBuildLogEntry(String.format("Set %s level variable %s to new value %s", variableDefinition.getVariableType(), variableDefinition.getKey(), newValue));
                continue;
            }
            buildLogger.addBuildLogEntry(String.format("Not touching variable %s of type %s, as it's already %s", variableDefinition.getKey(), variableDefinition.getVariableType().name(), newValue));
        }
        if (planVariablesToChange.isEmpty()) {
            buildLogger.addErrorLogEntry(String.format("It wasn't possible to retrieve any PLAN scoped variable %s", variableName));
            throw new IllegalArgumentException("No such variable " + variableName);
        }
    }

    void saveJobOrResultVariable(final String variableName, String newValue, BuildLogger buildLogger, VariableContext variableContext, SCOPE scope) {
        String oldValue;
        Optional variableDefinitionContext = Iterables.tryFind(variableContext.getEffectiveVariables().values(), (Predicate)new Predicate<VariableDefinitionContext>(){

            public boolean apply(@javax.annotation.Nullable VariableDefinitionContext input) {
                return StringUtils.equals(variableName, input.getKey());
            }
        });
        String string = oldValue = variableDefinitionContext.isPresent() ? ((VariableDefinitionContext)variableDefinitionContext.get()).getValue() : null;
        if (scope == SCOPE.JOB) {
            this.customVariables.put(variableName, newValue);
            buildLogger.addBuildLogEntry(String.format("Changing variable %s of type JOB from %s to %s", variableName, oldValue, newValue));
        } else if (scope == SCOPE.RESULT) {
            variableContext.addResultVariable(variableName, newValue);
            buildLogger.addBuildLogEntry(String.format("Changing variable %s of type RESULT from %s to %s", variableName, oldValue, newValue));
        } else {
            throw new IllegalArgumentException("This method can only save variables whose scope is JOB or RESULT, not " + (Object)((Object)scope));
        }
    }

    public void update(String planKeyOrEnvironemntId, String variableName, String currentValue, String valueRegex, boolean includeGlobals, SCOPE variableScope, INCREMENT_STRATEGY strategy, boolean isRemote, BuildLogger buildLogger, VariableContext vairableContext, boolean useBranchVariables) throws TaskException {
        String newValue;
        try {
            newValue = new VersionAdvancer().advanceVariable(strategy, currentValue, valueRegex);
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry("Unable to advance " + variableName, (Throwable)e);
            throw new TaskException("Failed to increase variable: ", (Throwable)e);
        }
        this.update(planKeyOrEnvironemntId, variableName, newValue, includeGlobals, variableScope, isRemote, buildLogger, vairableContext, useBranchVariables);
    }

    public void update(String planKeyOrEnvironmentId, String variableName, String newValue, boolean includeGlobals, SCOPE variableScope, boolean isRemote, BuildLogger buildLogger, VariableContext variableContext, boolean useBranchVariables) throws TaskException {
        try {
            if (variableScope == SCOPE.JOB || variableScope == SCOPE.RESULT) {
                this.saveJobOrResultVariable(variableName, newValue, buildLogger, variableContext, variableScope);
            } else {
                this.savePlanVariable(planKeyOrEnvironmentId, variableName, includeGlobals, newValue, isRemote, buildLogger, useBranchVariables);
            }
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry("Unable to save " + variableName, (Throwable)e);
            throw new TaskException("Failed to save variable: ", (Throwable)e);
        }
    }

    public void readFromPom(String topLevelPlanKey, String variableName, String currentValue, boolean includeGlobals, SCOPE variableScope, SAVE_STRATEGY strategy, boolean removeSnapshot, String pomFile, boolean isRunningOnRemote, BuildLogger buildLogger, VariableContext variableContext, boolean useBranchVariables) throws TaskException {
        try {
            String newValue;
            if (strategy == SAVE_STRATEGY.READ_SAVE) {
                String pomVersion = new PomReader(buildLogger, new File(this.buildDirectory), pomFile).retrieveValue();
                newValue = removeSnapshot ? pomVersion.replace("-SNAPSHOT", "") : pomVersion;
            } else {
                newValue = currentValue;
            }
            if (SCOPE.JOB == variableScope || SCOPE.RESULT == variableScope) {
                this.saveJobOrResultVariable(variableName, newValue, buildLogger, variableContext, variableScope);
            } else {
                this.savePlanVariable(topLevelPlanKey, variableName, includeGlobals, newValue, isRunningOnRemote, buildLogger, useBranchVariables);
            }
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry(e.getMessage(), (Throwable)e);
            throw new TaskException("Failed to read variable: ", (Throwable)e);
        }
    }

    public void readFromFile(String topLevelPlanKey, String variableName, String currentValue, boolean includeGlobals, SCOPE variableScope, SAVE_STRATEGY strategy, String filename, boolean isRunningOnRemote, BuildLogger buildLogger, VariableContext variableContext, boolean useBranchVariables) throws TaskException {
        try {
            String newValue;
            if (strategy == SAVE_STRATEGY.READ_SAVE) {
                List list = FileUtils.readLines((File)new File(this.buildDirectory, filename));
                newValue = StringUtils.join((Collection)list, "\n");
            } else {
                newValue = currentValue;
            }
            if (SCOPE.JOB == variableScope || SCOPE.RESULT == variableScope) {
                this.saveJobOrResultVariable(variableName, newValue, buildLogger, variableContext, variableScope);
            } else {
                this.savePlanVariable(topLevelPlanKey, variableName, includeGlobals, newValue, isRunningOnRemote, buildLogger, useBranchVariables);
            }
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry(e.getMessage(), (Throwable)e);
            throw new TaskException("Failed to read variable: ", (Throwable)e);
        }
    }

    public static enum SAVE_STRATEGY {
        READ_SAVE,
        SKIP;

    }

    public static enum INCREMENT_STRATEGY {
        REGEX,
        MAVENRELEASE,
        NONE,
        DEPLOYMENT;

    }

    public static enum SCOPE {
        JOB,
        PLAN,
        RESULT;

    }
}

